/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.ChannelUtil;
import gov.usgs.volcanoes.swarm.data.CachedDataSource;
import gov.usgs.volcanoes.swarm.data.DataSourceType;
import gov.usgs.volcanoes.swarm.data.Gulper;
import gov.usgs.volcanoes.swarm.data.GulperList;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkChannelInfo;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkClient;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkGulper;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedLinkSource
extends SeismicDataSource {
    private static final int gulpDelay = 1000;
    private static final int gulpSize = 60;
    private static final String infoFileText;
    private static final Logger logger;
    private static final String logPrefixText;
    private static final String typeString;
    private String host;
    private File infoStringFile;
    private String params;
    private int port;
    private final List<SeedLinkClient> seedLinkClientList = new ArrayList<SeedLinkClient>();

    public SeedLinkSource() {
    }

    public static String toString(Object obj) {
        if (obj instanceof Wave) {
            Wave wave = (Wave)obj;
            return "Wave(s=" + Util.j2KToDateString(wave.getStartTime()) + ", e=" + Util.j2KToDateString(wave.getEndTime()) + ", sr=" + wave.getSamplingRate() + ", n=" + wave.buffer.length + ")";
        }
        if (obj instanceof HelicorderData) {
            HelicorderData hd = (HelicorderData)obj;
            return "HelicorderData(s=" + Util.j2KToDateString(hd.getStartTime()) + ", e=" + Util.j2KToDateString(hd.getEndTime()) + ")";
        }
        return String.valueOf(obj);
    }

    public SeedLinkSource(SeedLinkSource sls) {
        this(sls.name, sls.params);
    }

    public SeedLinkSource(String name, String s) {
        this.name = name;
        this.parse(s);
    }

    @Override
    public void parse(String params) {
        this.params = params;
        String[] ss = params.split(":");
        int ssIndex = 0;
        this.host = ss[ssIndex++];
        this.port = Integer.parseInt(ss[ssIndex++]);
        if (infoFileText != null) {
            this.infoStringFile = new File(infoFileText + this.host + this.port + ".xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<SeedLinkClient> list = this.seedLinkClientList;
        synchronized (list) {
            if (this.seedLinkClientList.size() != 0) {
                logger.fine(logPrefixText + "close the data source");
                for (SeedLinkClient client : this.seedLinkClientList) {
                    client.close();
                }
                this.seedLinkClientList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeedLinkClient createClient() {
        SeedLinkClient client = new SeedLinkClient(this.host, this.port);
        List<SeedLinkClient> list = this.seedLinkClientList;
        synchronized (list) {
            this.seedLinkClientList.add(client);
        }
        return client;
    }

    @Override
    public Gulper createGulper(GulperList gl, String k, String ch, double t1, double t2, int size, int delay) {
        return new SeedLinkGulper(gl, k, this, ch, t1, t2, size, delay);
    }

    @Override
    public List<String> getChannels() {
        SeedLinkChannelInfo seedLinkChannelInfo = new SeedLinkChannelInfo(this);
        List<String> channels = null;
        try {
            String infoString;
            if (this.infoStringFile != null && this.infoStringFile.canRead()) {
                infoString = SeedLinkChannelInfo.readFile(this.infoStringFile);
            } else {
                infoString = this.getInfoString();
                if (this.infoStringFile != null && infoString.length() != 0) {
                    SeedLinkChannelInfo.writeString(this.infoStringFile, infoString);
                }
            }
            if (infoString.length() != 0) {
                seedLinkChannelInfo.parse(infoString);
                channels = seedLinkChannelInfo.getChannels();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, logPrefixText + "could not get channels", ex);
        }
        if (channels == null || channels.size() == 0) {
            logger.warning(logPrefixText + "could not get channels");
            return Collections.emptyList();
        }
        ChannelUtil.assignChannels(channels, this);
        return Collections.unmodifiableList(channels);
    }

    @Override
    public SeismicDataSource getCopy() {
        return new SeedLinkSource(this);
    }

    private String getGulperKey(String station) {
        return typeString + ":" + station;
    }

    @Override
    public HelicorderData getHelicorder(String scnl, double t1, double t2, GulperListener gl) {
        HelicorderData hd = CachedDataSource.getInstance().getHelicorder(scnl, t1, t2, gl);
        if (hd == null || hd.rows() == 0 || hd.getStartTime() - t1 > 10.0 || hd.getEndTime() < t2) {
            this.requestGulper(scnl, t1, t2, gl);
        } else if (hd.getEndTime() < t2) {
            this.requestGulper(scnl, hd.getEndTime(), t2, gl);
        }
        Level level = Level.FINE;
        if (logger.isLoggable(level)) {
            logger.log(level, logPrefixText + "getHelicorder(scnl=" + scnl + ", start=" + Util.j2KToDateString(t1) + ", end=" + Util.j2KToDateString(t2) + ")\nDATA=" + (hd == null ? "NONE" : SeedLinkSource.toString(hd)));
        }
        return hd;
    }

    public String getInfoString() {
        SeedLinkClient client = this.createClient();
        String infoString = client.getInfoString();
        this.removeClient(client);
        return infoString;
    }

    @Override
    public Wave getWave(String scnl, double t1, double t2) {
        Level level;
        double now;
        Wave wave = CachedDataSource.getInstance().getWave(scnl, t1, t2);
        if (wave == null && t1 <= (now = Util.nowJ2K())) {
            SeedLinkClient client = this.createClient();
            wave = client.getWave(scnl, t1, t2);
            this.removeClient(client);
        }
        if (logger.isLoggable(level = Level.FINE)) {
            logger.log(level, logPrefixText + "getWave(scnl=" + scnl + ", start=" + Util.j2KToDateString(t1) + ", end=" + Util.j2KToDateString(t2) + ")\nDATA=" + (wave == null ? "NONE" : SeedLinkSource.toString(wave)));
        }
        return wave;
    }

    @Override
    public synchronized boolean isActiveSource() {
        return true;
    }

    @Override
    public synchronized void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
        GulperList.INSTANCE.killGulper(this.getGulperKey(station), gl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClient(SeedLinkClient client) {
        List<SeedLinkClient> list = this.seedLinkClientList;
        synchronized (list) {
            this.seedLinkClientList.remove(client);
        }
    }

    protected void requestGulper(String scnl, double t1, double t2, GulperListener gl) {
        GulperList.INSTANCE.requestGulper(this.getGulperKey(scnl), gl, this, scnl, t1, t2, 60, 1000);
    }

    @Override
    public String toConfigString() {
        return String.format("%s;%s:%s:%d", this.name, typeString, this.host, this.port);
    }

    static {
        typeString = DataSourceType.getShortName(SeedLinkSource.class);
        logger = SeedLinkLog.logger;
        logPrefixText = SeedLinkSource.class.getName() + ": ";
        infoFileText = System.getProperty(typeString + "infofile");
    }
}

