/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

public class StartEndTime {
    private double endTime;
    private double startTime;

    public StartEndTime() {
        this(Double.NaN, Double.NaN);
    }

    public StartEndTime(double startTime, double endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public StartEndTime(StartEndTime o) {
        this(o.getStartTime(), o.getEndTime());
    }

    public void clear() {
        this.startTime = Double.NaN;
        this.endTime = Double.NaN;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public boolean isEmpty() {
        return Double.isNaN(this.startTime);
    }

    public void set(StartEndTime o) {
        this.startTime = o.startTime;
        this.endTime = o.endTime;
    }

    public void setEndTime(double d) {
        this.endTime = d;
    }

    public void setStartTime(double d) {
        this.startTime = d;
    }

    public void update(double startTime, double endTime) {
        if (this.isEmpty()) {
            this.startTime = startTime;
            this.endTime = endTime;
        } else {
            if (startTime < this.startTime) {
                this.startTime = startTime;
            }
            if (endTime > this.endTime) {
                this.endTime = endTime;
            }
        }
    }
}

