/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.map;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.RectangleRenderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.Metadata;
import gov.usgs.volcanoes.swarm.SCNL;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwingWorker;
import gov.usgs.volcanoes.swarm.heli.HelicorderViewerFrame;
import gov.usgs.volcanoes.swarm.map.MapFrame;
import gov.usgs.volcanoes.swarm.map.MapPanel;
import gov.usgs.volcanoes.swarm.wave.WaveViewPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class MapMiniPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255, 64);
    private static final Color LABEL_BACKGROUND_COLOR = new Color(255, 255, 255, 192);
    private static final long serialVersionUID = 1L;
    public static final Font FONT = Font.decode("dialog-PLAIN-10");
    private int labelHeight = 13;
    private int labelFontSize = 10;
    private int timeFontSize = 10;
    private static final int[] SIZES = new int[]{200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700};
    private int sizeIndex = 3;
    private Metadata activeMetadata;
    private boolean activeMetadataChosen = false;
    private SortedMap<String, Metadata> metadataList;
    private WaveViewPanel wavePanel;
    private boolean waveVisible = false;
    private Line2D.Double line;
    private int labelWidth = 1;
    private JLabel close;
    private JPopupMenu popup;
    private static final Color NORMAL_BACKGROUND = new Color(255, 255, 255, 128);
    private static final Color MOUSEOVER_BACKGROUND = new Color(128, 255, 128, 128);
    private static final Color WAVE_BACKGROUND = new Color(255, 255, 255, 128);
    private Color titleBackground = NORMAL_BACKGROUND;
    private MapPanel parent;
    private boolean selected;
    private Position position = Position.UNSET;
    private Point2D.Double manualPositionXY;
    private double[] pendingRequest;
    private boolean working;
    private int startX;
    private int startY;
    private int deltaX;
    private int deltaY;

    public MapMiniPanel(MapPanel p) {
        this.parent = p;
        this.metadataList = new TreeMap<String, Metadata>();
        this.setSize(this.labelWidth, this.labelHeight);
        this.setCursor(Cursor.getDefaultCursor());
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.setLayout(null);
    }

    public void saveLayout(ConfigFile cf, String prefix) {
        cf.put(prefix + ".sizeIndex", Integer.toString(this.sizeIndex));
        cf.put(prefix + ".activeChannel", this.activeMetadata.getChannel());
        int x = -1;
        int y = -1;
        if (this.position == Position.MANUAL_SET) {
            x = (int)this.manualPositionXY.x;
            y = (int)this.manualPositionXY.y;
        }
        cf.put(prefix + ".x", Integer.toString(x));
        cf.put(prefix + ".y", Integer.toString(y));
        this.wavePanel.getSettings().save(cf, prefix + ".settings");
    }

    public void processLayout(ConfigFile cf) {
        int x = Integer.parseInt(cf.getString("x"));
        int y = Integer.parseInt(cf.getString("y"));
        this.setManualPosition(new Point2D.Double(x, y));
        this.position = Position.MANUAL_SET;
        this.sizeIndex = Integer.parseInt(cf.getString("sizeIndex"));
        this.setLocation(x, y);
        if (this.wavePanel == null) {
            this.createWaveViewPanel();
        }
        this.wavePanel.getSettings().set(cf.getSubConfig("settings"));
        this.activeMetadata = (Metadata)this.metadataList.get(cf.getString("activeChannel"));
        if (!this.waveVisible) {
            this.toggleWave();
        } else {
            this.resetWave();
        }
    }

    public Metadata getActiveMetadata() {
        return this.activeMetadata;
    }

    public void addMetadata(Metadata md) {
        this.metadataList.put(md.getChannel(), md);
        if (this.activeMetadata == null) {
            this.activeMetadata = md;
        }
        if (!this.activeMetadataChosen) {
            SCNL as = this.activeMetadata.getSCNL();
            SCNL ms = md.getSCNL();
            if (ms.channel != null && ms.channel.endsWith("Z")) {
                if (as.channel.endsWith("Z")) {
                    if (ms.channel.charAt(0) < as.channel.charAt(0)) {
                        this.activeMetadata = md;
                    } else if (ms.channel.charAt(0) == as.channel.charAt(0) && as.location != null && ms.location == null) {
                        this.activeMetadata = md;
                    }
                } else {
                    this.activeMetadata = md;
                }
            }
        }
        this.popup = null;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position p) {
        this.position = p;
    }

    public void setLine(Line2D.Double l) {
        this.line = l;
    }

    public void setManualPosition(Point2D.Double p) {
        this.manualPositionXY = p;
    }

    public Point2D.Double getManualPosition() {
        return this.manualPositionXY;
    }

    public boolean isWaveVisible() {
        return this.waveVisible;
    }

    public WaveViewPanel getWaveViewPanel() {
        if (this.wavePanel == null) {
            this.createWaveViewPanel();
        }
        return this.wavePanel;
    }

    public void changeSize(int ds) {
        if (this.waveVisible) {
            this.sizeIndex += ds;
            if (this.sizeIndex < 0) {
                this.sizeIndex = 0;
            }
            if (this.sizeIndex >= SIZES.length) {
                this.sizeIndex = SIZES.length - 1;
            }
            this.resetWave();
            this.getParent().repaint();
        }
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color;
        this.repaint();
    }

    private void createWaveViewPanel() {
        this.wavePanel = new WaveViewPanel();
        this.wavePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MapMiniPanel.this.determineSelection(e);
            }

            public void mouseEntered(MouseEvent e) {
                MapMiniPanel.this.mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                MapMiniPanel.this.mouseExited(e);
            }
        });
        this.wavePanel.setUseFilterLabel(false);
        this.wavePanel.setDisplayTitle(false);
        this.wavePanel.setDataSource(this.activeMetadata.source);
        this.wavePanel.setChannel(this.activeMetadata.getChannel());
    }

    private void createCloseLabel() {
        this.close = new JLabel(Icons.close_view);
        this.close.setSize(16, 16);
        this.close.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (MapMiniPanel.this.waveVisible) {
                    MapMiniPanel.this.toggleWave();
                }
            }

            public void mouseEntered(MouseEvent e) {
                MapMiniPanel.this.mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                MapMiniPanel.this.mouseExited(e);
            }
        });
    }

    private void resetWave() {
        if (this.wavePanel == null) {
            this.createWaveViewPanel();
        }
        this.removeAll();
        int w = SIZES[this.sizeIndex];
        int h = (int)Math.round((double)w * 80.0 / 300.0);
        this.setSize(w, h);
        this.timeFontSize = Math.min(11, Math.max(9, (int)Math.round((double)h / 10.0)));
        this.labelFontSize = Math.max(10, (int)Math.round((double)h / 8.0));
        this.labelHeight = this.labelFontSize + 4;
        this.wavePanel.setOffsets(13, 0, 0, this.timeFontSize + 4);
        this.wavePanel.setSize(w - 1, h - this.labelHeight);
        this.wavePanel.setBackgroundColor(WAVE_BACKGROUND);
        this.wavePanel.setFrameDecorator(new MapWaveDecorator());
        this.wavePanel.setLocation(0, this.labelHeight - 1);
        this.add(this.wavePanel);
        if (this.close == null) {
            this.createCloseLabel();
        }
        this.close.setLocation(SIZES[this.sizeIndex] - 16, -2);
        this.add(this.close);
        this.adjustLine();
        this.updateWave(this.parent.getStartTime(), this.parent.getEndTime(), true);
    }

    public void changeChannel(Metadata md) {
        this.activeMetadata = md;
        if (this.wavePanel != null) {
            this.wavePanel.setWave(null, 0.0, 0.0);
            this.updateWave(this.wavePanel.getStartTime(), this.wavePanel.getEndTime());
        }
    }

    private synchronized boolean isWorking() {
        return this.working;
    }

    private synchronized void setWorking(boolean b) {
        this.working = b;
    }

    private synchronized void setPendingRequest(double st, double et) {
        this.pendingRequest = (double[])(Double.isNaN(st) ? null : new double[]{st, et});
    }

    private synchronized double[] getPendingRequest() {
        return this.pendingRequest;
    }

    public boolean updateWave(double st, double et) {
        return this.updateWave(st, et, false, false);
    }

    public boolean updateWave(double st, double et, boolean repaint) {
        return this.updateWave(st, et, false, repaint);
    }

    public boolean updateWave(final double st, final double et, boolean reenter, final boolean repaint) {
        if (!this.waveVisible || this.activeMetadata.source == null) {
            return false;
        }
        if (this.isWorking() && !reenter) {
            this.setPendingRequest(st, et);
            return false;
        }
        this.setWorking(true);
        if (reenter) {
            this.setPendingRequest(Double.NaN, Double.NaN);
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                MapFrame.getInstance().getThrobber().increment();
                MapMiniPanel.this.wavePanel.setWorking(true);
                MapMiniPanel.this.wavePanel.setDataSource(((MapMiniPanel)MapMiniPanel.this).activeMetadata.source);
                MapMiniPanel.this.wavePanel.setChannel(MapMiniPanel.this.activeMetadata.getChannel());
                Wave cw = MapMiniPanel.this.wavePanel.getWave();
                if (cw != null && cw.overlaps(st, et)) {
                    Wave w2;
                    boolean before = ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.isUseCache();
                    ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.setUseCache(false);
                    if (cw.getEndTime() < et && (w2 = ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.getWave(MapMiniPanel.this.activeMetadata.getChannel(), cw.getEndTime() - 10.0, et)) != null) {
                        cw = cw.combine(w2);
                    }
                    if (cw.getStartTime() > st && (w2 = ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.getWave(MapMiniPanel.this.activeMetadata.getChannel(), st, cw.getStartTime() + 10.0)) != null) {
                        cw = cw.combine(w2);
                    }
                    cw = cw.subset(st, Math.min(et, cw.getEndTime()));
                    ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.setUseCache(before);
                } else {
                    cw = null;
                }
                if (cw == null) {
                    cw = ((MapMiniPanel)MapMiniPanel.this).activeMetadata.source.getWave(MapMiniPanel.this.activeMetadata.getChannel(), st, et);
                }
                MapMiniPanel.this.wavePanel.setWave(cw, st, et);
                return null;
            }

            public void finished() {
                double[] pr = MapMiniPanel.this.getPendingRequest();
                if (pr != null) {
                    MapMiniPanel.this.repaint();
                    MapMiniPanel.this.updateWave(pr[0], pr[1], true, repaint);
                } else {
                    MapMiniPanel.this.setWorking(false);
                }
                MapFrame.getInstance().getThrobber().decrement();
                MapMiniPanel.this.wavePanel.setWorking(false);
                if (repaint) {
                    MapMiniPanel.this.wavePanel.repaint();
                }
            }
        };
        worker.start();
        return true;
    }

    public void toggleWave() {
        boolean bl = this.waveVisible = !this.waveVisible;
        if (this.waveVisible) {
            this.resetWave();
        } else {
            this.parent.deselectPanel(this);
            this.labelFontSize = 10;
            this.labelHeight = 13;
            this.setSize(this.labelWidth, this.labelHeight);
            if (this.parent.getLabelSetting() == MapPanel.LabelSetting.NONE) {
                this.parent.resetImage(false);
            }
        }
        this.adjustLine();
        this.getParent().repaint();
    }

    protected void createPopup() {
        this.popup = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        for (final Metadata md : this.metadataList.values()) {
            JRadioButtonMenuItem rmi = new JRadioButtonMenuItem(md.getChannel());
            rmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MapMiniPanel.this.changeChannel(md);
                    MapMiniPanel.this.activeMetadataChosen = true;
                }
            });
            group.add(rmi);
            this.popup.add(rmi);
            if (md != this.activeMetadata) continue;
            rmi.setSelected(true);
        }
    }

    protected void doPopup(MouseEvent e) {
        if (this.popup == null) {
            this.createPopup();
        }
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public String getLabel() {
        String label = null;
        if (this.waveVisible) {
            label = this.activeMetadata.getSCNL().toString();
            if (this.metadataList.size() > 1) {
                label = label + "+";
            }
        } else {
            label = this.activeMetadata.getSCNL().station;
        }
        return label;
    }

    public void paint(Graphics g) {
        boolean wave;
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(FONT);
        String label = this.getLabel();
        boolean bl = wave = this.waveVisible && this.wavePanel != null;
        if (!wave) {
            if (this.labelWidth == 1) {
                FontMetrics fm = g.getFontMetrics(FONT);
                this.labelWidth = fm.stringWidth(label) + 5;
            }
            this.setSize(this.labelWidth, this.getHeight());
            this.adjustLine();
        }
        g2.setColor(this.titleBackground);
        g2.fillRect(0, 0, this.getWidth() - 1, this.labelHeight - 1);
        super.paint(g);
        Font font = Font.decode("dialog-BOLD-" + this.labelFontSize);
        g2.setFont(font);
        g2.setColor(Color.BLACK);
        g2.drawString(label, 2, this.labelFontSize);
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    protected void determineSelection(MouseEvent e) {
        if (e.isControlDown()) {
            if (this.selected) {
                this.parent.deselectPanel(this);
            } else {
                this.parent.addSelectedPanel(this);
            }
        } else {
            this.parent.setSelectedPanel(this);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.determineSelection(e);
        this.setPosition(Position.MANUAL_SET);
        Point pt = this.getLocation();
        this.manualPositionXY = new Point2D.Double(pt.x, pt.y);
        if (e.getClickCount() == 2) {
            if (this.activeMetadata.source != null) {
                HelicorderViewerFrame hvf = Swarm.openHelicorder(this.activeMetadata.source, this.activeMetadata.getChannel(), Double.NaN);
                if (Swarm.isFullScreenMode()) {
                    hvf.setPinned(true);
                }
            }
        } else if (!this.waveVisible) {
            this.toggleWave();
        }
    }

    public void setSelected(boolean b) {
        this.selected = b;
        if (this.selected) {
            this.setTitleBackground(MOUSEOVER_BACKGROUND);
        } else {
            this.setTitleBackground(NORMAL_BACKGROUND);
        }
    }

    public void mouseEntered(MouseEvent e) {
        MapFrame.getInstance().setStatusText(this.activeMetadata.getSCNL().station + ": " + Util.lonLatToString(this.activeMetadata.getLonLat()));
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.parent.requestFocusInWindow();
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
        Point p = this.getLocation();
        this.startX = p.x;
        this.startY = p.y;
        this.deltaX = e.getX();
        this.deltaY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        }
    }

    public void adjustLine() {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        Line2D.Double[] lines = new Line2D.Double[]{new Line2D.Double(p.x, p.y, this.line.x2, this.line.y2), new Line2D.Double(p.x + d.width - 1, p.y, this.line.x2, this.line.y2), new Line2D.Double(p.x + d.width - 1, p.y + d.height, this.line.x2, this.line.y2), new Line2D.Double(p.x, p.y + d.height, this.line.x2, this.line.y2), new Line2D.Double(p.x + d.width / 2, p.y + d.height, this.line.x2, this.line.y2), new Line2D.Double(p.x + d.width / 2, p.y, this.line.x2, this.line.y2), new Line2D.Double(p.x + d.width - 1, p.y + d.height / 2, this.line.x2, this.line.y2), new Line2D.Double(p.x, p.y + d.height / 2, this.line.x2, this.line.y2)};
        double min = Double.MAX_VALUE;
        Line2D.Double shortest = null;
        for (int i = 0; i < lines.length; ++i) {
            Line2D.Double l = lines[i];
            double len = (l.x1 - l.x2) * (l.x1 - l.x2) + (l.y1 - l.y2) * (l.y1 - l.y2);
            if (!(len < min)) continue;
            min = len;
            shortest = l;
        }
        this.line.setLine(shortest);
    }

    public void mouseDragged(MouseEvent e) {
        this.setPosition(Position.MANUAL_SET);
        this.setLocation(this.startX + e.getX() - this.deltaX, this.startY + e.getY() - this.deltaY);
        Point p = this.getLocation();
        this.startX = p.x;
        this.startY = p.y;
        this.manualPositionXY = new Point2D.Double(p.x, p.y);
        this.adjustLine();
        this.getParent().repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int cnt = -e.getWheelRotation();
        this.changeSize(cnt);
    }

    private class MapWaveDecorator
    extends FrameDecorator {
        private Font font;
        private FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);

        private void createAxis(FrameRenderer fr) {
            fr.createEmptyAxis();
            AxisRenderer ar = fr.getAxis();
            ar.createDefault();
            ar.setBackgroundColor(BACKGROUND_COLOR);
            if (((MapMiniPanel)MapMiniPanel.this).wavePanel.getSettings().filterOn) {
                TextRenderer tr = MapMiniPanel.this.wavePanel.getFilterLabel();
                tr.horizJustification = 3;
                tr.x = fr.getGraphWidth() + fr.getGraphX();
                tr.y = fr.getGraphY() + 11;
                tr.color = Color.RED;
                ar.addPostRenderer(tr);
            }
        }

        private void setTimeAxis(FrameRenderer fr) {
            int hTicks = 6;
            Object[] stt = SmartTick.autoTimeTick(fr.getMinXAxis(), fr.getMaxXAxis(), hTicks);
            if (stt != null) {
                fr.getAxis().createVerticalGridLines((double[])stt[0]);
            }
            double[] bt = (double[])stt[0];
            String[] labels = (String[])stt[1];
            for (int i = 0; i < bt.length; ++i) {
                TextRenderer tr = new TextRenderer();
                tr.text = labels[i];
                tr.x = (float)fr.getXPixel(bt[i]);
                tr.y = fr.getGraphY() + fr.getGraphHeight() + MapMiniPanel.this.timeFontSize + 2;
                tr.color = Color.BLACK;
                tr.horizJustification = 1;
                tr.font = this.font;
                fr.getAxis().addPostRenderer(tr);
            }
        }

        private void setLeftLabel(FrameRenderer fr, String label) {
            TextRenderer tr = new TextRenderer();
            tr.color = Color.BLACK;
            tr.text = label;
            tr.x = 4.0;
            tr.y = fr.getGraphY() + fr.getGraphHeight() / 2 + 8;
            tr.horizJustification = 1;
            tr.orientation = -90.0f;
            fr.getAxis().addPostRenderer(tr);
        }

        private void setMinMaxBoxes(FrameRenderer fr, double min, double max) {
            int w;
            AxisRenderer ar = fr.getAxis();
            TextRenderer ultr = new TextRenderer();
            ultr.color = Color.BLACK;
            ultr.text = String.format("%.0f", max);
            ultr.horizJustification = 3;
            ultr.y = fr.getGraphY() + MapMiniPanel.this.timeFontSize;
            ultr.font = this.font;
            TextRenderer lltr = new TextRenderer();
            lltr.color = Color.BLACK;
            lltr.text = String.format("%.0f", min);
            lltr.horizJustification = 3;
            lltr.y = fr.getGraphY() + fr.getGraphHeight() - 1;
            lltr.font = this.font;
            ultr.backgroundWidth = w = (int)Math.round(Math.max(this.font.getStringBounds(ultr.text, this.frc).getWidth(), this.font.getStringBounds(lltr.text, this.frc).getWidth())) + 3;
            lltr.backgroundWidth = w;
            ultr.x = fr.getGraphX() + w;
            lltr.x = fr.getGraphX() + w;
            RectangleRenderer ulrr = new RectangleRenderer();
            ulrr.rect = new Rectangle2D.Double(fr.getGraphX(), fr.getGraphY(), w + 1, MapMiniPanel.this.timeFontSize + 2);
            ulrr.color = Color.BLACK;
            ulrr.backgroundColor = LABEL_BACKGROUND_COLOR;
            RectangleRenderer llrr = new RectangleRenderer();
            llrr.rect = new Rectangle2D.Double(fr.getGraphX(), fr.getGraphY() + fr.getGraphHeight() - MapMiniPanel.this.timeFontSize - 2, w + 1, MapMiniPanel.this.timeFontSize + 2);
            llrr.color = Color.BLACK;
            llrr.backgroundColor = LABEL_BACKGROUND_COLOR;
            ar.addPostRenderer(ulrr);
            ar.addPostRenderer(llrr);
            ar.addPostRenderer(ultr);
            ar.addPostRenderer(lltr);
        }

        public void decorateWave(FrameRenderer fr) {
            this.createAxis(fr);
            this.setTimeAxis(fr);
            String label = "Counts";
            if (MapMiniPanel.this.activeMetadata.getUnit() != null) {
                label = MapMiniPanel.this.activeMetadata.getUnit();
            }
            this.setLeftLabel(fr, label);
            double m = MapMiniPanel.this.activeMetadata.getMultiplier();
            double b = MapMiniPanel.this.activeMetadata.getOffset();
            this.setMinMaxBoxes(fr, fr.getMinY() * m + b, fr.getMaxY() * m + b);
        }

        public void decorateSpectra(FrameRenderer fr) {
            this.createAxis(fr);
            if (((MapMiniPanel)MapMiniPanel.this).wavePanel.getSettings().logPower) {
                this.setLeftLabel(fr, "log(P)");
            } else {
                this.setLeftLabel(fr, "Power");
            }
            this.setMinMaxBoxes(fr, fr.getMinY(), fr.getMaxY());
        }

        public void decorateSpectrogram(FrameRenderer fr) {
            this.createAxis(fr);
            this.setTimeAxis(fr);
            String label = "Freq";
            this.setLeftLabel(fr, label);
            this.setMinMaxBoxes(fr, fr.getMinY(), fr.getMaxY());
        }

        public void decorate(FrameRenderer fr) {
            this.font = Font.decode("dialog-PLAIN-" + MapMiniPanel.this.timeFontSize);
            switch (((MapMiniPanel)MapMiniPanel.this).wavePanel.getSettings().viewType) {
                case WAVE: {
                    this.decorateWave(fr);
                    break;
                }
                case SPECTRA: {
                    this.decorateSpectra(fr);
                    break;
                }
                case SPECTROGRAM: {
                    this.decorateSpectrogram(fr);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        UNSET,
        AUTOMATIC,
        MANUAL_SET,
        MANUAL_UNSET,
        HIDDEN;

    }
}

