/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.rsam;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.math.BinSize;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.SwarmDialog;
import gov.usgs.volcanoes.swarm.rsam.CountsPeriods;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettings;
import gov.usgs.volcanoes.swarm.rsam.ValuesPeriods;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RsamViewSettingsDialog
extends SwarmDialog {
    private static final long serialVersionUID = 1L;
    private JPanel dialogPanel;
    private static RsamViewSettingsDialog dialog;
    private RsamViewSettings settings;
    private ButtonGroup viewGroup;
    private JRadioButton valuesButton;
    private JRadioButton countsButton;
    private JCheckBox detrend;
    private JComboBox valuesPeriod;
    private JComboBox countsPeriod;
    private JCheckBox runningMedianButton;
    private JTextField runningMedianPeriod;
    private JCheckBox runningMeanButton;
    private JTextField runningMeanPeriod;
    private JTextField eventThreshold;
    private JTextField eventRatio;
    private JTextField eventMaxLength;
    private JComboBox binSize;
    private JCheckBox autoScale;
    private JTextField scaleMax;
    private JTextField scaleMin;

    private RsamViewSettingsDialog() {
        super(applicationFrame, "RSAM Settings", true);
        this.setIconImage(Icons.rsam_values.getImage());
        this.createUI();
        this.setSizeAndLocation();
    }

    public static RsamViewSettingsDialog getInstance(RsamViewSettings s) {
        if (dialog == null) {
            dialog = new RsamViewSettingsDialog();
        }
        RsamViewSettingsDialog.dialog.settings = s;
        dialog.setToCurrent();
        return dialog;
    }

    public void setToCurrent() {
        switch (this.settings.getType()) {
            case VALUES: {
                this.valuesButton.setSelected(true);
                break;
            }
            case COUNTS: {
                this.countsButton.setSelected(true);
            }
        }
        this.detrend.setSelected(this.settings.detrend);
        this.valuesPeriod.setSelectedItem((Object)ValuesPeriods.fromS(this.settings.valuesPeriodS));
        this.countsPeriod.setSelectedItem((Object)CountsPeriods.fromS(this.settings.countsPeriodS));
        this.runningMedianButton.setSelected(this.settings.runningMedian);
        this.runningMedianPeriod.setText(String.format("%.1f", this.settings.runningMedianPeriodS));
        this.runningMedianPeriod.setEnabled(this.settings.runningMedian);
        this.runningMeanButton.setSelected(this.settings.runningMean);
        this.runningMeanPeriod.setText(String.format("%.1f", this.settings.runningMeanPeriodS));
        this.runningMeanPeriod.setEnabled(this.settings.runningMean);
        this.eventThreshold.setText(String.format("%d", this.settings.eventThreshold));
        this.eventRatio.setText(String.format("%.1f", this.settings.eventRatio));
        this.eventMaxLength.setText(String.format("%.1f", this.settings.eventMaxLengthS));
        this.binSize.setSelectedItem((Object)this.settings.binSize);
        this.autoScale.setSelected(this.settings.getAutoScale());
        this.scaleMax.setText("" + this.settings.scaleMax);
        this.scaleMax.setEnabled(!this.autoScale.isSelected());
        this.scaleMin.setText("" + this.settings.scaleMin);
        this.scaleMin.setEnabled(!this.autoScale.isSelected());
    }

    private void createComponents() {
        this.viewGroup = new ButtonGroup();
        this.valuesButton = new JRadioButton("RSAM values");
        this.countsButton = new JRadioButton("Event counts");
        this.viewGroup.add(this.valuesButton);
        this.viewGroup.add(this.countsButton);
        this.valuesPeriod = new JComboBox<ValuesPeriods>(ValuesPeriods.values());
        this.countsPeriod = new JComboBox<CountsPeriods>(CountsPeriods.values());
        this.detrend = new JCheckBox("Detrend (linear)");
        this.runningMedianButton = new JCheckBox("Running median");
        this.runningMedianPeriod = new JTextField(4);
        this.runningMedianButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsamViewSettingsDialog.this.runningMedianPeriod.setEnabled(RsamViewSettingsDialog.this.runningMedianButton.isSelected());
            }
        });
        this.runningMeanButton = new JCheckBox("Running mean");
        this.runningMeanPeriod = new JTextField(4);
        this.runningMeanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsamViewSettingsDialog.this.runningMeanPeriod.setEnabled(RsamViewSettingsDialog.this.runningMeanButton.isSelected());
            }
        });
        this.autoScale = new JCheckBox("Auto scale");
        this.autoScale.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RsamViewSettingsDialog.this.scaleMax.setEnabled(!RsamViewSettingsDialog.this.autoScale.isSelected());
                RsamViewSettingsDialog.this.scaleMin.setEnabled(!RsamViewSettingsDialog.this.autoScale.isSelected());
            }
        });
        this.scaleMax = new JTextField(4);
        this.scaleMin = new JTextField(4);
        this.eventThreshold = new JTextField(4);
        this.eventRatio = new JTextField(4);
        this.eventMaxLength = new JTextField(4);
        this.binSize = new JComboBox<BinSize>(BinSize.values());
    }

    protected void createUI() {
        super.createUI();
        this.createComponents();
        FormLayout layout = new FormLayout("left:65dlu, 1dlu, left:60dlu, 3dlu, left:30dlu, 3dlu, left:30dlu, 3dlu, left:30dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator("View");
        builder.nextLine();
        builder.append((Component)this.valuesButton);
        builder.append((Component)this.countsButton);
        builder.nextLine();
        builder.appendSeparator("RSAM Options");
        builder.nextLine();
        builder.append((Component)this.detrend);
        builder.nextColumn(2);
        builder.add((Component)new JLabel("Period:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.add((Component)this.valuesPeriod, cc.xyw(builder.getColumn(), builder.getRow(), 3));
        builder.nextLine();
        builder.append((Component)this.autoScale);
        builder.nextColumn(2);
        builder.add((Component)new JLabel("Min:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.add((Component)this.scaleMin, cc.xyw(builder.getColumn(), builder.getRow(), 1));
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.nextColumn(4);
        builder.add((Component)new JLabel("Max:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.add((Component)this.scaleMax, cc.xyw(builder.getColumn(), builder.getRow(), 1));
        builder.nextLine();
        builder.appendSeparator("Event Options");
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Event threshold:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.eventThreshold);
        builder.add((Component)new JLabel("Period:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.add((Component)this.countsPeriod, cc.xyw(builder.getColumn(), builder.getRow(), 3));
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Event ratio:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.eventRatio);
        builder.add((Component)new JLabel("Bin size:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.add((Component)this.binSize, cc.xyw(builder.getColumn(), builder.getRow(), 3));
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Event max length:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.eventMaxLength);
        this.dialogPanel = builder.getPanel();
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    public boolean allowOK() {
        String message = null;
        try {
            message = "Error in running median period.";
            double rm = Double.parseDouble(this.runningMedianPeriod.getText());
            message = "Error in running mean period.";
            double rmp = Double.parseDouble(this.runningMeanPeriod.getText());
            message = "Error in event threshold.";
            double et = Double.parseDouble(this.eventThreshold.getText());
            message = "Error in event ratio.";
            double er = Double.parseDouble(this.eventRatio.getText());
            message = "Error in event maximum length.";
            double eml = Double.parseDouble(this.eventMaxLength.getText());
            if (!this.autoScale.isSelected()) {
                message = "Error in Scale min";
                int sm = Integer.parseInt(this.scaleMin.getText());
                message = "Error in Scale max";
                int sn = Integer.parseInt(this.scaleMax.getText());
            }
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }

    public void wasOK() {
        try {
            this.settings.valuesPeriodS = ((ValuesPeriods)((Object)this.valuesPeriod.getSelectedItem())).getPeriodS();
            this.settings.countsPeriodS = ((CountsPeriods)((Object)this.countsPeriod.getSelectedItem())).getPeriodS();
            this.settings.detrend = this.detrend.isSelected();
            this.settings.runningMean = this.runningMeanButton.isSelected();
            this.settings.runningMeanPeriodS = Double.parseDouble(this.runningMeanPeriod.getText());
            this.settings.runningMedian = this.runningMedianButton.isSelected();
            this.settings.runningMedianPeriodS = Double.parseDouble(this.runningMedianPeriod.getText());
            this.settings.eventThreshold = Integer.parseInt(this.eventThreshold.getText());
            this.settings.eventRatio = Double.parseDouble(this.eventRatio.getText());
            this.settings.eventMaxLengthS = Double.parseDouble(this.eventMaxLength.getText());
            this.settings.binSize = (BinSize)((Object)this.binSize.getSelectedItem());
            this.settings.setAutoScale(this.autoScale.isSelected());
            if (!this.autoScale.isSelected()) {
                this.settings.scaleMax = Integer.parseInt(this.scaleMax.getText());
                this.settings.scaleMin = Integer.parseInt(this.scaleMin.getText());
            }
            if (this.valuesButton.isSelected()) {
                this.settings.setType(RsamViewSettings.ViewType.VALUES);
            } else {
                this.settings.setType(RsamViewSettings.ViewType.COUNTS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Illegal values.", "Options Error", 0);
        }
    }
}

