/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.rsam;

import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.SwarmUtil;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettings;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettingsDialog;
import gov.usgs.volcanoes.swarm.rsam.SettingsListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class RsamViewSettingsToolbar
implements SettingsListener {
    private JButton waveSet;
    private JToggleButton valuesToggle;
    private JToggleButton countsToggle;
    private ButtonGroup rsamTypes;
    private RsamViewSettings settings;

    public RsamViewSettingsToolbar(RsamViewSettings s, JToolBar dest, JComponent keyComp) {
        this.settings = s;
        this.createUI(dest, keyComp);
        this.settings.addListener(this);
    }

    public void createUI(JToolBar dest, JComponent keyComp) {
        this.waveSet = SwarmUtil.createToolBarButton(Icons.wavesettings, "RSAM view settings (?)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsamViewSettingsDialog wvsd = RsamViewSettingsDialog.getInstance(RsamViewSettingsToolbar.this.settings);
                wvsd.setVisible(true);
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "shift SLASH", "settings", this.waveSet);
        dest.add(this.waveSet);
        this.rsamTypes = new ButtonGroup();
        this.valuesToggle = SwarmUtil.createToolBarToggleButton(Icons.rsam_values, "Values view (V or ,)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsamViewSettingsToolbar.this.settings.setType(RsamViewSettings.ViewType.VALUES);
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "COMMA", "wave1", this.valuesToggle);
        Util.mapKeyStrokeToButton(keyComp, "W", "wave2", this.valuesToggle);
        dest.add(this.valuesToggle);
        this.rsamTypes.add(this.valuesToggle);
        this.rsamTypes.setSelected(this.valuesToggle.getModel(), true);
        this.countsToggle = SwarmUtil.createToolBarToggleButton(Icons.rsam_counts, "Counts view (C or .)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RsamViewSettingsToolbar.this.settings.setType(RsamViewSettings.ViewType.COUNTS);
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "PERIOD", "spectra1", this.countsToggle);
        Util.mapKeyStrokeToButton(keyComp, "S", "spectra2", this.countsToggle);
        dest.add(this.countsToggle);
        this.rsamTypes.add(this.countsToggle);
    }

    public void settingsChanged() {
        if (this.settings.getType() == RsamViewSettings.ViewType.VALUES) {
            this.rsamTypes.setSelected(this.valuesToggle.getModel(), true);
        } else {
            this.rsamTypes.setSelected(this.countsToggle.getModel(), true);
        }
    }
}

