/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.wave;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.RectangleRenderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.Kioskable;
import gov.usgs.volcanoes.swarm.Metadata;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import gov.usgs.volcanoes.swarm.SwarmFrame;
import gov.usgs.volcanoes.swarm.SwarmUtil;
import gov.usgs.volcanoes.swarm.Throbber;
import gov.usgs.volcanoes.swarm.chooser.DataChooser;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.wave.MultiMonitorSettingsDialog;
import gov.usgs.volcanoes.swarm.wave.SwarmMultiMonitors;
import gov.usgs.volcanoes.swarm.wave.WaveClipboardFrame;
import gov.usgs.volcanoes.swarm.wave.WaveViewPanel;
import gov.usgs.volcanoes.swarm.wave.WaveViewPanelAdapter;
import gov.usgs.volcanoes.swarm.wave.WaveViewSettings;
import gov.usgs.volcanoes.swarm.wave.WaveViewSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class MultiMonitor
extends SwarmFrame
implements Kioskable {
    public static final long serialVersionUID = -1L;
    public static final int[] SPANS = new int[]{15, 30, 60, 120, 180, 240, 300, 600, 900, 1200, 1800, 3600, 7200};
    private int span = 15;
    private List<WaveViewPanel> panels;
    private SeismicDataSource dataSource;
    private JToolBar toolbar;
    private JButton settingsButton;
    private JButton removeButton;
    private JPanel wavePanel;
    private JPanel mainPanel;
    private JButton compXButton;
    private JButton expXButton;
    private JButton optionsButton;
    private JButton copyButton;
    private JToggleButton pauseButton;
    private int bottomLabelHeight = 20;
    private int selectedIndex = -1;
    private static final Color SELECT_COLOR = new Color(204, 204, 255);
    private Throbber throbber;
    private Map<String, Wave> waveMap;
    private Timer timer;
    private long slideInterval = 500L;
    private long refreshInterval = 1000L;
    private SlideTask slideTask;
    private RefreshTask refreshTask;
    private int labelFontSize;
    private Font font;
    private FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
    private Border border;
    private double pauseStartTime = Double.NaN;
    private boolean sliding = false;

    public MultiMonitor(SeismicDataSource sds) {
        super("Monitor, [" + sds.getName() + "]", true, true, true, true);
        this.waveMap = Collections.synchronizedMap(new HashMap());
        this.setFrameIcon(Icons.monitor);
        this.dataSource = sds;
        this.dataSource.setUseCache(false);
        this.panels = new ArrayList<WaveViewPanel>();
        this.createUI();
        this.timer = new Timer("Monitor Timer [" + sds.getName() + "]");
        this.setIntervals();
    }

    public void saveLayout(ConfigFile cf, String prefix) {
        cf.put("monitor", prefix);
        super.saveLayout(cf, prefix);
        cf.put(prefix + ".source", this.dataSource.getName());
        for (int i = 0; i < this.panels.size(); ++i) {
            String p = prefix + ".wave-" + i;
            WaveViewPanel wvp = this.panels.get(i);
            cf.put(p + ".channel", wvp.getChannel());
            wvp.getSettings().save(cf, p);
        }
        cf.put(prefix + ".waves", Integer.toString(this.panels.size()));
        cf.put(prefix + ".span", Integer.toString(this.span));
        cf.put(prefix + ".slideInterval", Long.toString(this.slideInterval));
        cf.put(prefix + ".refreshInterval", Long.toString(this.refreshInterval));
    }

    public void processLayout(ConfigFile cf) {
        this.processStandardLayout(cf);
        this.span = this.getSpan(cf.getString("span"), cf.getString("spanIndex"));
        this.slideInterval = Long.parseLong(cf.getString("slideInterval"));
        this.refreshInterval = Long.parseLong(cf.getString("refreshInterval"));
        int waves = Integer.parseInt(cf.getString("waves"));
        for (int i = 0; i < waves; ++i) {
            String w = "wave-" + i;
            String channel = cf.getString(w + ".channel");
            ConfigFile scf = cf.getSubConfig(w);
            WaveViewPanel wvp = this.addChannel(channel);
            wvp.getSettings().set(scf);
        }
    }

    private int getSpan(String inSpan, String inSpanIndex) {
        int span = inSpan != null ? Integer.parseInt(inSpan) : SPANS[Integer.parseInt(inSpanIndex)];
        return span;
    }

    private void setIntervals() {
        if (this.slideTask != null) {
            this.slideTask.cancel();
        }
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.timer.purge();
        this.slideTask = new SlideTask();
        this.refreshTask = new RefreshTask();
        this.timer.schedule((TimerTask)this.slideTask, 0L, this.slideInterval);
        this.timer.schedule((TimerTask)this.refreshTask, 0L, this.refreshInterval);
    }

    public void setDataSource(SeismicDataSource sds) {
        this.dataSource = sds;
    }

    public SeismicDataSource getDataSource() {
        return this.dataSource;
    }

    public long getSlideInterval() {
        return this.slideInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getSpan() {
        return this.span;
    }

    public void setRefreshInterval(long ms) {
        this.refreshInterval = ms;
        this.setIntervals();
    }

    public void setSlideInterval(long ms) {
        this.slideInterval = ms;
        this.setIntervals();
    }

    public void setSpan(int span) {
        this.span = span;
    }

    private int previousSpan() {
        for (int i = SPANS.length; i > 0; --i) {
            if (SPANS[i - 1] >= this.span) continue;
            return SPANS[i - 1];
        }
        return SPANS[0];
    }

    private int nextSpan() {
        for (int i = 0; i < SPANS.length; ++i) {
            if (SPANS[i] <= this.span) continue;
            return SPANS[i];
        }
        return SPANS[SPANS.length - 1];
    }

    protected void createUI() {
        this.setSize(600, 700);
        this.setLocation(100, 0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.toolbar = SwarmUtil.createToolBar();
        this.optionsButton = SwarmUtil.createToolBarButton(Icons.settings, "Monitor options", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                MultiMonitorSettingsDialog mmsd = MultiMonitorSettingsDialog.getInstance(MultiMonitor.this);
                mmsd.setVisible(true);
            }
        });
        this.toolbar.add(this.optionsButton);
        this.toolbar.addSeparator();
        this.compXButton = SwarmUtil.createToolBarButton(Icons.xminus, "Shrink time axis (Alt-left arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                MultiMonitor.this.span = MultiMonitor.this.previousSpan();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", this.compXButton);
        this.toolbar.add(this.compXButton);
        this.expXButton = SwarmUtil.createToolBarButton(Icons.xplus, "Expand time axis (Alt-right arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                MultiMonitor.this.span = MultiMonitor.this.nextSpan();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", this.expXButton);
        this.toolbar.add(this.expXButton);
        this.pauseButton = SwarmUtil.createToolBarToggleButton(Icons.pause, "Pause the monitor (P)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                if (!MultiMonitor.this.pauseButton.isSelected()) {
                    MultiMonitor.this.setPauseStartTime(Double.NaN);
                } else {
                    MultiMonitor.this.setPauseStartTime(MultiMonitor.this.getTimeWindow()[0]);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "P", "pause", this.pauseButton);
        this.toolbar.add(this.pauseButton);
        this.toolbar.addSeparator();
        this.settingsButton = SwarmUtil.createToolBarButton(Icons.wavesettings, "Settings for selected wave", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                if (MultiMonitor.this.selectedIndex >= 0) {
                    WaveViewPanel panel = (WaveViewPanel)MultiMonitor.this.panels.get(MultiMonitor.this.selectedIndex);
                    WaveViewSettingsDialog wvsd = WaveViewSettingsDialog.getInstance(panel.getSettings());
                    wvsd.setVisible(true);
                }
            }
        });
        this.toolbar.add(this.settingsButton);
        this.copyButton = SwarmUtil.createToolBarButton(Icons.clipboard, "Copy waves to clipboard (C or Ctrl-C)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                for (WaveViewPanel panel : MultiMonitor.this.panels) {
                    if (panel == null) continue;
                    WaveViewPanel p = new WaveViewPanel(panel);
                    p.setDataSource(MultiMonitor.this.dataSource.getCopy());
                    WaveClipboardFrame cb = WaveClipboardFrame.getInstance();
                    cb.setVisible(true);
                    cb.addWave(p);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "C", "clipboard1", this.copyButton);
        Util.mapKeyStrokeToButton(this, "control C", "clipboard2", this.copyButton);
        this.toolbar.add(this.copyButton);
        this.toolbar.addSeparator();
        this.removeButton = SwarmUtil.createToolBarButton(Icons.delete, "Remove selected wave from monitor", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiMonitor.this.requestFocus();
                if (MultiMonitor.this.selectedIndex >= 0) {
                    MultiMonitor.this.removeWaveAtIndex(MultiMonitor.this.selectedIndex);
                    if (MultiMonitor.this.panels.size() == 0) {
                        MultiMonitor.this.selectedIndex = -1;
                    } else if (MultiMonitor.this.panels.size() == MultiMonitor.this.selectedIndex) {
                        MultiMonitor.this.selectedIndex--;
                    }
                    if (MultiMonitor.this.selectedIndex != -1) {
                        MultiMonitor.this.select((WaveViewPanel)MultiMonitor.this.panels.get(MultiMonitor.this.selectedIndex));
                    }
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "DELETE", "delete", this.removeButton);
        this.toolbar.add(this.removeButton);
        Util.mapKeyStrokeToAction(this, "UP", "up", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                if (MultiMonitor.this.selectedIndex > 0) {
                    MultiMonitor.this.deselect();
                    MultiMonitor.this.selectedIndex--;
                    MultiMonitor.this.select((WaveViewPanel)MultiMonitor.this.panels.get(MultiMonitor.this.selectedIndex));
                }
            }
        });
        Util.mapKeyStrokeToAction(this, "DOWN", "down", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                if (MultiMonitor.this.selectedIndex < MultiMonitor.this.panels.size() - 1) {
                    MultiMonitor.this.deselect();
                    MultiMonitor.this.selectedIndex++;
                    MultiMonitor.this.select((WaveViewPanel)MultiMonitor.this.panels.get(MultiMonitor.this.selectedIndex));
                }
            }
        });
        this.toolbar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolbar.add(this.throbber);
        this.mainPanel.add((Component)this.toolbar, "North");
        this.wavePanel = new WavePanel();
        this.wavePanel.setLayout(null);
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 3, 3), BorderFactory.createLineBorder(Color.GRAY, 1));
        this.wavePanel.setBorder(this.border);
        this.mainPanel.add((Component)this.wavePanel, "Center");
        this.createListeners();
        this.setContentPane(this.mainPanel);
        this.setVisible(true);
    }

    private void createListeners() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                if (MultiMonitor.this.selectedIndex != -1) {
                    String ch = ((WaveViewPanel)MultiMonitor.this.panels.get(MultiMonitor.this.selectedIndex)).getChannel();
                    DataChooser.getInstance().setNearest(ch);
                }
            }

            public void internalFrameOpened(InternalFrameEvent e) {
                MultiMonitor.this.resizeWaves();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                MultiMonitor.this.throbber.close();
                MultiMonitor.this.selectedIndex = -1;
                MultiMonitor.this.timer.cancel();
                MultiMonitor.this.dataSource.close();
                MultiMonitor.this.panels.clear();
                MultiMonitor.this.wavePanel.removeAll();
                MultiMonitor.this.waveMap.clear();
                MultiMonitor.this.dispose();
                SwarmMultiMonitors.removeMonitor(MultiMonitor.this);
            }
        });
        this.setDefaultCloseOperation(1);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown() && e.getKeyCode() == 82) {
                    for (WaveViewPanel panel : MultiMonitor.this.panels) {
                        panel.resetAutoScaleMemory();
                    }
                }
            }
        });
    }

    public synchronized WaveViewPanel addChannel(String ch) {
        final WaveViewPanel panel = new WaveViewPanel();
        panel.setChannel(ch);
        panel.setOffsets(-1, 0, 0, 0);
        panel.setWorking(true);
        panel.setDisplayTitle(false);
        panel.setFrameDecorator(new MonitorWaveDecorator(panel));
        this.panels.add(panel);
        this.wavePanel.add(panel);
        panel.addListener(new WaveViewPanelAdapter(){

            public void mousePressed(WaveViewPanel src, MouseEvent e, boolean dragging) {
                MultiMonitor.this.requestFocusInWindow();
                MultiMonitor.this.select(panel);
            }
        });
        this.resizeWaves();
        return panel;
    }

    public void deselect() {
        if (this.selectedIndex >= 0) {
            WaveViewPanel panel = this.panels.get(this.selectedIndex);
            this.setBackgroundColor(panel, this.selectedIndex);
            panel.createImage();
            panel.repaint();
        }
    }

    public void select(WaveViewPanel p) {
        this.deselect();
        for (int i = 0; i < this.panels.size(); ++i) {
            WaveViewPanel panel = this.panels.get(i);
            if (panel != p) continue;
            this.selectedIndex = i;
            DataChooser.getInstance().setNearest(panel.getChannel());
            panel.setBackgroundColor(SELECT_COLOR);
            panel.createImage();
            panel.repaint();
            break;
        }
        this.repaint();
    }

    public void removeWaveAtIndex(int i) {
        WaveViewPanel wvp = this.panels.get(i);
        this.waveMap.remove(wvp.getChannel());
        this.panels.remove(i);
        this.wavePanel.remove(wvp);
        this.resizeWaves();
    }

    public void removeAllWaves() {
        this.waveMap.clear();
        this.panels.clear();
        this.wavePanel.removeAll();
        this.resizeWaves();
    }

    private void setBackgroundColor(WaveViewPanel wvp, int i) {
        if (i % 2 == 1) {
            wvp.setBackgroundColor(Color.WHITE);
        } else {
            wvp.setBackgroundColor(new Color(230, 230, 230));
        }
    }

    private void resizeWaves() {
        if (this.panels.size() == 0 || this.wavePanel == null || this.wavePanel.getWidth() <= 0 || this.wavePanel.getHeight() <= 0) {
            this.repaint();
            return;
        }
        int area = this.wavePanel.getHeight() * this.wavePanel.getWidth();
        this.bottomLabelHeight = (int)((double)area / 18000.0);
        this.bottomLabelHeight = Math.max(this.bottomLabelHeight, 12);
        this.bottomLabelHeight = Math.min(this.bottomLabelHeight, 26);
        Insets insets = this.wavePanel.getInsets();
        int ah = this.wavePanel.getHeight() - insets.top - insets.bottom - this.bottomLabelHeight;
        int ww = this.wavePanel.getWidth() - insets.left - insets.right;
        double dy = (double)ah / (double)this.panels.size();
        int wh = (int)Math.round(dy);
        int th = wh * this.panels.size();
        int dh = th - ah;
        int rh = insets.top;
        for (int i = 0; i < this.panels.size(); ++i) {
            WaveViewPanel wvp = this.panels.get(i);
            int awh = wh;
            if (dh < 0) {
                ++awh;
                ++dh;
            } else if (dh > 0) {
                --awh;
                --dh;
            }
            wvp.setSize(ww, awh);
            wvp.setLocation(insets.left, rh);
            this.setBackgroundColor(wvp, i);
            rh += awh;
        }
        this.labelFontSize = Math.min(36, wh / 3);
        boolean done = false;
        while (!done) {
            this.font = Font.decode("dialog-BOLD-" + this.labelFontSize);
            Rectangle2D r = this.font.getStringBounds("XXXX XX XXX", this.frc);
            if (r.getWidth() / (double)ww < 0.25 || this.labelFontSize <= 8) {
                done = true;
                continue;
            }
            --this.labelFontSize;
        }
        this.repaint();
    }

    private double[] getTimeWindow() {
        double[] times = new double[2];
        if (Double.isNaN(this.pauseStartTime)) {
            times[1] = CurrentTime.getInstance().nowJ2K();
            times[0] = times[1] - (double)this.span;
        } else {
            times[0] = this.pauseStartTime;
            times[1] = times[0] + (double)this.span;
        }
        return times;
    }

    private synchronized void slide() {
        if (this.sliding) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                MultiMonitor.this.sliding = true;
                double[] times = MultiMonitor.this.getTimeWindow();
                double now = times[1];
                double start = times[0];
                for (int i = 0; i < MultiMonitor.this.panels.size(); ++i) {
                    WaveViewPanel waveViewPanel = (WaveViewPanel)MultiMonitor.this.panels.get(i);
                    Wave wave = (Wave)MultiMonitor.this.waveMap.get(waveViewPanel.getChannel());
                    waveViewPanel.setWave(wave, start, now);
                }
                MultiMonitor.this.wavePanel.repaint();
                MultiMonitor.this.sliding = false;
            }
        };
        Thread worker = new Thread(r);
        worker.start();
    }

    public void setPauseStartTime(double start) {
        this.pauseStartTime = start;
        this.pauseButton.setSelected(!Double.isNaN(this.pauseStartTime));
    }

    public double getPauseStartTime() {
        return this.pauseStartTime;
    }

    private void refresh() {
        if (this.throbber.getCount() >= 1) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                MultiMonitor.this.throbber.increment();
                String channel = null;
                double[] times = MultiMonitor.this.getTimeWindow();
                double now = times[1];
                double start = times[0];
                for (int i = 0; i < MultiMonitor.this.panels.size(); ++i) {
                    WaveViewPanel wvp = (WaveViewPanel)MultiMonitor.this.panels.get(i);
                    wvp.setWorking(true);
                    channel = wvp.getChannel();
                    try {
                        Wave sw = (Wave)MultiMonitor.this.waveMap.get(channel);
                        if (sw != null) {
                            if (sw.overlaps(start, now)) {
                                Wave w2;
                                if (sw.getEndTime() < now && (w2 = MultiMonitor.this.dataSource.getWave(channel, sw.getEndTime() - 10.0, now)) != null && (sw.overlaps(w2) || sw.adjacent(w2))) {
                                    sw = sw.combine(w2);
                                }
                                if (sw.getStartTime() > start && (w2 = MultiMonitor.this.dataSource.getWave(channel, start, sw.getStartTime() + 10.0)) != null && (sw.overlaps(w2) || sw.adjacent(w2))) {
                                    sw = sw.combine(w2);
                                }
                                sw = sw.subset(start, sw.getEndTime());
                            } else {
                                sw = null;
                            }
                        }
                        if (sw == null) {
                            sw = MultiMonitor.this.dataSource.getWave(channel, start, now);
                        }
                        if (sw != null) {
                            MultiMonitor.this.waveMap.put(channel, sw);
                        }
                    }
                    catch (Throwable t) {
                        System.out.println(channel);
                        t.printStackTrace();
                    }
                    wvp.setWorking(false);
                }
                MultiMonitor.this.throbber.decrement();
            }
        };
        Thread worker = new Thread(r);
        worker.start();
    }

    public void setKioskMode(boolean b) {
        this.setDefaultKioskMode(b);
        if (this.fullScreen) {
            this.mainPanel.remove(this.toolbar);
            this.wavePanel.setBorder(null);
        } else {
            this.mainPanel.add((Component)this.toolbar, "North");
            this.wavePanel.setBorder(this.border);
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            if (MultiMonitor.this.panels.size() > 0) {
                MultiMonitor.this.refresh();
            }
        }
    }

    private class SlideTask
    extends TimerTask {
        private SlideTask() {
        }

        public void run() {
            if (MultiMonitor.this.panels.size() > 0) {
                MultiMonitor.this.slide();
            }
        }
    }

    private class MonitorWaveDecorator
    extends FrameDecorator {
        private WaveViewPanel panel;

        public MonitorWaveDecorator(WaveViewPanel wvp) {
            this.panel = wvp;
        }

        public void decorate(FrameRenderer fr) {
            fr.createEmptyAxis();
            AxisRenderer ar = fr.getAxis();
            ar.createDefault();
            RectangleRenderer rr = ar.getFrame();
            rr.color = Color.GRAY;
            TextRenderer label = new TextRenderer(fr.getGraphX() + 5, fr.getGraphY() + MultiMonitor.this.labelFontSize + 3, this.panel.getChannel(), Color.BLACK);
            label.font = MultiMonitor.this.font;
            label.color = Color.BLACK;
            rr = new RectangleRenderer();
            rr.rect = new Rectangle2D.Double();
            rr.rect.setFrame(MultiMonitor.this.font.getStringBounds(this.panel.getChannel(), MultiMonitor.this.frc));
            rr.rect.x = 2.0;
            rr.rect.width += 5.0;
            rr.rect.y = 3.0;
            rr.color = Color.GRAY;
            rr.backgroundColor = new Color(255, 255, 255, 210);
            int hTicks = fr.getGraphWidth() / 108;
            Object[] stt = SmartTick.autoTimeTick(fr.getMinXAxis(), fr.getMaxXAxis(), hTicks);
            if (stt != null) {
                ar.createVerticalGridLines((double[])stt[0]);
            }
            if (this.panel.getSettings().viewType == WaveViewSettings.ViewType.WAVE && this.panel.getHeight() > 36) {
                double m = 1.0;
                double b = 0.0;
                String Units = "Counts";
                if (this.panel.getSettings().useUnits) {
                    Metadata md = SwarmConfig.getInstance().getMetadata(this.panel.getChannel(), true);
                    m = md.getMultiplier();
                    b = md.getOffset();
                    Units = md.getUnit();
                }
                if (Units == null) {
                    Units = "Counts";
                }
                double min = fr.getMinY() * m + b;
                double max = fr.getMaxY() * m + b;
                String range = String.format("%.0f / %.0f %s", min, max, Units);
                TextRenderer tr = new TextRenderer(fr.getGraphX() + 2, fr.getGraphY() + fr.getGraphHeight() - 2, range);
                int fs = Math.min(10, MultiMonitor.this.labelFontSize);
                tr.font = Font.decode("dialog-PLAIN-" + fs);
                tr.color = Color.BLACK;
                ar.addPostRenderer(tr);
            }
            ar.addPostRenderer(rr);
            ar.addPostRenderer(label);
        }
    }

    private class WavePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BufferedImage image;

        public WavePanel() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent e) {
                    MultiMonitor.this.resizeWaves();
                }

                public void componentResized(ComponentEvent e) {
                    WavePanel.this.createImage();
                    MultiMonitor.this.resizeWaves();
                }
            });
        }

        private synchronized void createImage() {
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                this.image = new BufferedImage(this.getWidth(), this.getHeight(), 6);
            }
        }

        public void paint(Graphics g) {
            if (this.getWidth() <= 0 || this.getHeight() <= 0) {
                return;
            }
            if (this.image == null || MultiMonitor.this.panels.size() == 0) {
                super.paint(g);
                Dimension dim = this.getSize();
                g.setColor(Color.black);
                g.drawString("Monitor empty.", dim.width / 2 - 40, dim.height / 2);
            } else {
                super.paint(this.image.getGraphics());
                g.drawImage(this.image, 0, 0, null);
                g.setColor(Color.WHITE);
                Insets insets = MultiMonitor.this.wavePanel.getInsets();
                int y = this.getHeight() - MultiMonitor.this.bottomLabelHeight - insets.top - insets.bottom;
                g.fillRect(insets.left, y, this.getWidth() - insets.left - insets.right, MultiMonitor.this.bottomLabelHeight + 1);
                g.setColor(Color.GRAY);
                g.drawLine(insets.left, y, this.getWidth() - insets.left - 1, y);
                g.setColor(Color.BLACK);
                Graphics2D g2 = (Graphics2D)g;
                Object aa = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                double[] times = MultiMonitor.this.getTimeWindow();
                double now = times[1];
                double start = times[0];
                String tf = Time.format("HH:mm:ss", now);
                Font font = Font.decode("dialog-BOLD-" + (MultiMonitor.this.bottomLabelHeight - 2));
                g.setFont(font);
                FontMetrics fm = g.getFontMetrics();
                g.drawString(tf, this.getWidth() - fm.stringWidth(tf) - 4, this.getHeight() - (insets.bottom + 3));
                tf = Time.format("HH:mm:ss", start);
                g.drawString(tf, 4, this.getHeight() - (insets.bottom + 3));
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, aa);
            }
        }
    }
}

