/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.wave;

import gov.usgs.math.Butterworth;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.wave.WaveViewPanel;
import gov.usgs.volcanoes.swarm.wave.WaveViewSettingsToolbar;
import java.io.File;
import java.util.LinkedList;

public class WaveViewSettings {
    private static final String DEFAULTS_FILENAME = "WaveDefaults.config";
    public boolean filterOn;
    public boolean zeroPhaseShift;
    public boolean autoScaleAmp;
    public boolean autoScaleAmpMemory;
    public boolean autoScalePower;
    public boolean autoScalePowerMemory;
    public boolean useUnits;
    public boolean logPower;
    public boolean logFreq;
    public boolean removeBias;
    public double maxAmp;
    public double minAmp;
    public double minPower;
    public double maxPower;
    public double minFreq;
    public double maxFreq;
    public double spectrogramOverlap;
    public double binSize;
    public int nfft;
    public WaveViewPanel view;
    public WaveViewSettingsToolbar toolbar;
    public ViewType viewType;
    public Butterworth filter;
    private static WaveViewSettings DEFAULT_WAVE_VIEW_SETTINGS;

    public WaveViewSettings() {
        this.filter = new Butterworth();
        this.view = null;
        if (DEFAULT_WAVE_VIEW_SETTINGS != null) {
            this.copy(DEFAULT_WAVE_VIEW_SETTINGS);
        }
    }

    public WaveViewSettings(WaveViewSettings s) {
        this.copy(s);
    }

    public void copy(WaveViewSettings s) {
        this.viewType = s.viewType;
        this.removeBias = s.removeBias;
        this.autoScaleAmp = s.autoScaleAmp;
        this.autoScaleAmpMemory = s.autoScaleAmpMemory;
        this.maxAmp = s.maxAmp;
        this.minAmp = s.minAmp;
        this.autoScalePowerMemory = s.autoScalePowerMemory;
        this.autoScalePower = s.autoScalePower;
        this.minPower = s.minPower;
        this.maxPower = s.maxPower;
        this.filter = new Butterworth(s.filter);
        this.useUnits = s.useUnits;
        this.minFreq = s.minFreq;
        this.maxFreq = s.maxFreq;
        this.binSize = s.binSize;
        this.nfft = s.nfft;
        this.spectrogramOverlap = s.spectrogramOverlap;
        this.logPower = s.logPower;
        this.logFreq = s.logFreq;
        this.zeroPhaseShift = s.zeroPhaseShift;
        this.filterOn = s.filterOn;
    }

    public void set(ConfigFile cf) {
        this.viewType = ViewType.fromString(cf.getString("viewType"));
        this.filter.set(cf.getSubConfig("filter"));
        this.maxAmp = Util.stringToDouble(cf.getString("maxAmp"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxAmp);
        this.minAmp = Util.stringToDouble(cf.getString("minAmp"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minAmp);
        this.maxPower = Util.stringToDouble(cf.getString("maxPower"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxPower);
        this.minPower = Util.stringToDouble(cf.getString("minPower"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minPower);
        this.minFreq = Util.stringToDouble(cf.getString("minFreq"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minFreq);
        this.maxFreq = Util.stringToDouble(cf.getString("maxFreq"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxFreq);
        this.spectrogramOverlap = Util.stringToDouble(cf.getString("spectrogramOverlap"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.spectrogramOverlap);
        this.removeBias = Util.stringToBoolean(cf.getString("removeBias"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.removeBias);
        this.filterOn = Util.stringToBoolean(cf.getString("filterOn"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.filterOn);
        this.zeroPhaseShift = Util.stringToBoolean(cf.getString("zeroPhaseShift"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.zeroPhaseShift);
        this.autoScaleAmp = Util.stringToBoolean(cf.getString("autoScaleAmp"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmp);
        this.autoScaleAmpMemory = Util.stringToBoolean(cf.getString("autoScaleAmpMemory"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmpMemory);
        this.autoScalePower = Util.stringToBoolean(cf.getString("autoScalePower"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePower);
        this.autoScalePowerMemory = Util.stringToBoolean(cf.getString("autoScalePowerMemory"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePowerMemory);
        this.useUnits = Util.stringToBoolean(cf.getString("useUnits"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.useUnits);
        this.logFreq = Util.stringToBoolean(cf.getString("logFreq"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logFreq);
        this.logPower = Util.stringToBoolean(cf.getString("logPower"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logPower);
        this.binSize = Util.stringToDouble(cf.getString("binSize"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.binSize);
        this.nfft = Util.stringToInt(cf.getString("nfft"), WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.nfft);
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(prefix + ".viewType", this.viewType.code);
        this.filter.save(cf, prefix + ".filter");
        cf.put(prefix + ".maxAmp", Double.toString(this.maxAmp));
        cf.put(prefix + ".minAmp", Double.toString(this.minAmp));
        cf.put(prefix + ".minPower", Double.toString(this.minPower));
        cf.put(prefix + ".maxPower", Double.toString(this.maxPower));
        cf.put(prefix + ".minFreq", Double.toString(this.minFreq));
        cf.put(prefix + ".maxFreq", Double.toString(this.maxFreq));
        cf.put(prefix + ".spectrogramOverlap", Double.toString(this.spectrogramOverlap));
        cf.put(prefix + ".removeBias", Boolean.toString(this.removeBias));
        cf.put(prefix + ".filterOn", Boolean.toString(this.filterOn));
        cf.put(prefix + ".zeroPhaseShift", Boolean.toString(this.zeroPhaseShift));
        cf.put(prefix + ".autoScaleAmp", Boolean.toString(this.autoScaleAmp));
        cf.put(prefix + ".autoScaleAmpMemory", Boolean.toString(this.autoScaleAmpMemory));
        cf.put(prefix + ".autoScalePower", Boolean.toString(this.autoScalePower));
        cf.put(prefix + ".autoScalePowerMemory", Boolean.toString(this.autoScalePowerMemory));
        cf.put(prefix + ".useUnits", Boolean.toString(this.useUnits));
        cf.put(prefix + ".logFreq", Boolean.toString(this.logFreq));
        cf.put(prefix + ".logPower", Boolean.toString(this.logPower));
        cf.put(prefix + ".binSize", Double.toString(this.binSize));
        cf.put(prefix + ".nfft", Integer.toString(this.nfft));
    }

    public void setType(ViewType t) {
        this.viewType = t;
        this.notifyView();
    }

    public void cycleType() {
        switch (this.viewType) {
            case WAVE: {
                this.viewType = ViewType.SPECTRA;
                break;
            }
            case SPECTRA: {
                this.viewType = ViewType.SPECTROGRAM;
                break;
            }
            case SPECTROGRAM: {
                this.viewType = ViewType.WAVE;
            }
        }
        this.notifyView();
    }

    public void cycleLogSettings() {
        if (this.logFreq == this.logPower) {
            this.logPower = !this.logPower;
        } else {
            this.logFreq = !this.logFreq;
        }
        this.notifyView();
    }

    public void toggleLogFreq() {
        this.logFreq = !this.logFreq;
        this.notifyView();
    }

    public void toggleLogPower() {
        this.logPower = !this.logPower;
        this.notifyView();
    }

    public void toggleFilter() {
        this.filterOn = !this.filterOn;
        this.notifyView();
    }

    public void resetAutoScaleMemory() {
        if (this.view != null) {
            this.view.resetAutoScaleMemory();
        }
    }

    public void adjustScale(double pct) {
        if (this.view != null) {
            this.view.adjustScale(pct);
        }
    }

    public void notifyView() {
        if (this.view != null) {
            this.view.settingsChanged();
        }
        if (this.toolbar != null) {
            this.toolbar.settingsChanged();
        }
    }

    static {
        ConfigFile cf;
        DEFAULT_WAVE_VIEW_SETTINGS = new WaveViewSettings();
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.viewType = ViewType.WAVE;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.removeBias = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmp = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScaleAmpMemory = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxAmp = 1000.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minAmp = -1000.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePower = false;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.autoScalePowerMemory = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minPower = 20.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxPower = 120.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.useUnits = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logPower = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.logFreq = true;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.spectrogramOverlap = 0.859375;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.minFreq = 0.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.maxFreq = 25.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.binSize = 2.0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.nfft = 0;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.filter = new Butterworth();
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.filterOn = false;
        WaveViewSettings.DEFAULT_WAVE_VIEW_SETTINGS.zeroPhaseShift = true;
        LinkedList<String> candidateNames = new LinkedList<String>();
        candidateNames.add(DEFAULTS_FILENAME);
        candidateNames.add(System.getProperty("user.home") + File.separatorChar + DEFAULTS_FILENAME);
        String defaultsFile = ConfigFile.findConfig(candidateNames);
        if (defaultsFile == null) {
            defaultsFile = DEFAULTS_FILENAME;
        }
        if ((cf = new ConfigFile(defaultsFile)).wasSuccessfullyRead()) {
            ConfigFile sub = cf.getSubConfig("default");
            DEFAULT_WAVE_VIEW_SETTINGS.set(sub);
        } else {
            DEFAULT_WAVE_VIEW_SETTINGS.save(cf, "default");
            cf.writeToFile(DEFAULTS_FILENAME);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        WAVE("W"),
        SPECTRA("S"),
        SPECTROGRAM("G");

        public String code;

        private ViewType(String c) {
            this.code = c;
        }

        public static ViewType fromString(String c) {
            if (c.equals("S")) {
                return SPECTRA;
            }
            if (c.equals("G")) {
                return SPECTROGRAM;
            }
            return WAVE;
        }
    }
}

