/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

public class Goertzel {
    public static double goertzel(double freq, double sampleR, int[] signal) {
        return Goertzel.goertzel(freq, sampleR, signal, true);
    }

    public static double goertzel(double freq, double sampleR, int[] signal, boolean hamming) {
        int len = signal.length;
        if (hamming) {
            for (int i = 0; i < signal.length; ++i) {
                int n = i;
                signal[n] = (int)((double)signal[n] * (0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / sampleR)));
            }
        }
        double s_prev = 0.0;
        double s_prev2 = 0.0;
        double coeff = 2.0 * Math.cos(Math.PI * 2 * freq / sampleR);
        for (int i = 0; i < len; ++i) {
            double s = (double)signal[i] + coeff * s_prev - s_prev2;
            s_prev2 = s_prev;
            s_prev = s;
        }
        double power = s_prev2 * s_prev2 + s_prev * s_prev - coeff * s_prev2 * s_prev;
        return power;
    }
}

