/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.color.Jet;
import gov.usgs.plot.color.Spectrum;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.Renderer;
import hep.aida.ref.Histogram2D;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class Histogram2DRenderer
extends FrameRenderer {
    private Histogram2D histogram;
    private List<Renderer> renderers;
    private boolean log;
    private Spectrum spectrum;
    private boolean inverted;

    public Histogram2DRenderer(Histogram2D hist) {
        this.histogram = hist;
        this.renderers = new ArrayList<Renderer>();
        this.log = false;
        this.spectrum = Jet.getInstance();
        this.inverted = false;
    }

    public void setLog(boolean b) {
        this.log = b;
    }

    public void setInverted(boolean b) {
        this.inverted = b;
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
    }

    public Renderer getScaleRenderer(final int oX, final int oY) {
        return new Renderer(){

            @Override
            public void render(Graphics2D g) {
                Rectangle2D.Double rect = new Rectangle2D.Double();
                Histogram2DRenderer.this.spectrum.renderScale(g, oX, oY, 400.0, 10.0, false, true);
                g.setPaint(Color.BLACK);
                rect.setRect(oX - 1, oY - 1, 402.0, 11.0);
                g.draw(rect);
                int[] mmb = Histogram2DRenderer.this.histogram.minMaxBins();
                double min = 0.0;
                double max = 0.0;
                double dm = 0.0;
                if (Histogram2DRenderer.this.log) {
                    min = Histogram2DRenderer.this.histogram.binHeight(mmb[0], mmb[1]);
                    max = Math.log(Histogram2DRenderer.this.histogram.binHeight(mmb[2], mmb[3])) / Math.log(10.0);
                } else {
                    min = Histogram2DRenderer.this.histogram.binHeight(mmb[0], mmb[1]);
                    max = Histogram2DRenderer.this.histogram.binHeight(mmb[2], mmb[3]);
                }
                dm = max - min;
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(Histogram2DRenderer.this.log ? 2 : 0);
                Line2D.Double line = new Line2D.Double();
                FontMetrics fm = g.getFontMetrics(g.getFont());
                for (int i = 0; i <= 6; ++i) {
                    int x = (int)Math.round((double)oX + (double)i * 66.66666667);
                    line.setLine(x, oY - 1, x, oY - 5);
                    g.draw(line);
                    double c = min + (double)i / 6.0 * dm;
                    double d = Histogram2DRenderer.this.log ? Math.pow(10.0, c) : c;
                    String s = nf.format(Math.round(d));
                    g.drawString(s, x - fm.stringWidth(s) / 2, oY - 7);
                }
                g.drawString("Earthquake Density", oX + 148, oY + 27);
            }
        };
    }

    @Override
    public void render(Graphics2D g) {
        int xBins = this.histogram.xAxis().bins();
        int yBins = this.histogram.yAxis().bins();
        Color origColor = g.getColor();
        Paint origPaint = g.getPaint();
        AffineTransform origAT = g.getTransform();
        Shape origClip = g.getClip();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setClip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        Rectangle2D.Double rect = new Rectangle2D.Double();
        double xOffset = 0.0;
        double yOffset = 0.0;
        int[] mmb = this.histogram.minMaxBins();
        double min = 0.0;
        double max = 0.0;
        double dm = 0.0;
        if (this.log) {
            min = this.histogram.binHeight(mmb[0], mmb[1]);
            max = Math.log(this.histogram.binHeight(mmb[2], mmb[3])) / Math.log(10.0);
        } else {
            min = this.histogram.binHeight(mmb[0], mmb[1]);
            max = this.histogram.binHeight(mmb[2], mmb[3]);
        }
        dm = max - min;
        for (int j = 0; j < yBins; ++j) {
            double binHeight = this.histogram.yAxis().binWidth(j);
            xOffset = 0.0;
            if (!this.inverted) {
                yOffset += binHeight;
            }
            for (int i = 0; i < xBins; ++i) {
                double binWidth = this.histogram.xAxis().binWidth(i);
                double xVal = this.getXPixel(this.histogram.xAxis().lowerEdge() + xOffset);
                double yVal = this.inverted ? this.getYPixel(this.histogram.yAxis().upperEdge() - yOffset) : this.getYPixel(this.histogram.yAxis().lowerEdge() + yOffset);
                rect.setRect(xVal, yVal, binWidth * this.getXScale(), binHeight * this.getYScale());
                xOffset += binWidth;
                double count = 0.0;
                count = this.log ? Math.log(this.histogram.binHeight(i, j)) / Math.log(10.0) : this.histogram.binHeight(i, j);
                int color = (int)Math.round((count -= min) / dm * (double)(this.spectrum.colors.length - 1));
                Color clr = this.spectrum.colors[color];
                clr = color == 0 ? new Color(clr.getRed(), clr.getGreen(), clr.getBlue(), 0) : new Color(clr.getRed(), clr.getGreen(), clr.getBlue(), 160);
                g.setPaint(clr);
                g.fill(rect);
            }
            if (!this.inverted) continue;
            yOffset += binHeight;
        }
        g.setClip(origClip);
        for (Renderer renderer : this.renderers) {
            renderer.render(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setTransform(origAT);
        g.setPaint(origPaint);
        g.setColor(origColor);
    }
}

