/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.LineRenderer;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.render.ShapeRenderer;
import gov.usgs.plot.render.TextRenderer;
import java.awt.Color;
import java.awt.geom.Line2D;

public class InvertedAxisRenderer
extends AxisRenderer {
    public InvertedAxisRenderer(FrameRenderer fr) {
        super(fr);
    }

    @Override
    public void createBottomTicks(double[] ticks, double length, Color color) {
        if (this.bottomTicks == null || this.bottomTicks.length != ticks.length) {
            this.bottomTicks = new Renderer[ticks.length];
        }
        double maxY = this.frameRenderer.getMaxY();
        for (int i = 0; i < ticks.length; ++i) {
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(maxY) - length);
            lr.color = color;
            lr.stroke = LineRenderer.TICK_STROKE;
            this.bottomTicks[i] = lr;
        }
    }

    @Override
    public void createBottomTicks(double[] majorTicks, double[] minorTicks, Color color) {
        ShapeRenderer sr;
        int j;
        int numTicks = 0;
        if (majorTicks != null) {
            numTicks += majorTicks.length;
        }
        if (minorTicks != null) {
            numTicks += minorTicks.length;
        }
        double majorLength = 10.0;
        double minorLength = 5.0;
        this.bottomTicks = new Renderer[numTicks];
        double maxY = this.frameRenderer.getMaxY();
        int i = 0;
        if (majorTicks != null) {
            for (j = 0; j < majorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(maxY) - majorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.bottomTicks[i++] = sr;
            }
        }
        if (minorTicks != null) {
            for (j = 0; j < minorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(maxY), this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(maxY) - minorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.bottomTicks[i++] = sr;
            }
        }
    }

    @Override
    public void createBottomTickLabels(double[] ticks, String[] labels, Color color) {
        this.bottomLabels = new Renderer[ticks.length];
        double maxY = this.frameRenderer.getMaxY();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = labels != null ? labels[i] : numberFormat.format(ticks[i]);
            tr.x = (float)this.frameRenderer.getXPixel(ticks[i]);
            tr.y = (float)this.frameRenderer.getYPixel(maxY);
            tr.horizJustification = 1;
            tr.vertJustification = 4;
            if (color != null) {
                tr.color = color;
            }
            this.bottomLabels[i] = tr;
        }
    }

    @Override
    public void createTopTicks(double[] ticks, double length, Color color) {
        if (this.topTicks == null || this.topTicks.length != ticks.length) {
            this.topTicks = new Renderer[ticks.length];
        }
        double minY = this.frameRenderer.getMinY();
        for (int i = 0; i < ticks.length; ++i) {
            LineRenderer lr = new LineRenderer();
            lr.line = new Line2D.Double(this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(ticks[i]), this.frameRenderer.getYPixel(minY) + length);
            lr.color = color;
            lr.stroke = LineRenderer.TICK_STROKE;
            this.topTicks[i] = lr;
        }
    }

    @Override
    public void createTopTicks(double[] majorTicks, double[] minorTicks, Color color) {
        ShapeRenderer sr;
        int j;
        int numTicks = 0;
        if (majorTicks != null) {
            numTicks += majorTicks.length;
        }
        if (minorTicks != null) {
            numTicks += minorTicks.length;
        }
        double majorLength = 10.0;
        double minorLength = 5.0;
        this.topTicks = new Renderer[numTicks];
        double minY = this.frameRenderer.getMinY();
        int i = 0;
        if (majorTicks != null) {
            for (j = 0; j < majorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(majorTicks[j]), this.frameRenderer.getYPixel(minY) + majorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.topTicks[i++] = sr;
            }
        }
        if (minorTicks != null) {
            for (j = 0; j < minorTicks.length; ++j) {
                sr = new ShapeRenderer(new Line2D.Double(this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(minY), this.frameRenderer.getXPixel(minorTicks[j]), this.frameRenderer.getYPixel(minY) + minorLength));
                if (color != null) {
                    sr.color = color;
                }
                this.topTicks[i++] = sr;
            }
        }
    }

    @Override
    public void createTopTickLabels(double[] ticks, String[] labels) {
        this.topLabels = new Renderer[ticks.length];
        double minY = this.frameRenderer.getMinY();
        for (int i = 0; i < ticks.length; ++i) {
            TextRenderer tr = new TextRenderer();
            tr.text = labels != null ? labels[i] : numberFormat.format(ticks[i]);
            tr.x = (float)this.frameRenderer.getXPixel(ticks[i]);
            tr.y = (float)this.frameRenderer.getYPixel(minY);
            tr.horizJustification = 1;
            tr.vertJustification = 5;
            this.topLabels[i] = tr;
        }
    }
}

