/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.math.Filter;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.plot.render.wave.SpectraRenderer;
import gov.usgs.plot.render.wave.SpectrogramRenderer;
import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.time.UiTime;
import gov.usgs.swarm.time.WaveViewTime;
import gov.usgs.swarm.wave.WaveViewPanelListener;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class WaveViewPanel
extends JComponent {
    public static final long serialVersionUID = -1L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static SwarmConfig swarmConfig;
    private int xOffset = 60;
    private int yOffset = 20;
    private int rightWidth = 20;
    private int bottomHeight = 20;
    private FrameDecorator decorator;
    private SliceWaveRenderer waveRenderer;
    private SpectrogramRenderer spectrogramRenderer;
    private SpectraRenderer spectraRenderer;
    private Wave wave;
    private double startTime;
    private double endTime;
    private WaveViewSettings settings;
    private int bias;
    private double minAmp = 1.0E300;
    private double maxAmp = -1.0E300;
    private double maxSpectraPower = -1.0E300;
    private double maxSpectrogramPower = -1.0E300;
    private double[] translation;
    private boolean timeSeries;
    private String channel;
    private SeismicDataSource source;
    private boolean displayTitle;
    private Color backgroundColor;
    private Color bottomBorderColor;
    private JLabel statusLabel;
    private boolean allowDragging;
    private boolean dragging;
    private double j2k1;
    private double j2k2;
    private int highlightX1;
    private int highlightX2;
    private static Image closeImg;
    private boolean allowClose;
    private EventListenerList listeners = new EventListenerList();
    private boolean working;
    private BufferedImage image;
    private double mark1 = Double.NaN;
    private double mark2 = Double.NaN;
    private double cursorMark = Double.NaN;
    private boolean useFilterLabel = true;
    private Color borderColor;
    private static final Color DARK_RED;
    private static final Color DARK_GREEN;

    public WaveViewPanel() {
        this(new WaveViewSettings());
    }

    public WaveViewPanel(WaveViewSettings s) {
        swarmConfig = SwarmConfig.getInstance();
        this.settings = s;
        s.view = this;
        this.backgroundColor = new Color(247, 247, 247);
        this.setupMouseHandler();
    }

    public WaveViewPanel(WaveViewPanel p) {
        swarmConfig = SwarmConfig.getInstance();
        this.channel = p.channel;
        this.source = p.source;
        this.startTime = p.startTime;
        this.endTime = p.endTime;
        this.bias = p.bias;
        this.maxSpectraPower = p.maxSpectraPower;
        this.maxSpectrogramPower = p.maxSpectrogramPower;
        this.translation = new double[8];
        if (p.translation != null) {
            System.arraycopy(p.translation, 0, this.translation, 0, 8);
        }
        this.timeSeries = p.timeSeries;
        this.allowDragging = p.allowDragging;
        this.settings = new WaveViewSettings(p.settings);
        this.settings.view = this;
        this.wave = p.wave;
        this.displayTitle = p.displayTitle;
        this.backgroundColor = p.backgroundColor;
        this.setupMouseHandler();
        this.processSettings();
    }

    public void setOffsets(int xo, int yo, int rw, int bh) {
        this.xOffset = xo;
        this.yOffset = yo;
        this.rightWidth = rw;
        this.bottomHeight = bh;
    }

    public void addListener(WaveViewPanelListener listener) {
        this.listeners.add(WaveViewPanelListener.class, listener);
    }

    public void removeListener(WaveViewPanelListener listener) {
        this.listeners.remove(WaveViewPanelListener.class, listener);
    }

    public void fireZoomed(MouseEvent e, double oldST, double oldET, double newST, double newET) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != WaveViewPanelListener.class) continue;
            ((WaveViewPanelListener)ls[i + 1]).waveZoomed(this, oldST, oldET, newST, newET);
        }
    }

    public void fireTimePressed(MouseEvent e, double j2k) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != WaveViewPanelListener.class) continue;
            ((WaveViewPanelListener)ls[i + 1]).waveTimePressed(this, e, j2k);
        }
    }

    public void fireMousePressed(MouseEvent e) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != WaveViewPanelListener.class) continue;
            ((WaveViewPanelListener)ls[i + 1]).mousePressed(this, e, this.dragging);
        }
    }

    public void fireClose() {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != WaveViewPanelListener.class) continue;
            ((WaveViewPanelListener)ls[i + 1]).waveClosed(this);
        }
    }

    public void setAllowClose(boolean b) {
        this.allowClose = b;
    }

    private void setupMouseHandler() {
        Cursor crosshair = new Cursor(1);
        this.setCursor(crosshair);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UiTime.touchTime();
                double[] t = WaveViewPanel.this.getTranslation();
                if (t != null) {
                    int x = e.getX();
                    double j2k = (double)x * t[0] + t[1];
                    if (WaveViewPanel.this.timeSeries) {
                        System.out.printf("%s UTC: %s j2k: %.3f ew: %.3f\n", WaveViewPanel.this.channel, Time.format(WaveViewPanel.DATE_FORMAT, Util.j2KToDate(j2k)), j2k, Util.j2KToEW(j2k));
                    }
                    if (SwingUtilities.isRightMouseButton(e)) {
                        WaveViewPanel.this.settings.cycleType();
                    }
                    if (WaveViewPanel.this.timeSeries && j2k >= WaveViewPanel.this.startTime && j2k <= WaveViewPanel.this.endTime) {
                        WaveViewPanel.this.fireTimePressed(e, j2k);
                    }
                    if (WaveViewPanel.this.timeSeries && WaveViewPanel.this.allowDragging && SwingUtilities.isLeftMouseButton(e)) {
                        Dimension size = WaveViewPanel.this.getSize();
                        int y = e.getY();
                        if (t != null && y > WaveViewPanel.this.yOffset && y < size.height - WaveViewPanel.this.bottomHeight && x > WaveViewPanel.this.xOffset && x < size.width - WaveViewPanel.this.rightWidth) {
                            WaveViewPanel.this.j2k1 = (WaveViewPanel.this.j2k2 = j2k);
                            if (e.isControlDown()) {
                                System.out.println(WaveViewPanel.this.channel + ": " + Time.format(WaveViewPanel.DATE_FORMAT, Util.j2KToDate(WaveViewPanel.this.j2k1)));
                            } else if (!e.isShiftDown()) {
                                WaveViewPanel.this.highlightX1 = (WaveViewPanel.this.highlightX2 = x);
                                WaveViewPanel.this.dragging = true;
                            }
                        }
                    }
                }
                WaveViewPanel.this.fireMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                UiTime.touchTime();
                if (SwingUtilities.isLeftMouseButton(e) && WaveViewPanel.this.dragging) {
                    WaveViewPanel.this.dragging = false;
                    if (WaveViewPanel.this.j2k1 != WaveViewPanel.this.j2k2 && WaveViewPanel.this.source != null) {
                        double st = Math.min(WaveViewPanel.this.j2k1, WaveViewPanel.this.j2k2);
                        double et = Math.max(WaveViewPanel.this.j2k1, WaveViewPanel.this.j2k2);
                        WaveViewPanel.this.zoom(st, et);
                        WaveViewPanel.this.fireZoomed(e, WaveViewPanel.this.getStartTime(), WaveViewPanel.this.getEndTime(), st, et);
                    }
                    WaveViewPanel.this.repaint();
                }
                int mx = e.getX();
                int my = e.getY();
                if (WaveViewPanel.this.allowClose && SwingUtilities.isLeftMouseButton(e) && mx > WaveViewPanel.this.getWidth() - 17 && mx < WaveViewPanel.this.getWidth() - 3 && my > 2 && my < 17) {
                    WaveViewPanel.this.fireClose();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WaveViewTime.fireTimeChanged(Double.NaN);
                WaveViewPanel.this.dragging = false;
                WaveViewPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                UiTime.touchTime();
                WaveViewPanel.this.processMousePosition(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                UiTime.touchTime();
                WaveViewPanel.this.processMousePosition(e.getX(), e.getY());
                if (SwingUtilities.isLeftMouseButton(e) && !e.isControlDown() && WaveViewPanel.this.dragging) {
                    double[] t = WaveViewPanel.this.getTranslation();
                    int x = e.getX();
                    int y = e.getY();
                    Dimension size = WaveViewPanel.this.getSize();
                    if (t != null && y > WaveViewPanel.this.yOffset && y < size.height - WaveViewPanel.this.bottomHeight && x > WaveViewPanel.this.xOffset && x < size.width - WaveViewPanel.this.rightWidth) {
                        WaveViewPanel.this.j2k2 = (double)x * t[0] + t[1];
                        WaveViewPanel.this.highlightX2 = x;
                        WaveViewPanel.this.repaint();
                    }
                }
            }
        });
    }

    public void zoom(final double st, final double et) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Wave sw = null;
                sw = WaveViewPanel.this.source instanceof CachedDataSource ? ((CachedDataSource)WaveViewPanel.this.source).getBestWave(WaveViewPanel.this.channel, st, et) : WaveViewPanel.this.source.getWave(WaveViewPanel.this.channel, st, et);
                WaveViewPanel.this.setWave(sw, st, et);
                return null;
            }

            @Override
            public void finished() {
                WaveViewPanel.this.repaint();
            }
        };
        worker.start();
    }

    public void setWorking(boolean b) {
        this.working = b;
    }

    public void setAllowDragging(boolean b) {
        this.allowDragging = b;
    }

    public void setStatusLabel(JLabel l) {
        this.statusLabel = l;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public WaveViewSettings getSettings() {
        return this.settings;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Wave getWave() {
        return this.wave;
    }

    public WaveViewSettings getWaveViewSettings() {
        return this.settings;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String c) {
        this.channel = c;
    }

    public void setSettings(WaveViewSettings s) {
        this.settings = s;
        this.processSettings();
    }

    public SeismicDataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(SeismicDataSource s) {
        this.source = s;
    }

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setDisplayTitle(boolean b) {
        this.displayTitle = b;
    }

    public void settingsChanged() {
        this.processSettings();
    }

    public boolean isTimeSeries() {
        return this.timeSeries;
    }

    public double[] getTranslation() {
        return this.translation;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public void setBottomBorderColor(Color c) {
        this.bottomBorderColor = c;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public boolean processMousePosition(int x, int y) {
        String status = null;
        String unit = null;
        String waveInfo = null;
        Dimension size = this.getSize();
        double[] t = this.getTranslation();
        double j2k = Double.NaN;
        if (this.wave != null && t != null && y > this.yOffset && y < size.height - this.bottomHeight && x > this.xOffset && x < size.width - this.rightWidth) {
            j2k = (double)x * t[0] + t[1];
            double yi = (double)y * -t[2] + t[3];
            int[] dataRange = this.wave.getDataRange();
            waveInfo = String.format("[%s - %s (UTC), %d samples (%.2f s), %d samples/s, %d, %d]", Time.format(DATE_FORMAT, Util.j2KToDate(this.wave.getStartTime())), Time.format(DATE_FORMAT, Util.j2KToDate(this.wave.getEndTime())), this.wave.numSamples(), (double)this.wave.numSamples() / this.wave.getSamplingRate(), (int)this.wave.getSamplingRate(), dataRange[0], dataRange[1]);
            if (this.timeSeries) {
                String utc = Time.format(DATE_FORMAT, Util.j2KToDate(j2k));
                TimeZone tz = swarmConfig.getTimeZone(this.channel);
                double tzo = tz.getOffset((long)Util.j2KToEW(j2k)) / 1000;
                if (tzo != 0.0) {
                    String tza = tz.getDisplayName(tz.inDaylightTime(Util.j2KToDate(j2k)), 0);
                    status = Time.format(DATE_FORMAT, Util.j2KToDate(j2k + tzo)) + " (" + tza + "), " + utc + " (UTC)";
                } else {
                    status = utc;
                }
                double offset = 0.0;
                double multiplier = 1.0;
                if (this.settings.viewType == WaveViewSettings.ViewType.SPECTROGRAM) {
                    unit = "Frequency (Hz)";
                } else {
                    Metadata md = swarmConfig.getMetadata(this.channel);
                    if (md != null) {
                        offset = md.getOffset();
                        multiplier = md.getMultiplier();
                        unit = md.getUnit();
                    }
                    if (unit == null) {
                        unit = "Counts";
                    }
                }
                status = String.format("%s, %s: %.3f, %s", status, unit, multiplier * yi + offset, waveInfo);
            } else {
                double xi = j2k;
                if (this.settings.viewType == WaveViewSettings.ViewType.SPECTRA && this.settings.logFreq) {
                    xi = Math.pow(10.0, xi);
                }
                if (this.settings.viewType == WaveViewSettings.ViewType.SPECTRA && this.settings.logPower) {
                    yi = Math.pow(10.0, yi);
                }
                status = String.format("%s, Frequency (Hz): %.3f, Power: %.3f", waveInfo, xi, yi);
            }
        } else {
            status = " ";
        }
        WaveViewTime.fireTimeChanged(j2k);
        if (status == null) {
            status = " ";
        }
        if (!Double.isNaN(this.mark1) && !Double.isNaN(this.mark2)) {
            double dur = Math.abs(this.mark1 - this.mark2);
            String pre = String.format("Duration: %.2fs (Md: %.2f)", dur, swarmConfig.getDurationMagnitude(dur));
            status = status.length() > 2 ? pre + ", " + status : pre;
        }
        if (status != null && this.statusLabel != null) {
            final String st = status;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaveViewPanel.this.statusLabel.setText(st);
                }
            });
        }
        return !status.equals(" ");
    }

    public void setWave(Wave sw, double st, double et) {
        this.wave = sw;
        this.startTime = st;
        this.endTime = et;
        this.processSettings();
    }

    public void resetAutoScaleMemory() {
        this.minAmp = 1.0E300;
        this.maxAmp = -1.0E300;
        this.maxSpectraPower = -1.0E300;
        this.maxSpectrogramPower = -1.0E300;
        this.settings.autoScaleAmp = true;
        this.settings.autoScalePower = true;
        this.processSettings();
    }

    public void adjustScale(double pct) {
        double maxa = this.settings.autoScaleAmp ? this.maxAmp : this.settings.maxAmp;
        double mina = this.settings.autoScaleAmp ? this.minAmp : this.settings.minAmp;
        this.settings.autoScaleAmp = false;
        double range = maxa - mina;
        double center = range / 2.0 + mina;
        double newRange = range * pct;
        this.settings.minAmp = center - newRange / 2.0;
        this.settings.maxAmp = center + newRange / 2.0;
        if (this.settings.viewType == WaveViewSettings.ViewType.SPECTROGRAM) {
            double maxf = this.settings.maxFreq * pct;
            System.out.printf("WaveViewPanel(804): maxf = %f\n", maxf);
            this.settings.maxFreq = maxf > this.wave.getSamplingRate() / 2.0 ? this.wave.getSamplingRate() / 2.0 : maxf;
            System.out.printf("WaveViewPanel(806): settings.maxFreq = %f\n", this.settings.maxFreq);
        }
        this.processSettings();
    }

    private synchronized void setImage(BufferedImage bi) {
        this.image = bi;
    }

    private synchronized BufferedImage getImage() {
        return this.image;
    }

    public void createImage() {
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WaveViewPanel.this.getWidth() > 0 && WaveViewPanel.this.getHeight() > 0) {
                    BufferedImage bi = new BufferedImage(WaveViewPanel.this.getWidth(), WaveViewPanel.this.getHeight(), 6);
                    Graphics2D ig = (Graphics2D)bi.getGraphics();
                    WaveViewPanel.this.constructPlot(ig);
                    WaveViewPanel.this.setImage(bi);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    r.run();
                    return null;
                }

                @Override
                public void finished() {
                    WaveViewPanel.this.repaint();
                }
            };
            worker.start();
        } else {
            r.run();
        }
    }

    private void processSettings() {
        if (this.wave == null || this.wave.buffer == null || this.wave.buffer.length == 0) {
            return;
        }
        if (this.settings.maxFreq > this.wave.getNyquist()) {
            this.settings.maxFreq = this.wave.getNyquist();
        }
        this.timeSeries = this.settings.viewType != WaveViewSettings.ViewType.SPECTRA;
        this.createImage();
    }

    private void filter(Wave w) {
        int i;
        double mean = w.mean();
        double[] dBuf = new double[w.buffer.length + (int)((double)w.buffer.length * 0.5)];
        Arrays.fill(dBuf, mean);
        int trueStart = (int)((double)w.buffer.length * 0.25);
        for (i = 0; i < w.buffer.length; ++i) {
            if (w.buffer[i] == Wave.NO_DATA) continue;
            dBuf[i + trueStart] = w.buffer[i];
        }
        this.settings.filter.setSamplingRate(w.getSamplingRate());
        this.settings.filter.create();
        Filter.filter(dBuf, this.settings.filter.getSize(), this.settings.filter.getXCoeffs(), this.settings.filter.getYCoeffs(), this.settings.filter.getGain(), 0.0, 0.0);
        if (this.settings.zeroPhaseShift) {
            double[] dBuf2 = new double[dBuf.length];
            int i2 = 0;
            int j = dBuf.length - 1;
            while (i2 < dBuf.length) {
                dBuf2[j] = dBuf[i2];
                ++i2;
                --j;
            }
            Filter.filter(dBuf2, this.settings.filter.getSize(), this.settings.filter.getXCoeffs(), this.settings.filter.getYCoeffs(), this.settings.filter.getGain(), 0.0, 0.0);
            i2 = 0;
            j = dBuf2.length - 1 - trueStart;
            while (i2 < w.buffer.length) {
                w.buffer[i2] = (int)Math.round(dBuf2[j]);
                ++i2;
                --j;
            }
        } else {
            for (i = 0; i < w.buffer.length; ++i) {
                w.buffer[i] = (int)Math.round(dBuf[i + trueStart]);
            }
        }
        w.invalidateStatistics();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        if (this.wave == null) {
            g2.setColor(this.backgroundColor);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
            if (this.working) {
                g2.drawString("Retrieving data...", dim.width / 2 - 50, dim.height / 2);
            } else {
                String error = "No wave data.";
                if (this.channel != null) {
                    error = "No wave data for " + this.channel + ".";
                }
                int w = g2.getFontMetrics().stringWidth(error);
                g2.drawString(error, dim.width / 2 - w / 2, dim.height / 2);
            }
        } else {
            BufferedImage bi = this.getImage();
            if (bi != null) {
                g2.drawImage((Image)bi, 0, 0, null);
            }
            if (this.dragging) {
                this.paintDragBox(g2);
            }
            if (!Double.isNaN(this.mark1)) {
                this.paintMark(g2, this.mark1);
            }
            if (!Double.isNaN(this.mark2)) {
                this.paintMark(g2, this.mark2);
            }
            if (!Double.isNaN(this.cursorMark)) {
                this.paintCursor(g2);
            }
        }
        if (this.allowClose) {
            if (closeImg == null) {
                closeImg = Icons.close_view.getImage();
            }
            g2.drawImage(closeImg, dim.width - 17, 3, null);
        }
        if (this.bottomBorderColor != null) {
            g2.setColor(this.bottomBorderColor);
            g2.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
        if (this.borderColor != null) {
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, dim.width - 1, dim.height - 2);
        }
    }

    public void setUseFilterLabel(boolean b) {
        this.useFilterLabel = b;
    }

    public TextRenderer getFilterLabel() {
        return this.getFilterLabel(this.xOffset + 5, 148, 0, 0);
    }

    public TextRenderer getFilterLabel(int x, int y, int horizJustification, int vertJustification) {
        String ft = "";
        switch (this.settings.filter.getType()) {
            case BANDPASS: {
                ft = "Band pass [" + this.settings.filter.getCorner1() + "-" + this.settings.filter.getCorner2() + " Hz]";
                break;
            }
            case HIGHPASS: {
                ft = "High pass [" + this.settings.filter.getCorner1() + " Hz]";
                break;
            }
            case LOWPASS: {
                ft = "Low pass [" + this.settings.filter.getCorner1() + " Hz]";
            }
        }
        TextRenderer tr = new TextRenderer(x, y, ft);
        tr.horizJustification = horizJustification;
        tr.vertJustification = vertJustification;
        tr.color = Color.red;
        return tr;
    }

    private synchronized void constructPlot(Graphics2D g2) {
        Dimension dim = this.getSize();
        Plot plot = new Plot();
        plot.setBackgroundColor(this.backgroundColor);
        plot.setSize(dim);
        Wave renderWave = this.wave;
        if (this.settings.filterOn) {
            renderWave = new Wave(this.wave);
            this.filter(renderWave);
            if (this.settings.removeBias) {
                this.bias = (int)Math.round(renderWave.mean());
            }
        }
        switch (this.settings.viewType) {
            case WAVE: {
                this.plotWave(plot, renderWave);
                break;
            }
            case SPECTRA: {
                this.plotSpectra(plot, renderWave);
                break;
            }
            case SPECTROGRAM: {
                this.plotSpectrogram(plot, renderWave);
            }
        }
        try {
            plot.render(g2);
        }
        catch (PlotException e) {
            e.printStackTrace();
        }
    }

    private void plotWave(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.numSamples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        double offset = 0.0;
        double multiplier = 1.0;
        Metadata md = swarmConfig.getMetadata(this.channel);
        if (this.settings.useUnits && md != null) {
            offset = md.getOffset();
            multiplier = md.getMultiplier();
        }
        double bias = 0.0;
        if (this.settings.removeBias) {
            bias = wv.mean();
        }
        double minY = (this.settings.minAmp - offset) / multiplier;
        double maxY = (this.settings.maxAmp - offset) / multiplier;
        if (this.settings.autoScaleAmp) {
            double[] dr = new double[]{wv.min(), wv.max()};
            if (this.settings.autoScaleAmpMemory) {
                minY = Math.min(this.minAmp, dr[0] - bias);
                maxY = Math.max(this.maxAmp, dr[1] - bias);
                this.minAmp = Math.min(minY, this.minAmp);
                this.maxAmp = Math.max(maxY, this.maxAmp);
            } else {
                minY = dr[0] - bias;
                maxY = dr[1] - bias;
            }
        }
        if (this.waveRenderer == null) {
            this.waveRenderer = new SliceWaveRenderer();
        }
        if (this.decorator != null) {
            this.waveRenderer.setFrameDecorator(this.decorator);
        }
        if (this.settings.useUnits && md != null && md.getUnit() != null) {
            this.waveRenderer.setYLabelText(md.getUnit());
        } else {
            this.waveRenderer.setYLabelText("Counts");
        }
        this.waveRenderer.setYAxisCoefficients(multiplier, offset);
        this.waveRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.xOffset - this.rightWidth, this.getHeight() - this.yOffset - this.bottomHeight);
        this.waveRenderer.setYLimits(minY, maxY);
        this.waveRenderer.setViewTimes(this.startTime, this.endTime, "");
        this.waveRenderer.setWave(wv);
        this.waveRenderer.setRemoveBias(this.settings.removeBias);
        if (this.channel != null && this.displayTitle) {
            this.waveRenderer.setTitle(this.channel);
        }
        this.waveRenderer.update();
        plot.addRenderer(this.waveRenderer);
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel(this.getWidth() - this.rightWidth, this.getHeight() - this.bottomHeight, 3, 5));
        }
        this.translation = this.waveRenderer.getDefaultTranslation();
    }

    private void plotSpectra(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.numSamples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        if (this.spectraRenderer == null) {
            this.spectraRenderer = new SpectraRenderer();
        }
        if (this.decorator != null) {
            this.spectraRenderer.setFrameDecorator(this.decorator);
        }
        this.spectraRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.rightWidth - this.xOffset, this.getHeight() - this.bottomHeight - this.yOffset);
        this.spectraRenderer.setWave(wv);
        this.spectraRenderer.setAutoScale(this.settings.autoScalePower);
        this.spectraRenderer.setLogPower(this.settings.logPower);
        this.spectraRenderer.setLogFreq(this.settings.logFreq);
        this.spectraRenderer.setMaxFreq(this.settings.maxFreq);
        this.spectraRenderer.setMinFreq(this.settings.minFreq);
        this.spectraRenderer.setYUnitText("Power");
        if (this.channel != null && this.displayTitle) {
            this.spectraRenderer.setTitle(this.channel);
        }
        this.spectraRenderer.update();
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel(this.getWidth() - this.rightWidth, this.getHeight() - this.bottomHeight, 3, 5));
        }
        this.translation = this.spectraRenderer.getDefaultTranslation();
        plot.addRenderer(this.spectraRenderer);
    }

    private void plotSpectrogram(Plot plot, Wave renderWave) {
        if (renderWave == null || renderWave.numSamples() == 0) {
            return;
        }
        SliceWave wv = new SliceWave(renderWave);
        wv.setSlice(this.startTime, this.endTime);
        if (this.spectrogramRenderer == null) {
            this.spectrogramRenderer = new SpectrogramRenderer();
        }
        if (this.decorator != null) {
            this.spectrogramRenderer.setFrameDecorator(this.decorator);
        }
        this.spectrogramRenderer.setLocation(this.xOffset, this.yOffset, this.getWidth() - this.rightWidth - this.xOffset, this.getHeight() - this.bottomHeight - this.yOffset);
        this.spectrogramRenderer.setWave(wv);
        this.spectrogramRenderer.setViewStartTime(this.startTime);
        this.spectrogramRenderer.setViewEndTime(this.endTime);
        this.spectrogramRenderer.setAutoScale(this.settings.autoScalePower);
        this.spectrogramRenderer.setLogPower(this.settings.logPower);
        this.spectrogramRenderer.setOverlap(this.settings.spectrogramOverlap);
        this.spectrogramRenderer.setMaxFreq(this.settings.maxFreq);
        this.spectrogramRenderer.setMinFreq(this.settings.minFreq);
        this.spectrogramRenderer.setMaxPower(this.settings.maxPower);
        this.spectrogramRenderer.setMinPower(this.settings.minPower);
        this.spectrogramRenderer.setBinSize((int)Math.pow(2.0, Math.ceil(Math.log(this.settings.binSize * this.wave.getSamplingRate()) / Math.log(2.0))));
        if (this.channel != null && this.displayTitle) {
            this.spectrogramRenderer.setTitle(this.channel);
        }
        this.spectrogramRenderer.setYUnitText("Frequency (Hz)");
        this.spectrogramRenderer.setNfft(this.settings.nfft);
        double[] Power = this.spectrogramRenderer.update();
        this.settings.minPower = Power[0];
        this.settings.maxPower = Power[1];
        plot.addRenderer(this.spectrogramRenderer);
        if (this.useFilterLabel && this.settings.filterOn) {
            plot.addRenderer(this.getFilterLabel(this.getWidth() - this.rightWidth, this.getHeight() - this.bottomHeight, 3, 5));
        }
        this.translation = this.spectrogramRenderer.getDefaultTranslation();
    }

    private void paintDragBox(Graphics2D g2) {
        int x1 = Math.min(this.highlightX1, this.highlightX2);
        int x2 = Math.max(this.highlightX1, this.highlightX2);
        int width = x2 - x1 + 1;
        Paint pnt = g2.getPaint();
        g2.setPaint(new Color(255, 255, 0, 128));
        g2.fillRect(x1, this.yOffset + 1, width, this.getSize().height - this.bottomHeight - this.yOffset);
        g2.setPaint(pnt);
    }

    public void setCursorMark(double j2k) {
        this.cursorMark = j2k;
        this.repaint();
    }

    private void paintCursor(Graphics2D g2) {
        if (Double.isNaN(this.cursorMark) || this.cursorMark < this.startTime || this.cursorMark > this.endTime) {
            return;
        }
        double[] t = this.getTranslation();
        if (t == null) {
            return;
        }
        double x = (this.cursorMark - t[1]) / t[0];
        g2.setColor(DARK_RED);
        g2.draw(new Line2D.Double(x, this.yOffset + 1, x, this.getHeight() - this.bottomHeight - 1));
    }

    private void paintMark(Graphics2D g2, double j2k) {
        if (Double.isNaN(j2k) || j2k < this.startTime || j2k > this.endTime) {
            return;
        }
        double[] t = this.getTranslation();
        if (t == null) {
            return;
        }
        double x = (j2k - t[1]) / t[0];
        g2.setColor(DARK_GREEN);
        g2.draw(new Line2D.Double(x, this.yOffset, x, this.getHeight() - this.bottomHeight - 1));
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)x, this.yOffset);
        gp.lineTo((float)x - 5.0f, this.yOffset - 7);
        gp.lineTo((float)x + 5.0f, this.yOffset - 7);
        gp.closePath();
        g2.setPaint(Color.GREEN);
        g2.fill(gp);
        g2.setColor(DARK_GREEN);
        g2.draw(gp);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public void setMarks(double m1, double m2) {
        this.mark1 = m1;
        this.mark2 = m2;
    }

    static {
        DARK_RED = new Color(168, 0, 0);
        DARK_GREEN = new Color(0, 168, 0);
    }
}

