/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive.plot;

import gov.usgs.plot.render.TextRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.plot.render.wave.SpectrogramRenderer;
import gov.usgs.util.ConfigFile;
import gov.usgs.volcanoes.pensive.plot.ChannelPlotter;
import java.awt.Dimension;
import java.awt.Font;

public class ThumbnailPlotter
extends ChannelPlotter {
    public static final Font NO_DATA_FONT = Font.decode("dialog-PLAIN-12");

    public ThumbnailPlotter(String name, int index, Dimension plotDimension, ConfigFile config) {
        super(name, index, plotDimension, config);
        this.noDataFont = NO_DATA_FONT;
    }

    @Override
    protected void tweakSpectrogramRenderer(SpectrogramRenderer spectrogramRenderer) {
        spectrogramRenderer.yTickMarks = false;
        spectrogramRenderer.yTickValues = false;
        spectrogramRenderer.xTickMarks = false;
        spectrogramRenderer.xTickValues = false;
        spectrogramRenderer.xUnits = false;
        spectrogramRenderer.xLabel = false;
        int top = this.index * this.plotDimension.height + this.waveHeight;
        spectrogramRenderer.setLocation(0, top, this.plotDimension.width, this.plotDimension.height - this.waveHeight);
    }

    @Override
    protected void tweakWaveRenderer(SliceWaveRenderer waveRenderer) {
        int top = this.index * this.plotDimension.height;
        int width = this.plotDimension.width;
        waveRenderer.setLocation(0, top, width, this.waveHeight);
    }

    @Override
    protected void tweakNoDataRenderer(TextRenderer textRenderer) {
    }
}

