/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.WinstonDatabase;
import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

public class Data {
    private static final int ONE_DAY = 86400;
    private final WinstonDatabase winston;
    private final Channels channels;
    private final DateFormat dateFormat;
    private String vdxName;

    public Data(WinstonDatabase w) {
        this.winston = w;
        this.vdxName = "";
        this.channels = new Channels(w);
        this.dateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public double[] getTimeSpan(String code) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT st, et FROM `" + this.winston.databasePrefix + "_ROOT`.channels WHERE code='" + code + "'");
            rs.next();
            double[] d = new double[]{rs.getDouble(1), rs.getDouble(2)};
            rs.close();
            return d;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get time span for channel: " + code, e);
            return null;
        }
    }

    public double[] getTimeSpan(int sid) {
        String code = this.channels.getChannelCode(sid);
        return this.getTimeSpan(code);
    }

    private List<String> daysBetween(double t1, double t2) {
        ArrayList<String> result = new ArrayList<String>();
        for (double ct = t1; ct < t2 + 86400.0; ct += 86400.0) {
            result.add(Time.format("yyyy_MM_dd", ct));
        }
        return result;
    }

    public List<double[]> findGaps(String code, double t1, double t2) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        ArrayList<double[]> gaps = new ArrayList<double[]>();
        if (!this.winston.useDatabase(code)) {
            gaps.add(new double[]{t1, t2});
            return gaps;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd");
            List<String> days = this.daysBetween(t1, t2);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ArrayList<double[]> bufs = new ArrayList<double[]>(172800);
            for (String day : days) {
                double tst = Time.parse("yyyy_MM_dd", day);
                double tet = tst + 86400.0;
                String table = code + "$$" + day;
                if (!this.winston.tableExists(code, table) || tet < t1 || tst > t2) continue;
                ResultSet rs = this.winston.getStatement().executeQuery("SELECT st, et FROM `" + table + "` ORDER BY st ASC");
                while (rs.next()) {
                    double start = rs.getDouble(1);
                    double end = rs.getDouble(2);
                    if (end < t1 || start > t2) continue;
                    bufs.add(new double[]{start, end});
                }
                rs.close();
            }
            if (bufs == null || bufs.size() == 0) {
                gaps.add(new double[]{t1, t2});
                return gaps;
            }
            double epsilon = 0.01;
            if (((double[])bufs.get(0))[0] > t1) {
                gaps.add(new double[]{t1, ((double[])bufs.get(0))[0]});
            }
            double last = ((double[])bufs.get(0))[1];
            for (int i = 1; i < bufs.size(); ++i) {
                double[] buf = (double[])bufs.get(i);
                if (buf[0] - last > epsilon) {
                    double start = last;
                    double end = buf[0];
                    if (end < t1 || start > t2) continue;
                    if (start < t1) {
                        start = t1;
                    }
                    if (end > t2) {
                        end = t2;
                    }
                    gaps.add(new double[]{start, end});
                }
                last = buf[1];
            }
            if (((double[])bufs.get(bufs.size() - 1))[1] < t2) {
                gaps.add(new double[]{((double[])bufs.get(bufs.size() - 1))[1], t2});
            }
            return gaps;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Wave getWave(int sid, double t1, double t2, int maxrows) throws UtilException {
        String code = this.channels.getChannelCode(sid);
        return this.getWave(code, t1, t2, maxrows);
    }

    private byte[] getTraceBufBytes(ResultSet rs) throws SQLException, IOException {
        Blob b = rs.getBlob("tracebuf");
        byte[] bs = b.getBytes(1L, (int)b.length());
        bs = Util.decompress(bs, 512);
        return bs;
    }

    public List<byte[]> getTraceBufBytes(String code, double t1, double t2, int maxrows) throws UtilException {
        int numSamplesCounter = 0;
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            String[] initialDates;
            double ct = t1;
            ArrayList<byte[]> bufs = new ArrayList<byte[]>((int)Math.ceil(t2 - t1) + 1);
            String endDate = this.dateFormat.format(Util.j2KToDate(t2));
            boolean done = false;
            ResultSet rs = null;
            for (String date : initialDates = new String[]{this.dateFormat.format(Util.j2KToDate(t1 - 86400.0)), this.dateFormat.format(Util.j2KToDate(t1))}) {
                String sql = "SELECT st, et, sr, datatype, tracebuf FROM `" + code + "$$" + date + "` WHERE st<? ORDER BY st DESC LIMIT 1";
                PreparedStatement ps = this.winston.getPreparedStatement(sql);
                try {
                    ps.setDouble(1, t1);
                    rs = ps.executeQuery();
                    if (rs.next() && t1 >= rs.getDouble(1) && t1 <= rs.getDouble(2)) {
                        byte[] buf = this.getTraceBufBytes(rs);
                        if (maxrows > 0 && (numSamplesCounter += this.getNumSamples(rs.getDouble(1), rs.getDouble(2), rs.getDouble(3))) > maxrows) {
                            throw new UtilException("Max rows (" + maxrows + " rows) " + (this.vdxName.length() > 0 ? "for data source " + this.vdxName + " " : "") + "exceeded.");
                        }
                        bufs.add(buf);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.winston.getLogger().log(Level.FINEST, "No table found for " + date + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
                }
            }
            while (!done) {
                String date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                String sql = "SELECT st, et, sr, datatype, tracebuf FROM `" + code + "$$" + date + "` WHERE st>=" + t1 + " AND st<=" + t2 + " ORDER BY st ASC";
                try {
                    rs = this.winston.getStatement().executeQuery(sql);
                }
                catch (SQLException e) {
                    this.winston.getLogger().log(Level.FINEST, "No table found for " + code + "$$" + date);
                    ct += 86400.0;
                    continue;
                }
                while (rs.next()) {
                    byte[] buf = this.getTraceBufBytes(rs);
                    if (maxrows > 0 && (numSamplesCounter += this.getNumSamples(rs.getDouble(1), rs.getDouble(2), rs.getDouble(3))) > maxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) " + (this.vdxName.length() > 0 ? "for data source " + this.vdxName + " " : "") + "exceeded.");
                    }
                    bufs.add(buf);
                }
                rs.close();
                ct += 86400.0;
            }
            return bufs;
        }
        catch (SQLException e) {
            this.winston.getLogger().log(Level.FINEST, "Could not get TraceBuf bytes for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
        }
        catch (IOException e) {
            this.winston.getLogger().log(Level.FINEST, "Could not get TraceBuf bytes for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
        }
        return null;
    }

    private int getNumSamples(double st, double et, double sr) {
        return new Double(sr * (et - st)).intValue();
    }

    public List<TraceBuf> getTraceBufs(String code, double t1, double t2, int maxrows) throws UtilException {
        List<byte[]> rawBufs = this.getTraceBufBytes(code, t1, t2, maxrows);
        if (rawBufs == null || rawBufs.size() == 0) {
            return null;
        }
        try {
            ArrayList<TraceBuf> traceBufs = new ArrayList<TraceBuf>(rawBufs.size());
            for (byte[] buf : rawBufs) {
                traceBufs.add(new TraceBuf(buf));
            }
            return traceBufs;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get TraceBufs for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    public Wave getWave(String code, double t1, double t2, int maxrows) throws UtilException {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        List<TraceBuf> bufs = this.getTraceBufs(code, t1, t2, maxrows);
        if (bufs == null || bufs.size() == 0) {
            return null;
        }
        Wave wave = TraceBuf.traceBufToWave(bufs);
        wave.convertToJ2K();
        return wave;
    }

    public HelicorderData getHelicorderData(String code, double t1, double t2, int maxrows) throws UtilException {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            double ct = t1;
            String endDate = this.dateFormat.format(Util.j2KToDate(t2));
            boolean done = false;
            ArrayList<double[]> list = new ArrayList<double[]>((int)(t2 - t1) + 2);
            while (!done) {
                String date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                ct += 86400.0;
                String table = code + "$$H" + date;
                ResultSet rs = null;
                String sql = "SELECT j2ksec, smin, smax, rcnt FROM `" + table + "` WHERE j2ksec>=? AND j2ksec<=? ORDER BY j2ksec ASC";
                if (maxrows != 0) {
                    sql = sql + " LIMIT " + (maxrows + 1);
                    PreparedStatement s = this.winston.getPreparedStatement("SELECT COUNT(*) FROM (SELECT 1 " + sql.substring(sql.indexOf("FROM")) + ") as T");
                    try {
                        s.setDouble(1, t1);
                        s.setDouble(2, t2);
                        rs = s.executeQuery();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (rs.next() && rs.getInt(1) > maxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) " + (this.vdxName.length() > 0 ? "for data source " + this.vdxName + " " : "") + "exceeded.");
                    }
                }
                PreparedStatement select = this.winston.getPreparedStatement(sql);
                try {
                    select.setDouble(1, t1);
                    select.setDouble(2, t2);
                    rs = select.executeQuery();
                }
                catch (Exception e) {
                    continue;
                }
                while (rs.next()) {
                    double[] d = new double[]{rs.getDouble(1), rs.getDouble(2), rs.getDouble(3)};
                    list.add(d);
                }
                rs.close();
            }
            return new HelicorderData(list);
        }
        catch (SQLException e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get helicorder for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    public RSAMData getRSAMData(String code, double t1, double t2, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            double ct = t1;
            String endDate = this.dateFormat.format(Util.j2KToDate(t2));
            boolean done = false;
            int numSamplesCounter = 0;
            ArrayList<double[]> list = new ArrayList<double[]>((int)(t2 - t1) + 2);
            while (!done) {
                String date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                ct += 86400.0;
                String table = code + "$$H" + date;
                ResultSet rs = null;
                String sql = "SELECT j2ksec, rsam FROM `" + table + "` WHERE j2ksec>=" + t1 + " AND j2ksec<=" + t2 + " AND rcnt>0" + " ORDER BY j2ksec";
                try {
                    sql = Data.getDownsamplingSQL(sql, t1, ds, dsInt);
                }
                catch (UtilException e) {
                    throw new UtilException("Can't downsample dataset: " + e.getMessage());
                }
                if (maxrows != 0) {
                    sql = sql + " LIMIT " + (maxrows + 1);
                    if (ds.equals((Object)DownsamplingType.NONE)) {
                        try {
                            rs = this.winston.getStatement().executeQuery("SELECT COUNT(*) FROM (SELECT 1 " + sql.substring(sql.indexOf("FROM")) + ") as T");
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (rs.next() && rs.getInt(1) > maxrows) {
                            throw new UtilException("Max rows (" + maxrows + " rows) " + (this.vdxName.length() > 0 ? "for data source " + this.vdxName + " " : "") + "exceeded.");
                        }
                    }
                }
                try {
                    rs = this.winston.getStatement().executeQuery(sql);
                }
                catch (Exception e) {
                    continue;
                }
                if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && (numSamplesCounter += Data.getResultSetSize(rs)) > maxrows) {
                    throw new UtilException("Max rows (" + maxrows + " rows) " + (this.vdxName.length() > 0 ? "for data source " + this.vdxName + " " : "") + "exceeded.");
                }
                while (rs.next()) {
                    double[] d = new double[]{rs.getDouble(1), rs.getDouble(2)};
                    list.add(d);
                }
                rs.close();
            }
            return new RSAMData(list);
        }
        catch (SQLException e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get RSAM for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    private static String getDownsamplingSQL(String sql, double startTime, DownsamplingType ds, int dsInt) throws UtilException {
        if (!ds.equals((Object)DownsamplingType.NONE) && dsInt <= 1) {
            throw new UtilException("Downsampling interval should be more than 1");
        }
        if (ds.equals((Object)DownsamplingType.NONE)) {
            return sql;
        }
        if (ds.equals((Object)DownsamplingType.DECIMATE)) {
            return "SELECT * FROM(SELECT fullQuery.*, @row := @row+1 AS rownum FROM (" + sql + ") fullQuery, (SELECT @row:=0) r) ranked WHERE rownum % " + dsInt + " = 1";
        }
        if (ds.equals((Object)DownsamplingType.MEAN)) {
            String sql_select_clause = sql.substring(6, sql.toUpperCase().indexOf("FROM") - 1);
            String sql_from_where_clause = sql.substring(sql.toUpperCase().indexOf("FROM") - 1, sql.toUpperCase().lastIndexOf("ORDER BY") - 1);
            String[] columns = sql_select_clause.split(",");
            String avg_sql = "SELECT ";
            for (String column : columns) {
                avg_sql = avg_sql + "AVG(" + column.trim() + "), ";
            }
            avg_sql = avg_sql + "((j2ksec-" + startTime + ") DIV " + dsInt + ") intNum ";
            avg_sql = avg_sql + sql_from_where_clause;
            avg_sql = avg_sql + " GROUP BY intNum";
            return avg_sql;
        }
        throw new UtilException("Unknown downsampling type: " + (Object)((Object)ds));
    }

    public void setVdxName(String name) {
        this.vdxName = name;
    }

    public static int getResultSetSize(ResultSet rs) throws SQLException {
        int size = 0;
        int currentRow = rs.getRow();
        if (rs != null) {
            rs.beforeFirst();
            rs.last();
            size = rs.getRow();
            if (currentRow == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(currentRow);
            }
        }
        return size;
    }
}

