/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http;

import gov.usgs.math.DownsamplingType;
import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.plot.decorate.DefaultFrameDecorator;
import gov.usgs.plot.render.MatrixRenderer;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.AbstractHttpCommand;
import gov.usgs.winston.server.cmd.http.HttpBaseCommand;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.TimeZone;

public final class HttpRsamCommand
extends AbstractHttpCommand
implements HttpBaseCommand {
    private static final int DEFAULT_H = 300;
    private static final int DEFAULT_W = 900;
    private static final boolean DEFAULT_DS = false;
    private static final int DEFAULT_DSP = 0;
    private static final boolean DEFAULT_DT = false;
    private static final String DEFAULT_T1 = "-12";
    private static final String DEFAULT_T2 = "now";
    private static final String DEFAULT_MAX = "auto";
    private static final String DEFAULT_MIN = "auto";
    private static final boolean DEFAULT_RM = false;
    private static final boolean DEFAULT_CSV = false;
    private static final int DEFAULT_RMP = 300;
    private TimeZone timeZone;
    private int timeZoneOffset;
    private Double endTime;
    private Double startTime;
    private int width;
    private int height;
    private boolean detrend;
    private boolean despike;
    private double despikePeriod;
    private boolean runningMedian;
    private double runningMedianPeriod;
    private double plotMax;
    private double plotMin;
    private boolean outputData;
    private String errorString = "";
    private String code;
    private RSAMData rsamData;

    public HttpRsamCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    private String parseArguments() {
        this.code = (String)this.arguments.get("code");
        if (this.code == null) {
            this.errorString = this.errorString + "Error: you must specify a channel (code).<br>";
        } else {
            this.code = this.code.replace('_', '$');
            if (this.code.indexOf(";") != -1) {
                this.errorString = this.errorString + "Error: illegal characters in channel (code).<br>";
            }
        }
        this.timeZone = TimeZone.getTimeZone(Util.stringToString((String)this.arguments.get("tz"), "UTC"));
        this.endTime = this.getEndTime((String)this.arguments.get("t2"));
        if (this.endTime == Double.NaN) {
            this.errorString = this.errorString + "Error: could not parse end time (t2). Should be yyyyMMddHHmm.<br>";
        }
        this.startTime = this.getStartTime((String)this.arguments.get("t1"), this.endTime, 86400L);
        if (this.startTime == Double.NaN) {
            this.errorString = this.errorString + "Error: could not parse start time (t1). Should be yyyyMMddHHmm or -HH.M<br>";
        }
        this.timeZoneOffset = this.timeZone.getOffset((long)Util.j2KToEW(this.endTime) * 1000L) / 1000;
        this.width = Util.stringToInt((String)this.arguments.get("w"), 900);
        this.height = Util.stringToInt((String)this.arguments.get("h"), 300);
        if (this.height * this.width <= 0 || this.height * this.width > this.wws.httpMaxSize()) {
            this.errorString = this.errorString + "Error: product of width (w) and height (h) must be between 1 and " + this.wws.httpMaxSize() + ".<br>";
        }
        this.detrend = Util.stringToBoolean((String)this.arguments.get("dt"), false);
        this.despike = Util.stringToBoolean((String)this.arguments.get("ds"), false);
        this.despikePeriod = Util.stringToDouble((String)this.arguments.get("dsp"), 0.0);
        this.runningMedian = Util.stringToBoolean((String)this.arguments.get("rm"), false);
        this.runningMedianPeriod = Util.stringToDouble((String)this.arguments.get("rmp"), 300.0);
        this.plotMax = Util.stringToDouble((String)this.arguments.get("max"), Double.MAX_VALUE);
        this.plotMin = Util.stringToDouble((String)this.arguments.get("min"), Double.MIN_VALUE);
        this.outputData = Util.stringToBoolean((String)this.arguments.get("csv"), false);
        return this.errorString;
    }

    private void getData() {
        this.rsamData = null;
        try {
            this.rsamData = this.data.getRSAMData(this.code, this.startTime, this.endTime, 0, DownsamplingType.NONE, 0);
            this.rsamData.adjustTime(this.timeZoneOffset);
            if (this.despike) {
                this.rsamData.despike(1, this.despikePeriod);
            }
            if (this.detrend) {
                this.rsamData.detrend(1);
            }
            if (this.runningMedian) {
                this.rsamData.set2median(1, this.runningMedianPeriod);
            }
        }
        catch (UtilException e) {
            this.writeSimpleHTML("Error: could not get RSAM data, check channel (code). e = " + e.toString());
        }
        if (this.rsamData == null || this.rsamData.rows() <= 0) {
            this.writeSimpleHTML("Error: could not get RSAM data, check channel (code). Empty result.");
        }
    }

    private void sendPlot() {
        HttpResponse response = new HttpResponse("image/png");
        response.setVersion(this.request.getVersion());
        if (this.wws.httpRefreshInterval() > 0) {
            response.setHeader("Refresh:", this.wws.httpRefreshInterval() + "; url=" + this.request.getResource());
        }
        Plot plot = new Plot();
        plot.setSize(this.width, this.height);
        plot.setBackgroundColor(new Color(0.97f, 0.97f, 0.97f));
        MatrixRenderer mr = new MatrixRenderer(this.rsamData.getData(), false);
        double max = Math.min(this.plotMax, this.rsamData.max(1) + this.rsamData.max(1) * 0.1);
        double min = Math.max(this.plotMin, this.rsamData.min(1) - this.rsamData.max(1) * 0.1);
        mr.setExtents(this.startTime + (double)this.timeZoneOffset, this.endTime + (double)this.timeZoneOffset, min, max);
        mr.setLocation(70, 35, this.width - 140, this.height - 70);
        mr.createDefaultAxis();
        mr.setXAxisToTime(8, true, true);
        String tzText = this.timeZone.getDisplayName(this.timeZone.inDaylightTime(Util.j2KToDate(this.endTime)), 0);
        String bottomText = "(" + Util.j2KToDateString(this.startTime + (double)this.timeZoneOffset, "yyyy-MM-dd HH:mm") + " to " + Util.j2KToDateString(this.endTime + (double)this.timeZoneOffset, "yyyy-MM-dd HH:mm") + " " + tzText + ")";
        mr.getAxis().setBottomLabelAsText(bottomText);
        mr.getAxis().setLeftLabelAsText("RSAM");
        DefaultFrameDecorator.addLabel(mr, this.code.replace('$', ' '), DefaultFrameDecorator.Location.LEFT);
        mr.createDefaultLineRenderers(Color.blue);
        plot.addRenderer(mr);
        try {
            byte[] png = plot.getPNGBytes();
            response.setLength(png.length);
            this.netTools.writeString(response.getHeaderString(), this.socketChannel);
            this.netTools.writeByteBuffer(ByteBuffer.wrap(png), this.socketChannel);
        }
        catch (PlotException e) {
            e.printStackTrace();
            this.errorString = this.errorString + "Error: Can not create plot.";
        }
    }

    private void sendData() {
        String html = this.rsamData.toCSV();
        HttpResponse response = new HttpResponse("text/csv; charset=utf-8");
        String fileName = this.code + "-RSAM.csv";
        response.setHeader("content-Disposition:", "attachment; filename='" + fileName + "'");
        response.setLength(html.length());
        response.setCode("200");
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(html, this.socketChannel);
    }

    @Override
    protected void sendResponse() {
        this.errorString = this.parseArguments();
        if (this.errorString.length() > 0) {
            this.writeSimpleHTML(this.errorString);
        } else {
            this.getData();
            if (this.outputData) {
                this.sendData();
            } else {
                this.sendPlot();
            }
        }
    }

    @Override
    public String getUsage(HttpRequest req) {
        StringBuilder output = new StringBuilder();
        output.append("<script>function buildRsamUrl() {var urlDiv = document.getElementById(\"rsamUrl\");\nvar rsamW = document.getElementById(\"rsamW\");\nvar rsamH = document.getElementById(\"rsamH\");\nvar rsamDT = document.getElementById(\"rsamDT\");\nvar rsamDS = document.getElementById(\"rsamDS\");\nvar rsamDSP = document.getElementById(\"rsamDSP\");\nvar rsamRM = document.getElementById(\"rsamRM\");\nvar rsamRMP = document.getElementById(\"rsamRMP\");\nvar rsamMIN = document.getElementById(\"rsamMIN\");\nvar rsamMAX = document.getElementById(\"rsamMAX\");\nvar rsamTZ = document.getElementById(\"rsamTZ\");\nvar rsamT1 = document.getElementById(\"rsamT1\");\nvar rsamT2 = document.getElementById(\"rsamT2\");\nvar csv = document.getElementById(\"rsamCSV\");\nvar rsamCODE = document.getElementById(\"rsamCODE\");\nvar a = document.createElement('a');\nvar linkUrl = \"http://" + req.getHeader("Host") + "/rsam?\";\n");
        output.append("linkUrl += \"code=\" + rsamCODE.value;");
        output.append("if (rsamT1.value != \"-12\" && rsamT1.value != \"\") { linkUrl += \"&t1=\" + rsamT1.value;}\n");
        output.append("if (rsamT2.value != \"now\" && rsamT2.value != \"\") { linkUrl += \"&t2=\" + rsamT2.value;}\n");
        output.append("if (rsamW.value != \"900\" && rsamW.value != \"\") { linkUrl += \"&w=\" + rsamW.value;}\n");
        output.append("if (rsamH.value != \"300\" && rsamH.value != \"\") { linkUrl += \"&h=\" + rsamH.value;}\n");
        output.append("if (rsamMIN.value != \"auto\" && rsamMIN.value != \"\") { linkUrl += \"&min=\" + rsamMIN.value;}\n");
        output.append("if (rsamMAX.value != \"auto\" && rsamMAX.value != \"\") { linkUrl += \"&max=\" + rsamMAX.value;}\n");
        output.append("if (rsamDT.checked != \"\") { linkUrl += \"&dt=1\";}\n");
        output.append("if (rsamCSV.checked != \"\") { linkUrl += \"&csv=1\";}\n");
        output.append("if (rsamDS.checked != \"\") { linkUrl += \"&ds=1\"; if (rsamDSP.value != \"0\" && rsamDSP.value != \"\") { linkUrl += \"&dsp=\" + rsamDSP.value;}}\n");
        output.append("if (rsamRM.checked != \"\") { linkUrl += \"&rm=1\"; if (rsamRMP.value != \"300\" && rsamRMP.value != \"\") { linkUrl += \"&rmp=\" + rsamRMP.value;}}\n");
        output.append("if (rsamTZ.value != \"UTC\") { linkUrl += \"&tz=\" + rsamTZ.value;}\n");
        output.append("linkUrl = linkUrl.replace(\"?&\", \"?\");\n");
        output.append("linkUrl = linkUrl.replace(/\\?$/, \"\");\n");
        output.append("a.href = linkUrl;\na.text = linkUrl;\na.textContent = linkUrl; \nwhile(urlDiv.hasChildNodes()) {urlDiv.removeChild(urlDiv.lastChild);}urlDiv.appendChild(a);\nrsamDSP.disabled = !rsamDS.checked; rsamRMP.disabled = !rsamRM.checked;}</script>\n");
        output.append("Plots precomputed RSAM values. \n");
        output.append("<div class=\"tabContentTitle\">URL Builder</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<FORM>\n");
        output.append("<div class=\"left\">\n");
        output.append("<div class=\"left\">Channel<BR>");
        output.append("<select id=\"rsamCODE\" onchange=\"buildRsamUrl()\" name=\"code\" class=\"channel\" size=8></select></div>\n");
        output.append("<div class=\"right\">Time zone<br>");
        output.append("<select onchange=\"buildRsamUrl()\" class=\"timeZone\" id=\"rsamTZ\" name=\"tz\" size=8></select></div>\n");
        output.append("<div class=\"clear\"></div>");
        output.append("<P><br><p><div class=\"left\"><div class=\"timeInput\"><label for=\"t1\">Start Time</label></div><input type=text id=\"rsamT1\" onchange=\"buildRsamUrl()\" name=\"t1\" size=10 value=\"-12\"></div><br>");
        output.append("<div class=\"left\"><div class=\"timeInput\"><label for=\"t2\">End Time</label></div><input type=text id=\"rsamT2\" onchange=\"buildRsamUrl()\" name=\"t2\" size=10 value=\"now\"></div><br>");
        output.append("</div>\n");
        output.append("<div class=\"right\" style=\"padding-right:15px;\">\n");
        output.append("<div class=\"input\"><label for=\"w\">Width</label><input type=text id=\"rsamW\" onchange=\"buildRsamUrl()\" name=\"w\" size=3 value=\"900\"></div>");
        output.append("<div class=\"input\"><label for=\"h\">Height</label><input type=text id=\"rsamH\" onchange=\"buildRsamUrl()\" name=\"h\" size=3 value=\"300\"></div>");
        output.append("<div class=\"input\"><label for=\"max\">Plot Max</label><input type=text id=\"rsamMAX\" onchange=\"buildRsamUrl()\" name=\"max\" size=3 value=\"auto\"></div>");
        output.append("<div class=\"input\"><label for=\"min\">Plot Min</label><input type=text id=\"rsamMIN\" onchange=\"buildRsamUrl()\" name=\"min\" size=3 value=\"auto\"></div>");
        output.append("<div class=\"input\"><label for=\"dt\">Detrend?</label><input class=\"checkbox\" type=checkbox id=\"rsamDT\" onchange=\"buildRsamUrl()\" name=\"dt\"></div>");
        output.append("<div class=\"input\"><label for=\"ds\">Filter Spikes?</label><input class=\"checkbox\" type=checkbox id=\"rsamDS\" onchange=\"buildRsamUrl()\" name=\"ds\"></div>");
        output.append("<div class=\"input\"><label for=\"dsp\">Period</label><input type=text id=\"rsamDSP\" onchange=\"buildRsamUrl()\" name=\"pds\" size=3 value=\"0\"></div>");
        output.append("<div class=\"input\"><label for=\"rm\">Remove Median?</label><input class=\"checkbox\" type=checkbox id=\"rsamRM\" onchange=\"buildRsamUrl()\" name=\"rm\" checked></div>");
        output.append("<div class=\"input\"><label for=\"rmp\">Period</label><input type=text id=\"rsamRMP\" onchange=\"buildRsamUrl()\" name=\"rmp\" size=3 value=\"600\"></div>");
        output.append("<div class=\"input\"><label for=\"csv\">Return CSV?</label><input class=\"checkbox\" type=checkbox id=\"rsamCSV\" onchange=\"buildRsamUrl()\" name=\"csv\"></div>");
        output.append("</div><br></FORM><div class=\"clear\"></div>\n");
        output.append("<HR class=\"urlBuilder\"><b>URL:</b><BR><div id=\"rsamUrl\"></div>");
        output.append("</div>");
        output.append("<div class=\"tabContentTitle\">Arguments</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("The options (separated by the & character, all optional except for <code>code</code> ) are defined as follows:<br><br><code>w</code>: <b>Width</b> in pixels of the returned image (default = 900).<br><br><code>h</code>: <b>Height</b> in pixels of the returned image (default = 300).<br><br><code>t1</code>: <b>Start Time</b> The start time (local) of the rsam plot as given by the number of days before present or a specific time in the format YYYYMMDDHHMM.  Note that, in the first case, this is a negative number (default = -12).<br><br><code>t2</code>: <b>End Time</b> The end time (local) of the rsam plot as given by the format YYYYMMDDHHMM or 'now' (default = now).<br><br><code>dt</code>: <b>Detrend</b> Whether to detrend (linear) the plot, 1 is yes, 0 is no (default = false).<br><br><code>ds</code>: <b>Despike</b> Whether to despike (mean) the plot, 1 is yes, 0 is no (default = false).<br><br><code>dsp</code>: <b>Despike Period</b> Period to use for despike (default = 0).<br><br><code>max</code>: <b>Plot Max</b> Largest value to plot<BR><BR><code>min</code>: <b>Plot Min</b> Smallest value to plot<BR><BR><code>csv</code>: <b>CSV</b> Whether to return a CSV file rather than a plot, 1 is yes, 0 is no (default = false).<br><br><code>rm</code>: <b>Running Median</b>Whether to apply a running median filter<br><br><code>rmp</code>: <b>Running Median Period</b> Period to use for running medial, in seconds (defualt = 300)<br><br><code>tz</code>: <b>Time Zone</b> The time zone, a complete list of time zones that WWS understands is shown below.<br><br>");
        output.append("</div>");
        return output.toString();
    }

    @Override
    public String getAnchor() {
        return "rsam";
    }

    @Override
    public String getTitle() {
        return "RSAM";
    }

    @Override
    public String getCommand() {
        return "/rsam";
    }
}

