/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.constraint;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeConstraint;
import java.text.ParseException;

public class FdsnTimeSimpleConstraint
extends FdsnTimeConstraint {
    public final double startTime;
    public final double endTime;

    public FdsnTimeSimpleConstraint(String startTime, String endTime) throws FdsnException {
        try {
            this.startTime = this.dateStringToDouble(startTime, "1970-01-01T00:00:00.0000");
            this.endTime = this.dateStringToDouble(endTime, "2070-01-01T00:00:00.0000");
        }
        catch (ParseException e) {
            throw new FdsnException(400, "Can't parse time constraint: " + this);
        }
    }

    @Override
    public boolean matches(Channel chan) {
        double end = chan.getMaxTime();
        if (end != Double.NaN && chan.getMaxTime() > this.endTime) {
            return false;
        }
        double start = chan.getMinTime();
        return start == Double.NaN || !(chan.getMinTime() < this.startTime);
    }

    public boolean matches(TraceBuf buf) {
        double end = buf.lastSampleTime() + buf.samplingPeriod();
        if (end > this.endTime) {
            return false;
        }
        double start = buf.firstSampleTime();
        return !(start < this.startTime);
    }

    public String toString() {
        return "FdsnTimeSimpleConstraint: " + Util.j2KToDateString(this.startTime) + ":" + Util.j2KToDateString(this.endTime);
    }
}

