/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.dataselect;

import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.command.FdsnQueryCommand;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnChannelConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeSimpleConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.dataselect.FdsnDataselectService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class FdsnDataselectQuery
extends FdsnQueryCommand
implements FdsnDataselectService {
    public FdsnDataselectQuery(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
        this.version = "1.1.0";
    }

    @Override
    public String getCommand() {
        return "/fdsnws/dataselect/1/query";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendResponse() {
        HttpResponse response = new HttpResponse("text/plain");
        response.setLength("".length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        OutputStream outputStream = null;
        try {
            outputStream = this.socketChannel.socket().getOutputStream();
            for (Channel c : this.prunedChanList) {
                this.sendData(c, outputStream);
            }
        }
        catch (IOException e) {
            this.sendError(500, "bad");
        }
        catch (FdsnException e) {
            this.sendError(500, e.message);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {}
        }
    }

    private void sendData(Channel chan, OutputStream outputStream) throws IOException, FdsnException {
        int minLength;
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            minLength = Integer.parseInt((String)this.arguments.get("minimumlength"));
        }
        catch (NumberFormatException e) {
            minLength = -1;
        }
        FdsnChannelConstraint channelConstraint = null;
        Iterator i$ = this.channelConstraints.iterator();
        while (i$.hasNext()) {
            FdsnChannelConstraint c;
            channelConstraint = c = (FdsnChannelConstraint)i$.next();
            if (!c.matches(chan)) continue;
            break;
        }
        if (channelConstraint == null) {
            return;
        }
        FdsnTimeSimpleConstraint timeConstraint = channelConstraint.getTimeConstraint();
        if (timeConstraint == null) {
            return;
        }
        double start = timeConstraint.startTime;
        ArrayList<TraceBuf> bufs = new ArrayList<TraceBuf>();
        int seq = 0;
        while (start < timeConstraint.endTime) {
            double end = Math.min(start + 3600.0, timeConstraint.endTime);
            try {
                bufs.addAll(this.data.getTraceBufs(chan.getCode(), start, end, 0));
            }
            catch (UtilException e) {
                e.printStackTrace();
            }
            ListIterator it = bufs.listIterator();
            while (it.hasNext()) {
                TraceBuf tb = (TraceBuf)it.next();
                DataHeader header = new DataHeader(seq++, 'D', false);
                header.setStationIdentifier(chan.station);
                header.setChannelIdentifier(chan.channel);
                header.setNetworkCode(chan.network);
                header.setLocationIdentifier(chan.location);
                header.setNumSamples((short)tb.bytes.length);
                header.setSampleRate(tb.samplingRate());
                Btime btime = new Btime(Util.j2KToDate(tb.firstSampleTime()));
                header.setStartBtime(btime);
                DataRecord record = new DataRecord(header);
                try {
                    Blockette1000 blockette1000 = new Blockette1000();
                    blockette1000.setEncodingFormat((byte)11);
                    blockette1000.setWordOrder((byte)1);
                    blockette1000.setDataRecordLength((byte)12);
                    record.addBlockette((Blockette)blockette1000);
                    SteimFrameBlock data = null;
                    data = Steim2.encode((int[])tb.samples(), (int)63);
                    record.setData(data.getEncodedData());
                    record.write(dos);
                }
                catch (SeedFormatException e) {
                    e.printStackTrace();
                }
                catch (SteimException e) {
                    e.printStackTrace();
                }
            }
            start = end;
        }
    }
}

