/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.SCN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Menu {
    private List<MenuItem> items = new ArrayList<MenuItem>();
    private boolean isScnl = false;
    private static final String MENU_DELIMITER = "  ";

    public Menu(String menu) {
        this.parseMenu(menu);
    }

    public boolean isSCNL() {
        return this.isScnl;
    }

    public List<MenuItem> getItems() {
        return this.items;
    }

    public List<MenuItem> getSortedItems() {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>(this.items);
        Collections.sort(list);
        return list;
    }

    public int numItems() {
        return this.items.size();
    }

    @Deprecated
    public MenuItem getItem(SCN scn) {
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem mi = this.items.get(i);
            if (!mi.isSCN(scn.station, scn.channel, scn.network)) continue;
            return mi;
        }
        return null;
    }

    public boolean channelExists(String channel) {
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem mi = this.items.get(i);
            if (!mi.getSCNSCNL("$").equals(channel)) continue;
            return true;
        }
        return false;
    }

    private void parseMenu(String menu) {
        String[] entries;
        menu = menu.substring(menu.indexOf(MENU_DELIMITER) + 2);
        for (String entry : entries = menu.split(MENU_DELIMITER)) {
            this.items.add(new MenuItem(entry));
        }
        if (this.items.get((int)0).location != null) {
            this.isScnl = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MenuItem mi : this.items) {
            sb.append(mi.toFullString() + "\n");
        }
        return sb.toString();
    }
}

