/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SacDataFile
extends SeismicDataFile {
    private SacTimeSeries sac;
    private SacHeader header;

    protected SacDataFile(String fileName) {
        super(fileName, "SAC^");
    }

    @Override
    public void read() throws IOException {
        this.sac = new SacTimeSeries(this.fileName);
        this.header = this.sac.getHeader();
        String channel = this.header.getKstnm().trim() + "$" + this.header.getKcmpnm().trim() + "$" + this.header.getKnetwk().trim();
        Wave sw = new Wave();
        sw.setStartTime(Util.dateToJ2K(this.getStartTime()));
        sw.setSamplingRate(this.getSamplingRate());
        sw.buffer = new int[this.sac.getY().length];
        for (int i = 0; i < this.sac.getY().length; ++i) {
            sw.buffer[i] = Math.round(this.sac.getY()[i]);
        }
        this.waves.put(channel, sw);
    }

    private double getSamplingRate() {
        return 1.0f / this.header.getDelta();
    }

    private Date getStartTime() {
        if (this.sac == null) {
            return null;
        }
        String ds = this.header.getNzyear() + "," + this.header.getNzjday() + "," + this.header.getNzhour() + "," + this.header.getNzmin() + "," + this.header.getNzsec() + "," + this.header.getNzmsec();
        SimpleDateFormat format = new SimpleDateFormat("yyyy,DDD,HH,mm,ss,SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = null;
        try {
            d = format.parse(ds);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    @Override
    public void write() throws FileNotFoundException, IOException {
        Wave wave = (Wave)this.waves.values().iterator().next();
        float[] y = new float[wave.buffer.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = wave.buffer[i];
        }
        SacTimeSeries sac = new SacTimeSeries(this.getSacHeader(), y);
        sac.write(this.fileName);
    }

    private SacHeader getSacHeader() {
        SacHeader header = new SacHeader();
        String channel = (String)this.waves.keySet().iterator().next();
        Wave wave = (Wave)this.waves.get(channel);
        String[] channelCmp = channel.split("_");
        String s = channelCmp.length > 0 ? channelCmp[0] : "";
        String c = channelCmp.length > 1 ? channelCmp[1] : "";
        String n = channelCmp.length > 2 ? channelCmp[2] : "";
        String l = channelCmp.length > 3 ? channelCmp[3] : "";
        header.setKstnm(s);
        header.setKcmpnm(c);
        header.setKnetwk(n);
        header.setKhole(l);
        Calendar cal = Calendar.getInstance();
        cal.setTime(Util.j2KToDate(wave.getStartTime()));
        header.setNzyear(1);
        header.setNzjday(6);
        header.setNzhour(11);
        header.setNzmin(12);
        header.setNzsec(13);
        header.setNzmsec(14);
        header.setDelta((float)wave.getSamplingPeriod());
        header.setNpts(wave.numSamples());
        return header;
    }
}

