/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SeisanDataFile
extends SeismicDataFile {
    private ByteOrder byteOrder;
    private int channelCount;
    private int machineIntLength;

    protected SeisanDataFile(String fileName) {
        super(fileName, "Seisan^");
    }

    @Override
    public void read() throws IOException {
        FileInputStream fis = new FileInputStream(this.fileName);
        BufferedInputStream buf = new BufferedInputStream(fis);
        this.detectArchetecture(buf);
        this.readEventFileHeader(buf);
        for (int i = 0; i < this.channelCount; ++i) {
            this.readChannel(buf);
        }
    }

    private void detectArchetecture(BufferedInputStream bis) throws IOException {
        byte[] bytes = new byte[8];
        bis.mark(Integer.MAX_VALUE);
        bis.read(bytes);
        bis.reset();
        this.byteOrder = bytes[0] == 80 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        boolean is64Bit = bytes[7] == 80 || bytes[7] == 0;
        this.machineIntLength = is64Bit ? 8 : 4;
    }

    private void readEventFileHeader(BufferedInputStream bis) throws IOException {
        String headerLine = new String(this.readRecord(bis));
        this.channelCount = Integer.parseInt(headerLine.substring(30, 33).trim());
        System.out.println("CHANNEL COUNT " + this.channelCount + " :" + headerLine.substring(30, 33) + ":");
        int numHeaderLines = 2 + (this.channelCount + 2) / 3;
        for (int i = 1; i < Math.max(numHeaderLines, 12); ++i) {
            this.readRecord(bis);
        }
    }

    private void readChannel(BufferedInputStream bis) throws IOException {
        byte[] channelHeader = this.readRecord(bis);
        String code = this.extractCode(channelHeader);
        if (!this.waves.containsKey(code)) {
            this.waves.put(code, null);
        }
        double start = Util.ewToJ2K((double)this.extractStartTime(channelHeader) / 1000.0);
        double samplingRate = Double.parseDouble(new String(channelHeader, 36, 7).trim());
        int sampleCount = Integer.parseInt(new String(channelHeader, 43, 7).trim());
        char c = (char)channelHeader[76];
        if (c == ' ') {
            c = '\u0002';
        }
        int intLength = Integer.parseInt("" + c);
        int[] samples = new int[sampleCount];
        int sampleIndex = 0;
        while (sampleIndex < sampleCount) {
            byte[] data = this.readRecord(bis);
            for (int i = 0; i < data.length; i += intLength) {
                byte[] b = Arrays.copyOfRange(data, i, i + intLength);
                samples[sampleIndex++] = this.decodeInt(b);
            }
        }
        this.waves.put(code, new Wave(samples, start, samplingRate));
    }

    private long extractStartTime(byte[] header) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int year = Integer.parseInt(new String(header, 9, 3).trim()) + 1900;
        c.set(1, year);
        int month = Integer.parseInt(new String(header, 17, 2).trim());
        c.set(2, month - 1);
        int day = Integer.parseInt(new String(header, 20, 2).trim());
        c.set(5, day);
        int hour = Integer.parseInt(new String(header, 23, 2).trim());
        c.set(11, hour);
        int min = Integer.parseInt(new String(header, 26, 2).trim());
        c.set(12, min);
        double sec = Float.parseFloat(new String(header, 29, 6).trim());
        c.set(13, (int)sec);
        double ms = (sec - Math.floor(sec)) * 1000.0;
        c.set(14, (int)ms);
        return c.getTimeInMillis();
    }

    private String extractCode(byte[] header) {
        String loc;
        String cmp;
        boolean ewBug = false;
        char c1 = (char)header[7];
        char c2 = (char)header[8];
        if ((c1 == 'E' || c1 == 'Z' || c1 == 'N') && c2 != 'E' && c2 != 'Z' && c2 != 'N') {
            ewBug = true;
        }
        String station = new String(header, 0, 5);
        if (ewBug) {
            cmp = new String(header, 5, 2) + new String(header, 7, 1);
            loc = new String(header, 8, 1) + new String(header, 12, 1);
        } else {
            cmp = new String(header, 5, 2) + new String(header, 8, 1);
            loc = new String(header, 7, 1) + new String(header, 12, 1);
        }
        if (this.channel == null) {
            this.channel = cmp;
        }
        if (this.location == null) {
            this.location = loc;
        }
        if (this.network == null) {
            this.network = new String(header, 16, 1) + new String(header, 19, 1);
        }
        String code = station.trim() + "_" + this.channel.trim() + "_" + this.network.trim();
        if (!"--".equals(this.location) && !"  ".equals(this.location)) {
            code = code + "_" + this.location.trim();
        }
        return code;
    }

    @Override
    public void write() throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(this.fileName));
        this.writeEventFileHeader(fos);
        for (String code : this.waves.keySet()) {
            Wave wave = (Wave)this.waves.get(code);
            this.writeChannelHeader(fos, code);
            byte[] bytes = new byte[wave.numSamples() * 4];
            for (int i = 0; i < wave.numSamples(); ++i) {
                System.arraycopy(this.intAsBytes(wave.buffer[i]), 0, bytes, i * 4, 4);
            }
            this.writeRecord(fos, bytes);
        }
        fos.close();
    }

    public void writeEventFileHeader(FileOutputStream fos) throws IOException {
        byte[] header = new byte[80];
        Arrays.fill(header, (byte)32);
        byte[] b = ("" + this.waves.size()).getBytes();
        System.arraycopy(b, 0, header, 31, Math.min(b.length, 3));
        double fileStart = Double.MAX_VALUE;
        double fileEnd = -1.7976931348623157E308;
        for (String code : this.waves.keySet()) {
            fileStart = Math.min(fileStart, ((Wave)this.waves.get(code)).getStartTime());
            fileEnd = Math.max(fileEnd, ((Wave)this.waves.get(code)).getEndTime());
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(Util.j2KToDate(fileStart));
        b = ("" + (c.get(1) - 1900)).getBytes();
        System.arraycopy(b, 0, header, 33, Math.min(b.length, 3));
        b = ("" + c.get(6)).getBytes();
        System.arraycopy(b, 0, header, 37, Math.min(b.length, 3));
        b = ("" + (c.get(2) + 1)).getBytes();
        System.arraycopy(b, 0, header, 41, Math.min(b.length, 2));
        b = ("" + c.get(5)).getBytes();
        System.arraycopy(b, 0, header, 44, Math.min(b.length, 2));
        b = ("" + c.get(11)).getBytes();
        System.arraycopy(b, 0, header, 47, Math.min(b.length, 2));
        b = ("" + c.get(12)).getBytes();
        System.arraycopy(b, 0, header, 50, Math.min(b.length, 2));
        float f = c.get(13) + c.get(14) / 1000;
        b = String.format("%6.3f", Float.valueOf(f)).getBytes();
        System.arraycopy(b, 0, header, 53, Math.min(b.length, 6));
        b = String.format("%9.3f", fileEnd - fileStart).getBytes();
        System.arraycopy(b, 0, header, 60, 9);
        this.writeRecord(fos, header);
        Arrays.fill(header, (byte)32);
        this.writeRecord(fos, header);
        int chanIdx = 0;
        for (String code : this.waves.keySet()) {
            String[] comps;
            Wave wave = (Wave)this.waves.get(code);
            if (chanIdx % 3 == 0) {
                if (chanIdx > 0) {
                    this.writeRecord(fos, header);
                }
                Arrays.fill(header, (byte)32);
            }
            if ((comps = code.split("_")).length > 0) {
                b = comps[0].getBytes();
                System.arraycopy(b, 0, header, chanIdx % 3 * 26 + 1, Math.min(b.length, 4));
                if (b.length > 4) {
                    System.arraycopy(b, 4, header, chanIdx % 3 * 26 + 9, 1);
                }
            }
            if (comps.length > 1) {
                b = comps[1].getBytes();
                System.arraycopy(b, 0, header, chanIdx % 3 * 26 + 5, Math.min(b.length, 2));
                if (b.length > 2) {
                    System.arraycopy(b, 2, header, chanIdx % 3 * 26 + 8, 1);
                }
            }
            double channelStart = wave.getStartTime() - fileStart;
            b = String.format("%7.2f", channelStart).getBytes();
            System.arraycopy(b, 0, header, chanIdx % 3 * 26 + 10, 7);
            double dataLen = wave.getEndTime() - wave.getSamplingPeriod() - wave.getStartTime();
            b = String.format("%8.2f", dataLen).getBytes();
            System.arraycopy(b, 0, header, chanIdx % 3 * 26 + 18, 8);
        }
        this.writeRecord(fos, header);
        Arrays.fill(header, (byte)32);
        for (int i = 3 + (this.channelCount + 2) / 3; i < 12; ++i) {
            this.writeRecord(fos, header);
        }
    }

    public void writeChannelHeader(FileOutputStream fos, String code) throws IOException {
        byte[] b;
        Wave wave = (Wave)this.waves.get(code);
        byte[] header = new byte[1040];
        Arrays.fill(header, (byte)32);
        String[] comps = code.split("_");
        if (comps.length > 0) {
            b = comps[0].getBytes();
            System.arraycopy(b, 0, header, 0, Math.min(b.length, 5));
        }
        if (comps.length > 1) {
            b = comps[1].getBytes();
            System.arraycopy(b, 0, header, 5, Math.min(b.length, 2));
            if (b.length > 2) {
                System.arraycopy(b, 2, header, 8, 1);
            }
        }
        if (comps.length > 2) {
            b = comps[2].getBytes();
            System.arraycopy(b, 0, header, 16, 1);
            if (b.length > 1) {
                System.arraycopy(b, 1, header, 19, 1);
            }
        }
        if (comps.length > 3) {
            b = comps[3].getBytes();
            System.arraycopy(b, 0, header, 7, 1);
            if (b.length > 1) {
                System.arraycopy(b, 1, header, 12, 1);
            }
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date da = Util.j2KToDate(wave.getStartTime());
        c.setTime(da);
        b = String.format("%3d", c.get(1) - 1900).getBytes();
        System.arraycopy(b, 0, header, 9, Math.min(b.length, 3));
        b = String.format("%3d", c.get(6)).getBytes();
        System.arraycopy(b, 0, header, 13, Math.min(b.length, 3));
        b = String.format("%2d", c.get(2) + 1).getBytes();
        System.arraycopy(b, 0, header, 17, Math.min(b.length, 2));
        b = String.format("%2d", c.get(5)).getBytes();
        System.arraycopy(b, 0, header, 20, Math.min(b.length, 2));
        b = String.format("%2d", c.get(11)).getBytes();
        System.arraycopy(b, 0, header, 23, Math.min(b.length, 2));
        b = String.format("%2d", c.get(12)).getBytes();
        System.arraycopy(b, 0, header, 26, Math.min(b.length, 2));
        float f = c.get(13) + c.get(14) / 1000;
        b = String.format("%6.3f", Float.valueOf(f)).getBytes();
        System.arraycopy(b, 0, header, 29, b.length);
        b = String.format("%7.3f", wave.getSamplingRate()).getBytes();
        System.arraycopy(b, 0, header, 36, b.length);
        b = String.format("%7d", wave.numSamples()).getBytes();
        System.arraycopy(b, 0, header, 43, b.length);
        header[76] = 52;
        this.writeRecord(fos, header);
    }

    private byte[] readRecord(BufferedInputStream bis) throws IOException {
        int recordLen = this.readInt(bis, this.machineIntLength);
        byte[] record = new byte[recordLen];
        int read = bis.read(record);
        if (read != this.readInt(bis, this.machineIntLength)) {
            throw new IOException("Corrupt seisan record. Read " + read + ", expected " + recordLen);
        }
        return record;
    }

    private void writeRecord(FileOutputStream fos, byte[] bytes) throws IOException {
        int recordLen = bytes.length;
        fos.write(this.intAsBytes(recordLen));
        fos.write(bytes);
        fos.write(this.intAsBytes(recordLen));
    }

    private byte[] intAsBytes(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    private int readInt(BufferedInputStream bis, int len) throws IOException {
        byte[] buf = new byte[len];
        int read = bis.read(buf);
        if (read != len) {
            throw new IOException("Bad int read.");
        }
        return this.decodeInt(buf);
    }

    private int decodeInt(byte[] b) {
        ByteBuffer buffer = ByteBuffer.wrap(b);
        buffer.order(this.byteOrder);
        return b.length == 8 ? (int)buffer.getLong() : buffer.getInt();
    }
}

