/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.render.PointRenderer;
import gov.usgs.plot.transform.IdentityTransformer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;

public class TextRenderer
extends PointRenderer {
    public static final Font DEFAULT_FONT = Font.decode("dialog-PLAIN-11");
    public static final Font SMALL_FONT = Font.decode("dialog-PLAIN-7");
    public static final int NONE = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public Color color;
    public String text;
    public Font font = DEFAULT_FONT;
    public float orientation = 0.0f;
    public int vertJustification = 0;
    public int horizJustification = 0;
    public boolean antiAlias = true;
    public int xBump;
    public int yBump;
    public Color backgroundColor;
    public int backgroundWidth = -1;
    public int backgroundHeight = -1;

    public TextRenderer() {
    }

    public TextRenderer(double xx, double yy, String t) {
        this();
        this.x = xx;
        this.y = yy;
        this.text = t;
    }

    public TextRenderer(double xx, double yy, String t, Color c) {
        this(xx, yy, t);
        this.color = c;
    }

    public TextRenderer(double xx, double yy, String t, Color c, Font f) {
        this(xx, yy, t, c);
        this.font = f;
    }

    public Point getPixelLocation(Graphics2D g) {
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        double ax = this.transformer.getXPixel(this.x);
        double ay = this.transformer.getYPixel(this.y);
        switch (this.horizJustification) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                ax -= (double)(fm.stringWidth(this.text) / 2);
                break;
            }
            case 3: {
                ax -= (double)fm.stringWidth(this.text);
            }
        }
        switch (this.vertJustification) {
            case 0: {
                break;
            }
            case 5: {
                ay -= 2.0;
                break;
            }
            case 4: {
                ay += (double)fm.getHeight();
                break;
            }
            case 1: {
                ay += (double)(fm.getHeight() / 4);
            }
        }
        return new Point(this.xBump + (int)Math.round(ax + (double)(fm.stringWidth(this.text) / 2)), this.yBump + (int)Math.round(ay - (double)(fm.getHeight() / 2)));
    }

    public Rectangle getBoundingBox(Graphics2D g) {
        Font origFont = g.getFont();
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        Point loc = this.getPixelLocation(g);
        Rectangle rect = new Rectangle(loc.x - fm.stringWidth(this.text) / 2 - 2, loc.y - fm.getHeight() / 2 + 2, fm.stringWidth(this.text) + 2, fm.getHeight());
        g.setFont(origFont);
        return rect;
    }

    @Override
    public void render(Graphics2D g) {
        Font origFont = g.getFont();
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Object origRenderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        if (this.text != null) {
            Point loc = this.getPixelLocation(g);
            if (this.backgroundColor != null) {
                g.setColor(this.backgroundColor);
                Rectangle r = this.getBoundingBox(g);
                if (this.backgroundWidth != -1) {
                    r.width = this.backgroundWidth;
                }
                if (this.backgroundHeight != -1) {
                    r.height = this.backgroundHeight;
                }
                Rectangle fr = new Rectangle(r);
                ++fr.x;
                ++fr.y;
                --fr.width;
                --fr.height;
                g.fill(fr);
                g.setColor(Color.BLACK);
                g.draw(r);
            }
            g.translate(loc.x, loc.y);
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int height = fm.getHeight();
            int width = fm.stringWidth(this.text);
            g.rotate(Math.toRadians(this.orientation));
            g.setColor(this.color);
            int caret = this.text.indexOf("^");
            if (caret != -1) {
                this.text = this.text.replace("^", "");
                AttributedString as1 = new AttributedString(this.text);
                int endindex = this.text.length();
                int closesuper = this.text.indexOf(" ", caret);
                if (closesuper != -1) {
                    this.text = this.text.substring(0, closesuper) + this.text.substring(closesuper + 1);
                    endindex = closesuper;
                }
                as1.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, caret, endindex);
                g.drawString(as1.getIterator(), -width / 2, height / 2);
            } else {
                g.drawString(this.text, -width / 2, height / 2);
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origRenderingHint);
        g.setColor(origColor);
        g.setFont(origFont);
        g.setTransform(origAT);
    }
}

