/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render.wave;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.math.Spectra;
import gov.usgs.math.Util;
import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.decorate.DefaultFrameDecorator;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.render.MatrixRenderer;
import java.awt.Color;

public class SpectraRenderer
extends MatrixRenderer {
    private SliceWave wave;
    private double minFreq;
    private double maxFreq;
    private String channelTitle;
    private boolean logFreq;
    private boolean logPower;
    private boolean autoScale;
    public boolean xTickMarks = true;
    public boolean xTickValues = true;
    public boolean xUnits = true;
    public boolean xLabel = true;
    public boolean yTickMarks = true;
    public boolean yTickValues = true;
    private String yLabelText = null;
    private String yUnitText = null;
    private Color color = null;
    protected String timeZone;
    protected FrameDecorator decorator;

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setWave(SliceWave sw) {
        this.wave = sw;
    }

    public void setTitle(String t) {
        this.channelTitle = t.split("\\.")[0];
    }

    public void update() {
        if (this.decorator == null) {
            this.decorator = new DefaultSpectraFrameDecorator();
        }
        this.decorator.update();
        int nfft = (int)Util.getPreviousPowerOf2(this.wave.samples());
        Spectra spectra = new Spectra(this.wave.getSignal(), this.wave.getSamplingRate(), nfft);
        DoubleMatrix2D dm = DoubleFactory2D.dense.make(spectra.getMatrix(this.logPower, this.logFreq));
        this.setData(dm);
        this.setVisible(0, false);
        double minf = Math.max(this.minFreq, this.wave.getSamplingRate() / (double)nfft);
        double maxf = Math.min(this.maxFreq, this.wave.getNyquist());
        double X1 = this.logFreq ? Math.log10(minf) : minf;
        double X2 = this.logFreq ? Math.log10(maxf) : maxf;
        double Y1 = this.logPower ? Math.log10(spectra.getMinPower(minf, maxf)) : spectra.getMinPower(minf, maxf);
        double Y2 = this.logPower ? Math.log10(spectra.getMaxPower(minf, maxf)) : spectra.getMaxPower(minf, maxf);
        this.setExtents(X1, X2, Y1, Y2);
        this.createDefaultLineRenderers(this.color);
        this.decorator.decorate(this);
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isLogFreq() {
        return this.logFreq;
    }

    public void setLogFreq(boolean logFreq) {
        this.logFreq = logFreq;
    }

    public boolean isLogPower() {
        return this.logPower;
    }

    public void setLogPower(boolean logPower) {
        this.logPower = logPower;
    }

    public double getMaxFreq() {
        return this.maxFreq;
    }

    public void setMaxFreq(double maxFreq) {
        this.maxFreq = maxFreq;
    }

    public double getMinFreq() {
        return this.minFreq;
    }

    public void setMinFreq(double minFreq) {
        this.minFreq = minFreq;
    }

    public void setYLabelText(String s) {
        this.yLabelText = s;
    }

    public void setYUnitText(String s) {
        this.yUnitText = s;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected class DefaultSpectraFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultSpectraFrameDecorator() {
            if (SpectraRenderer.this.yUnitText != null) {
                this.yUnit = SpectraRenderer.this.yUnitText;
            }
            if (SpectraRenderer.this.yLabelText != null) {
                this.yAxisLabel = SpectraRenderer.this.yLabelText;
            }
            if (SpectraRenderer.this.xUnits) {
                this.xUnit = "Frequency (Hz)";
            }
            this.xAxisLabels = SpectraRenderer.this.xTickValues;
            this.yAxisLabels = SpectraRenderer.this.yTickValues;
            if (!SpectraRenderer.this.xTickMarks) {
                this.hTicks = 0;
                this.xAxisGrid = DefaultFrameDecorator.Grid.NONE;
            }
            if (!SpectraRenderer.this.yTickMarks) {
                this.vTicks = 0;
                this.yAxisGrid = DefaultFrameDecorator.Grid.NONE;
            }
            this.title = SpectraRenderer.this.channelTitle;
            this.titleBackground = Color.WHITE;
        }

        @Override
        public void update() {
            this.xAxis = SpectraRenderer.this.logFreq ? DefaultFrameDecorator.XAxis.LOG : DefaultFrameDecorator.XAxis.LINEAR;
            this.yAxis = SpectraRenderer.this.logPower ? DefaultFrameDecorator.YAxis.LOG : DefaultFrameDecorator.YAxis.LINEAR;
        }
    }
}

