/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render.wave;

import gov.usgs.plot.color.Jet2;
import gov.usgs.plot.color.Spectrum;
import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Spectrogram;
import gov.usgs.plot.decorate.DefaultFrameDecorator;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.ImageDataRenderer;
import gov.usgs.util.Util;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class SpectrogramRenderer
extends ImageDataRenderer {
    protected int hTicks = -1;
    protected int vTicks = -1;
    protected int nfft = 0;
    protected int binSize = 256;
    protected boolean logPower = false;
    protected boolean autoScale = false;
    protected double minFreq = 0.0;
    protected double maxFreq = 20.0;
    protected double minPower;
    protected double maxPower = -1.7976931348623157E308;
    protected double overlap = 0.859375;
    protected double viewStartTime;
    protected double viewEndTime;
    public boolean xTickMarks = true;
    public boolean xTickValues = true;
    public boolean xUnits = true;
    public boolean xLabel = false;
    public boolean yTickMarks = true;
    public boolean yTickValues = true;
    protected String timeZone;
    protected String dateFormatString = "yyyy-MM-dd HH:mm:ss";
    private String yLabelText = null;
    private String yUnitText = null;
    protected byte[] imgBuffer;
    protected Spectrum spectrum;
    protected AxisRenderer axis = new AxisRenderer(this);
    protected MemoryImageSource mis;
    protected Image im;
    private Spectrogram spectrogram;
    protected SliceWave wave;
    protected FrameDecorator decorator;
    protected String channelTitle;
    private double[][] powerBuffer;

    public SpectrogramRenderer() {
        this.spectrum = Jet2.getInstance();
    }

    public SpectrogramRenderer(SliceWave w) {
        this();
        this.wave = w;
    }

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void createDefaultFrameDecorator() {
        this.decorator = new DefaultWaveFrameDecorator();
    }

    public void setTitle(String t) {
        this.channelTitle = t.split("\\.")[0];
    }

    public double[] update() {
        if (this.decorator == null) {
            this.createDefaultFrameDecorator();
        }
        this.wave.setSlice(this.viewStartTime, this.viewEndTime);
        double[] signal = this.wave.getSignal();
        if (this.nfft == 0) {
            this.nfft = this.binSize;
        }
        this.spectrogram = new Spectrogram(signal, (int)this.wave.getSamplingRate(), this.nfft, this.binSize, (int)((double)this.binSize * this.overlap), 5.0);
        this.powerBuffer = this.logPower ? this.spectrogram.getLogSpectraAmplitude() : this.spectrogram.getSpectraAmplitude();
        int imgXSize = this.powerBuffer.length;
        int imgYSize = this.powerBuffer[0].length;
        this.imgBuffer = new byte[imgXSize * imgYSize];
        if (this.autoScale) {
            this.maxPower = Double.MIN_VALUE;
            this.minPower = Double.MAX_VALUE;
            for (int i = 0; i < imgXSize; ++i) {
                for (int j = 0; j < imgYSize; ++j) {
                    double power = this.powerBuffer[i][j];
                    if (power == Double.NEGATIVE_INFINITY || power == Double.POSITIVE_INFINITY || power == 1.0E300 | power == -1.0E300) continue;
                    if (power > this.maxPower) {
                        this.maxPower = power;
                        continue;
                    }
                    if (!(power < this.minPower)) continue;
                    this.minPower = power;
                }
            }
        }
        double slope = 254.0 / (this.maxPower - this.minPower);
        double intercept = -slope * this.minPower;
        int counter = 0;
        for (int i = imgXSize - 1; i >= 0; --i) {
            for (int j = 0; j < imgYSize; ++j) {
                double index = slope * this.powerBuffer[i][j] + intercept;
                if (index < 0.0) {
                    index = 0.0;
                } else if (index > 254.0) {
                    index = 254.0;
                }
                this.imgBuffer[counter++] = (byte)index;
            }
        }
        if (this.mis == null || this.im != null && (this.im.getWidth(null) != imgXSize || this.im.getHeight(null) != imgYSize)) {
            this.mis = new MemoryImageSource(imgYSize, imgXSize, (ColorModel)this.spectrum.palette, this.imgBuffer, 0, imgYSize);
        }
        this.im = Toolkit.getDefaultToolkit().createImage(this.mis);
        this.setImage(this.im);
        this.setDataExtents(this.wave.getStartTime(), this.wave.getEndTime(), 0.0, this.wave.getNyquist());
        this.setExtents(this.viewStartTime, this.viewEndTime, Math.max(this.minFreq, this.wave.getNyquist() / (double)(imgXSize - 1)), this.maxFreq);
        this.decorator.decorate(this);
        double[] Power = new double[]{this.minPower, this.maxPower};
        return Power;
    }

    public double[][] getPowerBuffer() {
        return this.powerBuffer;
    }

    public Spectrogram getSpectrogram() {
        return this.spectrogram;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public void setNfft(int nfft) {
        this.nfft = nfft;
    }

    public void setBinSize(int binSize) {
        this.binSize = binSize;
    }

    public void setLogPower(boolean logPower) {
        this.logPower = logPower;
    }

    public void setMaxFreq(double maxFreq) {
        this.maxFreq = maxFreq;
    }

    public void setMaxPower(double maxPower) {
        this.maxPower = maxPower;
    }

    public void setMinPower(double minPower) {
        this.minPower = minPower;
    }

    public void setMinFreq(double minFreq) {
        this.minFreq = minFreq;
    }

    public void setOverlap(double overlap) {
        this.overlap = overlap;
    }

    public void setViewEndTime(double viewEndTime) {
        this.viewEndTime = viewEndTime;
    }

    public void setViewStartTime(double viewStartTime) {
        this.viewStartTime = viewStartTime;
    }

    public void setViewTimes() {
        this.viewStartTime = this.wave.getStartTime();
        this.viewEndTime = this.wave.getEndTime();
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setYLabelText(String s) {
        this.yLabelText = s;
    }

    public void setYUnitText(String s) {
        this.yUnitText = s;
    }

    public void setWave(SliceWave wave) {
        this.wave = wave;
    }

    public void setHTicks(int ticks) {
        this.hTicks = ticks;
    }

    public void setVTicks(int ticks) {
        this.vTicks = ticks;
    }

    protected class DefaultWaveFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultWaveFrameDecorator() {
            if (SpectrogramRenderer.this.yUnitText != null) {
                this.yUnit = SpectrogramRenderer.this.yUnitText;
            }
            if (SpectrogramRenderer.this.yLabelText != null) {
                this.yAxisLabel = SpectrogramRenderer.this.yLabelText;
            }
            if (SpectrogramRenderer.this.xUnits) {
                this.xUnit = SpectrogramRenderer.this.timeZone + " Time (" + Util.j2KToDateString(SpectrogramRenderer.this.viewStartTime, SpectrogramRenderer.this.dateFormatString) + " to " + Util.j2KToDateString(SpectrogramRenderer.this.viewEndTime, SpectrogramRenderer.this.dateFormatString) + ")";
            }
            this.xAxisLabels = SpectrogramRenderer.this.xTickValues;
            this.yAxisLabels = SpectrogramRenderer.this.yTickValues;
            if (!SpectrogramRenderer.this.xTickMarks) {
                this.vTicks = 0;
            }
            if (!SpectrogramRenderer.this.yTickMarks) {
                this.hTicks = 0;
            }
            this.title = SpectrogramRenderer.this.channelTitle;
            this.titleBackground = Color.white;
        }
    }
}

