/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.Log;
import java.util.logging.Logger;

public class CodeTimer {
    private String name;
    private long startTime;
    private long endTime;
    private long runTime;
    private long lastMark;
    private long totalTime;
    private Logger logger = Log.getLogger("gov.usgs.util.CodeTimer");

    public CodeTimer() {
        this("unnamed");
    }

    public CodeTimer(String n) {
        this(n, true);
    }

    public CodeTimer(String n, boolean start) {
        this.name = n;
        this.startTime = -1L;
        this.endTime = -1L;
        this.runTime = -1L;
        this.totalTime = 0L;
        if (start) {
            this.start();
        }
    }

    public void start() {
        this.startTime = this.lastMark = System.nanoTime();
    }

    public void mark(String msg) {
        long now = System.nanoTime();
        String l = String.format("CodeTimer(%s/%s): %.3f\n", this.name, msg, (double)(now - this.lastMark) / 1000000.0);
        this.logger.finest(l);
        this.lastMark = now;
    }

    public void stop() {
        this.endTime = System.nanoTime();
        this.runTime = this.endTime - this.startTime;
        this.endTime = -1L;
        this.startTime = -1L;
        this.totalTime += this.runTime;
    }

    public void stopAndReport() {
        this.stop();
        this.logger.finest(this.toString());
    }

    public long getRunTime() {
        return this.runTime;
    }

    public double getRunTimeMillis() {
        return (double)this.runTime / 1000000.0;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public double getTotalTimeMillis() {
        return (double)this.totalTime / 1000000.0;
    }

    public String toString() {
        if (this.startTime == -1L && this.endTime == -1L) {
            if (this.runTime == -1L) {
                return "CodeTimer(" + this.name + "): no info";
            }
            return String.format("CodeTimer(%s): %.3f", this.name, this.getRunTimeMillis());
        }
        if (this.startTime != -1L && this.endTime == -1L) {
            return "CodeTimer(" + this.name + "): running";
        }
        return "CodeTimer(" + this.name + "): no info";
    }
}

