/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.configfile;

import gov.usgs.volcanoes.core.configfile.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFile.class);
    private boolean successfullyRead = false;
    private final Map<String, List<String>> config;
    private String name;

    public static String findConfig(List<String> fileNames) {
        String fileName = null;
        Iterator<String> nameIter = fileNames.iterator();
        while (fileName == null && nameIter.hasNext()) {
            String name = nameIter.next();
            if (!new File(name).canRead()) continue;
            fileName = name;
        }
        return fileName;
    }

    public ConfigFile() {
        this.config = new HashMap<String, List<String>>();
    }

    public ConfigFile(Map<String, List<String>> map) {
        this.config = map;
    }

    public ConfigFile(String fn) {
        this.setName(fn);
        this.config = new HashMap<String, List<String>>();
        try {
            this.readConfigFile(fn);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("Cannot read config file. ({})", ex);
        }
    }

    public ConfigFile deepCopy() {
        ConfigFile copy = new ConfigFile();
        for (Map.Entry<String, List<String>> entry : this.config.entrySet()) {
            List<String> value = entry.getValue();
            String key = entry.getKey();
            if (value == null) continue;
            ArrayList<String> newList = new ArrayList<String>(value);
            copy.putList(key, newList);
        }
        return copy;
    }

    public boolean wasSuccessfullyRead() {
        return this.successfullyRead;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal " + key + ":null");
        }
        if (!value.toLowerCase().equals("true") && value.toLowerCase().equals("t") && !value.toLowerCase().equals("false") && value.toLowerCase().equals("f") && !value.equals("1") && !value.equals("0")) {
            throw new RuntimeException("Illegal " + key + ":" + value);
        }
        boolean pv = false;
        if (value.toLowerCase().equals("true") || value.equals("1") || value.toLowerCase().equals("t")) {
            pv = true;
        }
        return pv;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value;
        try {
            value = this.getBoolean(key);
        }
        catch (RuntimeException e) {
            this.put(key, String.valueOf(defaultValue));
            value = defaultValue;
        }
        return value;
    }

    public Map<String, List<String>> getConfig() {
        return this.config;
    }

    public double getDouble(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal " + key + ":null");
        }
        double d = Double.parseDouble(value);
        return d;
    }

    public double getDouble(String key, double defaultValue) {
        double value;
        try {
            value = this.getDouble(key);
        }
        catch (Exception e) {
            this.put(key, String.valueOf(defaultValue));
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = this.getString(key);
        if (value == null) {
            throw new RuntimeException("Illegal parameter " + key + " = null");
        }
        int i = Integer.parseInt(value);
        return i;
    }

    public int getInt(String key, int defaultValue) {
        int value;
        try {
            value = this.getInt(key);
        }
        catch (Exception e) {
            this.put(key, String.valueOf(defaultValue));
            value = defaultValue;
        }
        return value;
    }

    public List<String> getList(String key) {
        return this.config.get(key);
    }

    public String getName() {
        return this.name;
    }

    public <T> T getObject(String key, Parser<T> parser) throws ParseException {
        return parser.parse(this.getString(key));
    }

    private List<String> getOrCreateList(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            ss = new ArrayList<String>();
            this.config.put(key, ss);
        }
        return ss;
    }

    public String getString(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null || ss.size() == 0) {
            return null;
        }
        return ss.get(0);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            this.put(key, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public ConfigFile getSubConfig(String prefix) {
        return this.getSubConfig(prefix, false);
    }

    public ConfigFile getSubConfig(String prefix, boolean inherit) {
        ConfigFile newConfig = inherit ? this.deepCopy() : new ConfigFile();
        newConfig.name = prefix;
        Map<String, List<String>> configMap = newConfig.getConfig();
        for (Map.Entry<String, List<String>> entry : this.config.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!key.startsWith(prefix) || key.length() <= prefix.length()) continue;
            String newKey = key.substring(prefix.length() + 1);
            ArrayList<String> newList = new ArrayList<String>(value);
            configMap.put(newKey, newList);
        }
        return newConfig;
    }

    public void put(String key, String val) {
        this.getOrCreateList(key).add(val);
    }

    public void put(String key, String val, boolean replace) {
        if (!replace) {
            this.remove(key);
        }
        this.put(key, val);
    }

    public void putConfig(ConfigFile cf, boolean preserve) {
        Map<String, List<String>> configIn = cf.getConfig();
        for (Map.Entry<String, List<String>> entry : configIn.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!preserve) {
                this.remove(key);
            }
            this.putList(key, value);
        }
    }

    public void putList(String key, List<String> list) {
        this.config.put(key, list);
    }

    public void readConfigFile(File file) throws FileNotFoundException {
        this.readConfigFile(file, true);
    }

    public void readConfigFile(File file, boolean replace) throws FileNotFoundException {
        try {
            String line;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith("#") && !line.startsWith("@")) {
                    String key = line.substring(0, line.indexOf(61)).trim();
                    String val = line.substring(line.indexOf(61) + 1).trim();
                    if (val.toLowerCase().equals("@begin-multiline")) {
                        StringBuffer sb = new StringBuffer(2048);
                        boolean done = false;
                        while (!done) {
                            String is = in.readLine();
                            if (is != null && is.toLowerCase().equals("@end-multiline")) {
                                done = true;
                                continue;
                            }
                            sb.append(is);
                            sb.append('\n');
                        }
                        val = sb.toString();
                    }
                    if (!replace) {
                        this.remove(key);
                    }
                    List<String> ss = this.getOrCreateList(key);
                    ss.add(val);
                }
                if (!line.toLowerCase().startsWith("@include ")) continue;
                String ifn = line.substring(line.indexOf(" ") + 1);
                ifn = file.getAbsoluteFile().getParent() + File.separator + ifn;
                this.readConfigFile(ifn);
            }
            this.successfullyRead = true;
            in.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readConfigFile(String fn) throws FileNotFoundException {
        this.readConfigFile(fn, true);
    }

    public void readConfigFile(String fn, boolean replace) throws FileNotFoundException {
        this.readConfigFile(new File(fn), replace);
    }

    public void remove(String key) {
        this.config.remove(key);
    }

    public void remove(String key, String val) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            return;
        }
        ss.remove(val);
        if (ss.size() == 0) {
            this.config.remove(key);
        }
    }

    public void setName(String name) {
        this.name = name.endsWith(".config") ? name.substring(0, name.indexOf(".config")) : name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.config.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (value.size() == 1) {
                sb.append(key + "=" + value.get(0) + "\n");
                continue;
            }
            sb.append(key + "=[list]\n");
            for (String s : value) {
                sb.append("\t" + s + "\n");
            }
        }
        return sb.toString();
    }

    public void writeToFile(String fn) {
        this.setName(fn);
        Set<String> keySet = this.config.keySet();
        Iterator<String> it = keySet.iterator();
        ArrayList<String> v = new ArrayList<String>();
        while (it.hasNext()) {
            v.add(it.next());
        }
        Object[] keys = new String[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)v.get(i);
        }
        Arrays.sort(keys);
        try {
            Path file = FileSystems.getDefault().getPath(".", fn);
            Path bak = FileSystems.getDefault().getPath(".", fn + ".bak");
            if (Files.exists(bak, new LinkOption[0])) {
                LOGGER.debug("Removing old backup cofig. ({})", (Object)bak);
                Files.delete(bak);
            }
            if (Files.exists(file, new LinkOption[0])) {
                LOGGER.debug("Making cofig backup. ({})", (Object)bak);
                Files.move(file, bak, StandardCopyOption.REPLACE_EXISTING);
            }
            LOGGER.debug("Writing cofig. ({})", (Object)fn);
            FileOutputStream outStream = new FileOutputStream(new File(fn));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8);
            PrintWriter out = new PrintWriter(writer);
            for (int i = 0; i < keys.length; ++i) {
                List<String> o;
                Object k = keys[i];
                List<String> vals = o = this.config.get(k);
                Iterator<String> it2 = vals.iterator();
                while (it2.hasNext()) {
                    out.println((String)k + "=" + it2.next());
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

