/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.time;

import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.core.contrib.NtpMessage;
import gov.usgs.volcanoes.core.time.Ew;
import gov.usgs.volcanoes.core.time.J2kSec;
import gov.usgs.volcanoes.core.time.Time;
import gov.usgs.volcanoes.core.util.Retriable;
import gov.usgs.volcanoes.core.util.StringUtils;
import gov.usgs.volcanoes.core.util.UtilException;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTime {
    private static final String CONFIG_FILENAME = "NTP.config";
    private static final SimpleDateFormat DATE_FORMAT;
    private static final String[] DEFAULT_NTP_SERVERS;
    private static final int DEFAULT_RECALIBRATION_INTERVAL = 600000;
    private static final int DEFAULT_TIMEOUT = 500;
    private static final Logger LOGGER;
    private long lastOffset;
    private boolean netFailed = false;
    private long recalibrationInterval = 600000L;
    private String[] servers = DEFAULT_NTP_SERVERS;
    private boolean synchronizeDisabled = false;
    private int timeout = 500;

    public static CurrentTime getInstance() {
        return CurrentTimeHolder.currentTime;
    }

    public static void main(String[] args) {
        long now = CurrentTime.getInstance().now();
        System.out.printf("        GMT Time\nMillis: %d\n   J2K: %f\n    EW: %f\n  Date: %s\nOffset: %d\n", now, J2kSec.fromEpoch(now), Ew.fromEpoch(now), Time.toDateString(now), CurrentTime.getInstance().getLastOffset());
    }

    private CurrentTime() {
        LinkedList<String> canaditeNames = new LinkedList<String>();
        canaditeNames.add(CONFIG_FILENAME);
        canaditeNames.add(System.getProperty("user.home") + File.separatorChar + CONFIG_FILENAME);
        String configFile = StringUtils.stringToString(ConfigFile.findConfig(canaditeNames), CONFIG_FILENAME);
        ConfigFile cf = new ConfigFile(configFile);
        if (cf.wasSuccessfullyRead()) {
            String svrs = cf.getString("servers");
            if (svrs != null) {
                this.servers = svrs.split(",");
            }
            this.timeout = StringUtils.stringToInt(cf.getString("timeout"), 500);
            this.synchronizeDisabled = StringUtils.stringToBoolean(cf.getString("synchronizeDisabled"));
            this.recalibrationInterval = StringUtils.stringToInt(cf.getString("recalibrationInterval"), 600000);
        }
        new Thread(this.offsetUpdater()).start();
    }

    private Runnable offsetUpdater() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    CurrentTime.this.getOffset();
                    try {
                        Thread.sleep(CurrentTime.this.recalibrationInterval);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        LOGGER.debug("offsetUpdater interrupted, I'll recalibrate early.");
                        continue;
                    }
                    break;
                }
            }
        };
        return run;
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    public synchronized long getOffset() {
        if (this.synchronizeDisabled) {
            return 0L;
        }
        Retriable<Long> rt = new Retriable<Long>("getCurrentTime()", this.servers.length){
            private int attempt;
            {
                this.attempt = 0;
            }

            @Override
            public boolean attempt() throws UtilException {
                double localClockOffset = 0.0;
                DatagramSocket socket = null;
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(CurrentTime.this.timeout);
                    InetAddress address = InetAddress.getByName(CurrentTime.this.servers[this.attempt]);
                    byte[] buf = new NtpMessage().toByteArray();
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
                    NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
                    socket.send(packet);
                    packet = new DatagramPacket(buf, buf.length);
                    socket.receive(packet);
                    double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
                    NtpMessage msg = new NtpMessage(packet.getData());
                    localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
                    long l = Math.round(localClockOffset * 1000.0);
                    this.result = new Long(l);
                    CurrentTime.this.lastOffset = l;
                    LOGGER.debug("Successfully synchronized with NTP server: " + CurrentTime.this.servers[this.attempt]);
                    socket.close();
                    return true;
                }
                catch (Exception e) {
                    LOGGER.debug("Could not synchronize with NTP server: " + CurrentTime.this.servers[this.attempt]);
                    if (socket != null) {
                        socket.close();
                    }
                    return false;
                }
            }

            @Override
            public void attemptFix() {
                ++this.attempt;
            }
        };
        Long result = null;
        try {
            rt.setOutput(false);
            result = (Long)rt.go();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        if (result == null) {
            this.netFailed = true;
            return 0L;
        }
        return result;
    }

    public long now() {
        Long time = System.currentTimeMillis();
        if (!this.netFailed) {
            time = time + this.lastOffset;
        }
        return time;
    }

    public void setRecalibrationInterval(long ms) {
        this.recalibrationInterval = ms;
    }

    static {
        DEFAULT_NTP_SERVERS = new String[]{"0.pool.ntp.org", "1.pool.ntp.org", "time.nist.gov"};
        LOGGER = LoggerFactory.getLogger(CurrentTime.class);
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class CurrentTimeHolder {
        public static CurrentTime currentTime = new CurrentTime();

        private CurrentTimeHolder() {
        }
    }
}

