/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.time;

import gov.usgs.volcanoes.core.time.CurrentTime;
import gov.usgs.volcanoes.core.time.Time;
import java.text.ParseException;
import java.util.Date;

public class J2kSec {
    public static final double UNIXZERO = -9.46728E8;

    public static Date asDate(double j2k) {
        return new Date(J2kSec.asEpoch(j2k));
    }

    public static double fromDate(Date date) {
        return J2kSec.fromEpoch(date.getTime());
    }

    public static long asEpoch(double j2k) {
        return (long)((j2k - -9.46728E8) * 1000.0);
    }

    public static double fromEpoch(Long date) {
        return (double)date.longValue() / 1000.0 + -9.46728E8;
    }

    public static synchronized String format(String format, double j2k) {
        return Time.format(format, J2kSec.asDate(j2k));
    }

    public static String toDateString(double j2k) {
        return J2kSec.format("yyyy-MM-dd HH:mm:ss", j2k);
    }

    public static synchronized double parse(String format, String date) throws ParseException {
        return J2kSec.fromDate(Time.getFormat(format).parse(date));
    }

    public static double now() {
        return J2kSec.fromEpoch(CurrentTime.getInstance().now());
    }

    private J2kSec() {
    }
}

