/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.time;

import gov.usgs.volcanoes.core.time.Ew;
import gov.usgs.volcanoes.core.time.J2kSec;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public final class Time {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static DecimalFormat diffFormat;
    public static final String FDSN_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSS";
    private static Map<String, SimpleDateFormat> formats;
    public static final String INPUT_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final String STANDARD_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String STANDARD_TIME_FORMAT_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final double YEAR_IN_S = 3.15576E7;

    public static double ewToj2k(double ew) {
        return J2kSec.fromEpoch(Ew.asEpoch(ew));
    }

    public static synchronized String format(String format, Date date) {
        return Time.format(format, date, DEFAULT_TIME_ZONE);
    }

    public static synchronized String format(String format, Date date, TimeZone tz) {
        SimpleDateFormat dateF = new SimpleDateFormat(format);
        dateF.setTimeZone(tz);
        return dateF.format(date);
    }

    public static synchronized String format(String format, long time) {
        return Time.format(format, new Date(time));
    }

    protected static SimpleDateFormat getFormat(String format) {
        SimpleDateFormat sdFormat = formats.get(format);
        if (sdFormat == null) {
            sdFormat = new SimpleDateFormat(format);
            sdFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            formats.put(format, sdFormat);
        }
        return sdFormat;
    }

    public static double getRelativeTime(String timeStr) {
        if (timeStr == null || timeStr.charAt(0) != '-') {
            return Double.NaN;
        }
        int number = Integer.MIN_VALUE;
        try {
            number = Integer.parseInt(timeStr.substring(1, timeStr.length() - 1));
        }
        catch (Exception e) {
            return Double.NaN;
        }
        char unit = timeStr.charAt(timeStr.length() - 1);
        double unitSize = 0.0;
        switch (unit) {
            case 's': {
                unitSize = 1.0;
                break;
            }
            case 'i': {
                unitSize = 60.0;
                break;
            }
            case 'h': {
                unitSize = 3600.0;
                break;
            }
            case 'd': {
                unitSize = 86400.0;
                break;
            }
            case 'w': {
                unitSize = 604800.0;
                break;
            }
            case 'm': {
                unitSize = 2592000.0;
                break;
            }
            case 'y': {
                unitSize = 3.1536E7;
                break;
            }
            default: {
                return Double.NaN;
            }
        }
        return (double)number * unitSize;
    }

    public static double j2kToEw(double j2k) {
        return Ew.fromEpoch(J2kSec.asEpoch(j2k));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("-j2d [j2k]        j2k to date");
            System.out.println("-j2e [j2k]              j2k to earthworm");
            System.out.println("-d2j [yyyymmddhhmmss] date to j2k");
            System.out.println("-e2d [ewtime]           earthworm to date");
            System.exit(1);
        }
        SimpleDateFormat df1 = new SimpleDateFormat(STANDARD_TIME_FORMAT_MS);
        SimpleDateFormat df2 = new SimpleDateFormat(INPUT_TIME_FORMAT);
        df1.setTimeZone(TimeZone.getTimeZone("GMT"));
        df2.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (args[0].equals("-j2d")) {
            System.out.println(df1.format(J2kSec.asDate(Double.parseDouble(args[1]))));
        } else if (args[0].equals("-j2e")) {
            System.out.println(Time.j2kToEw(Double.parseDouble(args[1])));
        } else if (args[0].equals("-d2j")) {
            System.out.println(J2kSec.fromDate(df2.parse(args[1])));
        } else if (args[0].equals("-e2d")) {
            System.out.println(df1.format(Ew.asDate(Double.parseDouble(args[1]))));
        }
    }

    public static synchronized double[] parseTimeRange(String timeRange) throws ParseException {
        if (timeRange == null || timeRange.equals("")) {
            throw new ParseException("Time range is null.", -1);
        }
        double[] result = new double[2];
        String[] ss = timeRange.split(",");
        result[1] = J2kSec.now();
        result[0] = 0.0;
        if (ss.length == 2) {
            if (ss[1].charAt(0) == '-') {
                double rt = Time.getRelativeTime(ss[1]);
                if (Double.isNaN(rt)) {
                    throw new ParseException("Unparsable relative end time.", -1);
                }
                result[1] = result[1] - rt;
            } else {
                result[1] = J2kSec.fromDate(Time.getFormat(INPUT_TIME_FORMAT).parse(ss[1]));
            }
        }
        if (ss[0].charAt(0) == '-') {
            result[0] = Time.getRelativeTime(ss[0]);
            if (Double.isNaN(result[0])) {
                throw new ParseException("Unparsable relative start time.", -1);
            }
            result[0] = result[1] - result[0];
        } else {
            result[0] = J2kSec.fromDate(Time.getFormat(INPUT_TIME_FORMAT).parse(ss[0]));
        }
        return result;
    }

    public static String secondsToString(double diff) {
        String diffString = "";
        if (diff < 60.0) {
            diffString = diffFormat.format(diff) + "s";
        } else if (diff < 3600.0) {
            diffString = (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        } else if (diff < 86400.0) {
            diffString = (int)(diff / 3600.0) + "h ";
            diff -= (double)(3600 * (int)(diff / 3600.0));
            diffString = diffString + (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        } else {
            diffString = (int)(diff / 86400.0) + "d ";
            diff -= (double)(86400 * (int)(diff / 86400.0));
            diffString = diffString + (int)(diff / 3600.0) + "h ";
            diff -= (double)(3600 * (int)(diff / 3600.0));
            diffString = diffString + (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        }
        return diffString;
    }

    public static String toDateString(Date date) {
        return Time.format(STANDARD_TIME_FORMAT, date);
    }

    public static String toDateString(long time) {
        return Time.format(STANDARD_TIME_FORMAT, time);
    }

    public static String toShortString(Date date) {
        return Time.format(INPUT_TIME_FORMAT, date);
    }

    private Time() {
    }

    static {
        formats = new HashMap<String, SimpleDateFormat>();
        diffFormat = new DecimalFormat("#.##");
    }
}

