/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.util;

import gov.usgs.volcanoes.core.util.UtilException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Retriable<T> {
    public static int defaultMaxAttempts = 3;
    public static boolean defaultOutput = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(Retriable.class);
    protected int maxAttempts = defaultMaxAttempts;
    protected String name = "";
    protected boolean output = defaultOutput;
    protected T result;

    public Retriable() {
    }

    public Retriable(int mr) {
        this();
        this.maxAttempts = mr;
    }

    public Retriable(String name, int mr) {
        this(mr);
        this.name = name;
        this.maxAttempts = mr;
    }

    public abstract boolean attempt() throws UtilException;

    public void attemptFix() {
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public String getName() {
        return this.name;
    }

    public T getResult() {
        return this.result;
    }

    public void giveUp() {
    }

    public T go() throws UtilException {
        int attempts = 0;
        boolean success = false;
        while (!success && attempts < this.getMaxAttempts()) {
            ++attempts;
            success = this.attempt();
            if (success) continue;
            if (this.isOutput()) {
                LOGGER.error("{}: failed on attempt {}", (Object)this.getName(), (Object)attempts);
            }
            this.attemptFix();
        }
        if (!success) {
            LOGGER.error("{}: giving up.", (Object)this.getName());
            this.giveUp();
        }
        return this.getResult();
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }
}

