/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.core.util;

import java.util.Comparator;

public final class StringUtils {
    public static final char DEGREE_SYMBOL = '\u00b0';
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;

    public static Comparator<String> getCaseInsensitiveStringComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    public static String numBytesToString(long bytes) {
        if (bytes <= 4096L) {
            return String.format("%d B", bytes);
        }
        if (bytes <= 0x400000L) {
            return String.format("%.3f KB", (double)bytes / 1024.0);
        }
        if (bytes <= 0x100000000L) {
            return String.format("%.3f MB", (double)bytes / 1048576.0);
        }
        if (bytes <= 0x40000000000L) {
            return String.format("%.3f GB", (double)bytes / 1.073741824E9);
        }
        if (bytes <= 0x10000000000000L) {
            return String.format("%.3f TB", (double)bytes / 1.099511627776E12);
        }
        return String.format("%.3f PB", (double)bytes / 1.125899906842624E15);
    }

    public static boolean stringToBoolean(String val) {
        if (val == null) {
            return false;
        }
        return val.toLowerCase().equals("true") || val.equals("1") || val.toLowerCase().equals("t");
    }

    public static boolean stringToBoolean(String val, boolean def) {
        if (val == null) {
            return def;
        }
        return val.toLowerCase().equals("true") || val.equals("1") || val.toLowerCase().equals("t");
    }

    public static double stringToDouble(String val, double def) {
        double ret;
        try {
            ret = Double.parseDouble(val);
        }
        catch (Exception e) {
            ret = def;
        }
        return ret;
    }

    public static int stringToInt(String val, int def) {
        int ret;
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            ret = def;
        }
        return ret;
    }

    public static String stringToString(String val, String def) {
        return val == null ? def : val;
    }

    private StringUtils() {
    }
}

