/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.pensive.PensiveArgs;
import gov.usgs.volcanoes.pensive.PensiveWebApp;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import gov.usgs.volcanoes.pensive.schedule.AbstractPlotScheduler;
import gov.usgs.volcanoes.pensive.schedule.BackfillPlotScheduler;
import gov.usgs.volcanoes.pensive.schedule.RealtimePlotScheduler;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pensive {
    private static final boolean DEFAULT_WRITE_HTML = true;
    private static final Logger LOGGER;
    private ConfigFile configFile;
    private PensiveWebApp webApp;
    private Map<String, AbstractPlotScheduler> plotScheduler;

    public Pensive(ConfigFile configFile) {
        this.configFile = configFile;
        long now = System.currentTimeMillis();
        configFile.put("applicationLaunch", "" + now);
        LOGGER.info("Launching Pensive ({})", (Object)"Version: 1.3.6 Built: 2016-05-11T22:35:10Z");
        this.webApp = new PensiveWebApp(configFile);
        boolean writeHtml = configFile.getBoolean("writeHtml", true);
        if (writeHtml) {
            this.webApp.writeHtml();
        }
    }

    public Pensive(ConfigFile configFile, Date startTime, Date endTime) {
    }

    private void createRealtimePlotSchedulers() {
        this.plotScheduler = new HashMap<String, AbstractPlotScheduler>();
        for (String server : this.configFile.getList("waveSource")) {
            ConfigFile c = this.configFile.getSubConfig(server, true);
            LOGGER.info("Creating plot scheduler for " + server);
            this.plotScheduler.put(server, new RealtimePlotScheduler(server, c));
        }
        this.assignSubnets();
        this.pruneSchedulers();
        this.schedulePlots();
        this.startWaveSources();
    }

    private void createBackfillPlotSchedulers(long startTime, long endTime) {
        this.plotScheduler = new HashMap<String, AbstractPlotScheduler>();
        for (String server : this.configFile.getList("waveSource")) {
            ConfigFile c = this.configFile.getSubConfig(server, true);
            LOGGER.info("Creating plot scheduler for " + server);
            BackfillPlotScheduler ps = new BackfillPlotScheduler(server, c);
            ps.setRange(startTime, endTime);
            this.plotScheduler.put(server, ps);
        }
        this.assignSubnets();
        this.pruneSchedulers();
        this.schedulePlots();
        this.startWaveSources();
    }

    private void startWaveSources() {
        for (AbstractPlotScheduler ps : this.plotScheduler.values()) {
            ps.startWaveSources();
        }
    }

    private void assignSubnets() {
        List<String> networks = this.configFile.getList("network");
        if (networks == null) {
            throw new RuntimeException("No network directives found.");
        }
        Iterator<String> networkIt = networks.iterator();
        while (networkIt.hasNext()) {
            String network = networkIt.next();
            ConfigFile netConfig = this.configFile.getSubConfig(network, true);
            List<String> subnets = netConfig.getList("subnet");
            if (subnets == null) {
                LOGGER.info("No subnet directives for network " + network + " found. Skipping.");
                networkIt.remove();
                continue;
            }
            Iterator<String> subnetIt = subnets.iterator();
            while (subnetIt.hasNext()) {
                String subnet = subnetIt.next();
                ConfigFile subnetConfig = netConfig.getSubConfig(subnet, true);
                if (subnetConfig.getList("channel") == null) {
                    LOGGER.warn("No channel directives for subnet " + subnet + " found. Skipping.");
                    subnetIt.remove();
                    continue;
                }
                this.webApp.addSubnet(network, subnet);
                String dataSource = subnetConfig.getString("dataSource");
                if (dataSource != null) {
                    AbstractPlotScheduler scheduler = this.plotScheduler.get(dataSource);
                    LOGGER.info("Assigning subnet " + subnet + " to " + dataSource);
                    scheduler.add(new SubnetPlotter(network, subnet, subnetConfig));
                    continue;
                }
                LOGGER.error("Cannot find dataSource for subnet {}. I'll skip it this time.", (Object)subnet);
            }
            netConfig.putList("subnet", subnets);
        }
        this.configFile.putList("network", networks);
        Iterator<String> schedulerIt = this.plotScheduler.keySet().iterator();
        while (schedulerIt.hasNext()) {
            String server = schedulerIt.next();
            AbstractPlotScheduler ps = this.plotScheduler.get(server);
            if (ps.subnetCount() >= 1) continue;
            LOGGER.warn("No subnets feeding from " + ps.name + ". I'll prune it.");
            schedulerIt.remove();
        }
    }

    private void pruneSchedulers() {
        Iterator<String> schedulerIt = this.plotScheduler.keySet().iterator();
        while (schedulerIt.hasNext()) {
            String server = schedulerIt.next();
            AbstractPlotScheduler ps = this.plotScheduler.get(server);
            if (ps.subnetCount() >= 1) continue;
            LOGGER.warn("No subnets feeding from " + ps.name + ". I'll prune it.");
            schedulerIt.remove();
        }
    }

    private void schedulePlots() {
        for (AbstractPlotScheduler ps : this.plotScheduler.values()) {
            new Thread(ps).start();
            if (!(ps instanceof RealtimePlotScheduler)) continue;
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            int delay = 600;
            delay = (int)((long)delay - System.currentTimeMillis() / 1000L % 600L);
            LOGGER.debug("Scheduled plots start in " + delay + "ms");
            scheduler.scheduleAtFixedRate(ps, delay, 600L, TimeUnit.SECONDS);
        }
    }

    public void writeWebApp() {
        boolean writeHtml = this.configFile.getBoolean("writeHtml", true);
        if (writeHtml) {
            this.webApp.writeHtml();
        }
    }

    public void stop() {
        for (AbstractPlotScheduler ps : this.plotScheduler.values()) {
            ps.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        PensiveArgs config = new PensiveArgs(args);
        ConfigFile cf = null;
        cf = new ConfigFile(config.configFileName);
        if (!cf.wasSuccessfullyRead()) {
            LOGGER.error("Couldn't find config file " + config.configFileName + ". Use '-c' to create an example config.");
            System.exit(1);
        }
        Pensive pensive = new Pensive(cf);
        if (config.startTime < 0L) {
            pensive.createRealtimePlotSchedulers();
        } else {
            pensive.createBackfillPlotSchedulers(config.startTime, config.endTime);
            pensive.stop();
        }
        pensive.writeWebApp();
    }

    static {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        LOGGER = LoggerFactory.getLogger(Pensive.class);
    }
}

