/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import gov.usgs.volcanoes.core.args.Args;
import gov.usgs.volcanoes.core.args.Arguments;
import gov.usgs.volcanoes.core.args.decorator.ConfigFileArg;
import gov.usgs.volcanoes.core.args.decorator.CreateConfigArg;
import gov.usgs.volcanoes.core.args.decorator.DateRangeArg;
import gov.usgs.volcanoes.core.args.decorator.VerboseArg;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PensiveArgs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PensiveArgs.class);
    private static final String EXAMPLE_CONFIG_FILENAME = "pensive-example.config";
    private static final String DEFAULT_CONFIG_FILENAME = "pensive.config";
    private static final String PROGRAM_NAME = "java -jar gov.usgs.volcanoes.pensive.Pensive";
    private static final String EXPLANATION = "I am the Pensive server\n";
    public static final String INPUT_TIME_FORMAT = "yyyyMMddHHmm";
    private static final Parameter[] PARAMETERS = new Parameter[0];
    public final boolean verbose;
    public final long startTime;
    public final long endTime;
    public final String configFileName;

    public PensiveArgs(String[] commandLineArgs) throws Exception {
        Arguments args = null;
        args = new Args(PROGRAM_NAME, EXPLANATION, PARAMETERS);
        args = new ConfigFileArg(DEFAULT_CONFIG_FILENAME, args);
        args = new CreateConfigArg(EXAMPLE_CONFIG_FILENAME, args);
        args = new DateRangeArg(INPUT_TIME_FORMAT, args);
        args = new VerboseArg(args);
        JSAPResult jsapResult = null;
        jsapResult = args.parse(commandLineArgs);
        this.verbose = jsapResult.getBoolean("verbose");
        LOGGER.debug("Setting: verbose={}", (Object)this.verbose);
        Date startDate = jsapResult.getDate("startTime");
        this.startTime = startDate == null ? Long.MIN_VALUE : jsapResult.getDate("startTime").getTime();
        LOGGER.debug("Setting: startTime={}", (Object)this.startTime);
        Date endDate = jsapResult.getDate("endTime");
        this.endTime = endDate == null ? Long.MIN_VALUE : jsapResult.getDate("endTime").getTime();
        LOGGER.debug("Setting: endTime={}", (Object)this.endTime);
        this.configFileName = jsapResult.getString("config-filename");
        LOGGER.debug("Setting: config-filename={}", (Object)this.configFileName);
        if (jsapResult.getBoolean("create-config")) {
            System.exit(1);
        }
    }
}

