/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import gov.usgs.volcanoes.core.configfile.ConfigFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PensiveWebApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(PensiveWebApp.class);
    public static final String FILENAME = "index.html";
    private Map<String, Object> root;
    private Configuration cfg;
    private Map<String, List<String>> subnets;
    private final String pathRoot;

    public PensiveWebApp(ConfigFile config) {
        this.pathRoot = config.getString("pathRoot", "html");
        this.root = new HashMap<String, Object>();
        this.subnets = new HashMap<String, List<String>>();
        this.root.put("subnets", this.subnets);
        this.root.put("refreshPeriod", 600);
        this.root.put("filePathFormat", config.getString("filePathFormat", "yyyy/DDD"));
        this.root.put("fileSuffixFormat", config.getString("fileSuffixFormat", "_yyyyMMdd-HHmm"));
        this.root.put("selectedNetwork", config.getString("selectedNetwork"));
        this.root.put("version", "Version: 1.3.6 Built: 2016-05-11T22:35:10Z");
        try {
            this.initializeTemplateEngine();
        }
        catch (IOException e) {
            LOGGER.error("cannot write HTML");
        }
    }

    protected void initializeTemplateEngine() throws IOException {
        this.cfg = new Configuration();
        this.cfg.setTemplateLoader(new ClassTemplateLoader(this.getClass(), "/html"));
        DefaultObjectWrapper obj = new DefaultObjectWrapper();
        obj.setExposeFields(true);
        this.cfg.setObjectWrapper(obj);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        this.cfg.setIncompatibleImprovements(new Version(2, 3, 20));
    }

    public void writeHtml() {
        try {
            File rootDir = new File(this.pathRoot);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            Template template = this.cfg.getTemplate("pensive.ftl");
            String file = this.pathRoot + '/' + FILENAME;
            file = file.replace("/+", "/");
            file = file.replace("/", Matcher.quoteReplacement(File.separator));
            FileWriter fw = new FileWriter(file);
            template.process(this.root, fw);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }

    public void addSubnet(String network, String subnet) {
        List<String> subs = this.subnets.get(network);
        if (subs == null) {
            subs = new ArrayList<String>();
            this.subnets.put(network, subs);
        }
        subs.add(subnet);
    }
}

