/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.pensive.PlotJob;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import gov.usgs.volcanoes.swarm.data.DataSourceType;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveSource
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger("gov.usgs");
    public static final String DEFAULT_TYPE = "wws";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_TIMEOUT_S = 15;
    private boolean shouldRun = true;
    private final SeismicDataSource dataSource;
    private final BlockingQueue<PlotJob> plotJobs;
    public final String name;

    public WaveSource(String name, BlockingQueue<PlotJob> plotJobs, ConfigFile config) {
        this.plotJobs = plotJobs;
        this.name = name;
        String type = config.getString("type", DEFAULT_TYPE);
        String host = config.getString("host", DEFAULT_HOST);
        int port = config.getInt("port", 16022);
        int timeout = config.getInt("timeout", 15);
        boolean compress = true;
        String dsString = null;
        if (type.equals(DEFAULT_TYPE)) {
            dsString = String.format("%s;wws:%s:%d:%d:%d", name, host, port, timeout * 1000, 1);
        } else if (type.equals("wsv")) {
            dsString = String.format("%s;ws:%s:%d:%d:1800:1000:UTC", name, host, port, timeout * 1000);
        }
        this.dataSource = DataSourceType.parseConfig(dsString);
        this.dataSource.establish();
        this.dataSource.setUseCache(false);
    }

    public void stop() {
        this.shouldRun = false;
    }

    @Override
    public void run() {
        while (this.shouldRun || !this.plotJobs.isEmpty()) {
            PlotJob pj = null;
            try {
                pj = this.plotJobs.poll(2L, TimeUnit.SECONDS);
                if (pj == null) continue;
                if (pj.plotTimeMs > System.currentTimeMillis()) {
                    this.plotJobs.put(pj);
                    Thread.sleep(1000L);
                    continue;
                }
                SubnetPlotter subnet = pj.subnet;
                LOGGER.info("Plotting subnet {} from {} scheduled for {}", subnet.subnetName, this.name, new Date(pj.plotTimeMs));
                subnet.plot(pj.plotEndMs, this.dataSource);
            }
            catch (InterruptedException noAction) {}
        }
        LOGGER.debug("Exiting WaveSource thread ({}). Job queue: {}", (Object)this.name, (Object)this.plotJobs.size());
    }
}

