/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive.plot;

import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Spectrogram;
import gov.usgs.plot.render.BasicFrameRenderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.plot.render.wave.MinuteMarkingWaveRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.plot.render.wave.SpectrogramRenderer;
import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.core.time.J2kSec;
import gov.usgs.volcanoes.core.time.Time;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelPlotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPlotter.class);
    public static final Color NO_DATA_TEXT_COLOR = new Color(160, 41, 41);
    public static final double WAVE_RATIO = 0.25;
    private static final double DEFAULT_OVERLAP = 0.859375;
    private static final boolean DEFAULT_LOG_POWER = true;
    private static final double DEFAULT_MIN_FREQ = 0.0;
    private static final double DEFAULT_MAX_FREQ = 10.0;
    private static final int DEFAULT_NFFT = 0;
    private static final int DEFAULT_BIN_SIZE = 256;
    private static final int DEFAULT_MAX_POWER = 120;
    private static final int DEFAULT_MIN_POWER = 30;
    protected SliceWave wave;
    protected Font noDataFont;
    protected int index;
    protected Dimension plotDimension;
    protected ConfigFile config;
    private final SliceWaveRenderer waveRenderer;
    protected final SpectrogramRenderer spectrogramRenderer;
    private final BasicFrameRenderer plotFrame;
    protected final int waveHeight;
    private final int minPower;
    private final int maxPower;
    protected final String name;
    protected long plotEndMs;

    protected abstract void tweakSpectrogramRenderer(SpectrogramRenderer var1);

    protected abstract void tweakWaveRenderer(SliceWaveRenderer var1);

    protected abstract void tweakNoDataRenderer(TextRenderer var1);

    public ChannelPlotter(String name, int index, Dimension plotDimension, ConfigFile config) {
        this.name = name;
        this.index = index;
        this.plotDimension = plotDimension;
        this.config = config;
        this.waveHeight = (int)((double)plotDimension.height * 0.25);
        this.minPower = config.getInt("minPower", 30);
        this.maxPower = config.getInt("maxPower", 120);
        this.waveRenderer = this.createWaveRenderer();
        this.spectrogramRenderer = this.createSpectrogramRenderer(config);
        this.plotFrame = new BasicFrameRenderer();
        this.plotFrame.addRenderer(this.waveRenderer);
        this.plotFrame.addRenderer(this.spectrogramRenderer);
    }

    protected SpectrogramRenderer createSpectrogramRenderer(ConfigFile config) {
        SpectrogramRenderer sr = new SpectrogramRenderer();
        sr.yTickMarks = false;
        sr.yTickValues = false;
        sr.xTickMarks = false;
        sr.xTickValues = false;
        sr.xUnits = false;
        sr.xLabel = false;
        sr.setOverlap(config.getDouble("overlap", 0.859375));
        sr.setLogPower(config.getBoolean("logPower", true));
        sr.setMinFreq(config.getDouble("minFreq", 0.0));
        sr.setMaxFreq(config.getDouble("maxFreq", 10.0));
        sr.setNfft(config.getInt("nfft", 0));
        sr.setBinSize(config.getInt("binSize", 256));
        sr.setMinPower(this.minPower);
        sr.setMaxPower(this.maxPower);
        sr.setTimeZone("UTC");
        this.tweakSpectrogramRenderer(sr);
        return sr;
    }

    protected SliceWaveRenderer createWaveRenderer() {
        MinuteMarkingWaveRenderer wr = new MinuteMarkingWaveRenderer();
        wr.xTickMarks = false;
        wr.xTickValues = false;
        wr.xUnits = false;
        wr.xLabel = false;
        wr.yTickMarks = false;
        wr.yTickValues = false;
        wr.setColor(Color.BLACK);
        this.tweakWaveRenderer(wr);
        return wr;
    }

    public void setWave(SliceWave wave) {
        this.wave = wave;
        this.waveRenderer.setWave(wave);
        this.spectrogramRenderer.setWave(wave);
        if (wave != null) {
            double plotStart = wave.getStartTime();
            double plotEnd = wave.getStartTime() + 600.0;
            this.waveRenderer.setMinY(wave.min());
            this.waveRenderer.setMaxY(wave.max());
            this.waveRenderer.setWave(wave);
            this.waveRenderer.setViewTimes(plotStart, plotEnd, "UTC");
            this.waveRenderer.update();
            this.spectrogramRenderer.setWave(wave);
            this.spectrogramRenderer.setViewStartTime(plotStart);
            this.spectrogramRenderer.setViewEndTime(plotEnd);
            this.spectrogramRenderer.createDefaultFrameDecorator();
            this.spectrogramRenderer.update();
            this.plotEndMs = J2kSec.asEpoch(plotEnd);
        }
    }

    public BasicFrameRenderer plot() {
        if (this.wave != null && this.wave.samples() > 0) {
            return this.plotFrame;
        }
        return this.noDataRenderer();
    }

    private BasicFrameRenderer noDataRenderer() {
        int top = this.index * this.plotDimension.height;
        TextRenderer tr = new TextRenderer(this.plotDimension.width / 2, top + this.plotDimension.height / 2, this.name + " - no data");
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        tr.color = NO_DATA_TEXT_COLOR;
        tr.font = this.noDataFont;
        this.tweakNoDataRenderer(tr);
        BasicFrameRenderer fr = new BasicFrameRenderer();
        fr.addRenderer(tr);
        return fr;
    }

    public long getPlotEndMs() {
        return this.plotEndMs;
    }

    public String getCsv(String timestampFormat) {
        Spectrogram spectrogram = this.spectrogramRenderer.getSpectrogram();
        if (spectrogram == null) {
            return null;
        }
        double[][] buffer = spectrogram.getSpectraAmplitude();
        long time = this.plotEndMs - 600000L;
        long incr = (this.plotEndMs - time) / (long)buffer.length;
        StringBuffer sb = new StringBuffer();
        for (double[] row : buffer) {
            sb.append(Time.format(timestampFormat, time) + ",");
            for (double col : row) {
                sb.append((int)col + ",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\n");
            time += incr;
        }
        return sb.toString();
    }
}

