/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive.plot;

import gov.usgs.plot.render.TextRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.plot.render.wave.SpectrogramRenderer;
import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.pensive.plot.ChannelPlotter;
import java.awt.Dimension;
import java.awt.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullPlotter
extends ChannelPlotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullPlotter.class);
    public static final Font NO_DATA_FONT = Font.decode("dialog-PLAIN-36");
    public static final int LABEL_HEIGHT = 35;
    public static final int LABEL_WIDTH = 30;

    public FullPlotter(String name, int index, Dimension plotDimension, boolean decorateX, ConfigFile config) {
        super(name, index, plotDimension, config);
        this.spectrogramRenderer.xTickValues = decorateX;
        this.spectrogramRenderer.xUnits = decorateX;
        this.spectrogramRenderer.xLabel = decorateX;
        this.noDataFont = NO_DATA_FONT;
    }

    protected void tweakSpectrogramRenderer(SpectrogramRenderer spectrogramRenderer) {
        spectrogramRenderer.yTickMarks = true;
        spectrogramRenderer.yTickValues = true;
        spectrogramRenderer.xTickMarks = true;
        spectrogramRenderer.setYLabelText(this.name.replace(' ', '_'));
        LOGGER.warn("+++++++{}", (Object)this.name.replace(' ', '_'));
        int top = this.index * this.plotDimension.height;
        spectrogramRenderer.setLocation(30, top + this.waveHeight + 35, this.plotDimension.width - 60, this.plotDimension.height - this.waveHeight);
    }

    protected void tweakWaveRenderer(SliceWaveRenderer waveRenderer) {
        int top = this.index * this.plotDimension.height + 35;
        int width = this.plotDimension.width;
        waveRenderer.setLocation(30, top, width - 60, this.waveHeight);
        waveRenderer.xTickMarks = true;
    }

    protected void tweakNoDataRenderer(TextRenderer textRenderer) {
        textRenderer.y += 35.0;
    }
}

