/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive.schedule;

import gov.usgs.volcanoes.core.configfile.ConfigFile;
import gov.usgs.volcanoes.pensive.PlotJob;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import gov.usgs.volcanoes.pensive.schedule.AbstractPlotScheduler;
import java.util.Date;

public class BackfillPlotScheduler
extends AbstractPlotScheduler {
    private long startTime;
    private long endTime;

    public BackfillPlotScheduler(String name, ConfigFile config) {
        super(name, config);
    }

    public void setRange(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    protected void schedulePlots() {
        long duration = 600000L;
        long firstPlot = this.startTime - this.startTime % 600000L + 600000L;
        long lastPlot = this.endTime;
        long offset = this.endTime % 600000L;
        if (offset > 0L) {
            lastPlot += 600000L - offset;
        }
        LOGGER.debug("Scheduling backfill plots ({} - {})", (Object)new Date(firstPlot), (Object)new Date(lastPlot));
        for (SubnetPlotter subnet : this.subnets) {
            try {
                for (long plotTime = firstPlot; plotTime <= lastPlot; plotTime += 600000L) {
                    LOGGER.info("Scheduling subnet " + subnet.subnetName + " (" + new Date(plotTime - 600000L) + " - " + new Date(plotTime) + ")");
                    this.plotJobs.put(new PlotJob(subnet, plotTime));
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted. Unable to schedule " + subnet.subnetName);
            }
        }
    }
}

