/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm;

import gov.usgs.plot.data.file.FileType;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FileTypeDialog
extends SwarmDialog {
    private static final long serialVersionUID = 1L;
    private static final JFrame applicationFrame = Swarm.getApplicationFrame();
    private JLabel filename;
    private JList fileTypes;
    private JCheckBox assumeSame;
    private boolean cancelled = true;
    private boolean opened = false;

    public FileTypeDialog() {
        super(applicationFrame, "Select File Type", true);
        this.setSizeAndLocation();
    }

    public void setFilename(String fn) {
        this.filename.setText(fn);
    }

    protected void createUI() {
        super.createUI();
        this.filename = new JLabel();
        this.filename.setFont(Font.decode("dialog-BOLD-12"));
        this.filename.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.fileTypes = new JList<FileType>(FileType.getKnownTypes());
        this.fileTypes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && FileTypeDialog.this.fileTypes.getSelectedIndex() != -1) {
                    FileTypeDialog.this.okButton.doClick();
                }
            }
        });
        this.fileTypes.setSelectedValue((Object)FileType.UNKNOWN, true);
        this.assumeSame = new JCheckBox("Assume all unknown files are of this type", false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 9, 5, 9));
        panel.setPreferredSize(new Dimension(300, 200));
        JPanel labelPanel = new JPanel(new GridLayout(3, 1));
        labelPanel.add(new JLabel("Select file type: "));
        labelPanel.add(this.filename);
        labelPanel.add(new JLabel("Choose 'Cancel' to skip this file or select file type:"));
        panel.add((Component)labelPanel, "North");
        panel.add((Component)new JScrollPane(this.fileTypes), "Center");
        panel.add((Component)this.assumeSame, "South");
        this.mainPanel.add((Component)panel, "Center");
    }

    public boolean isAssumeSame() {
        return this.assumeSame.isSelected();
    }

    public FileType getFileType() {
        return (FileType)((Object)this.fileTypes.getSelectedValue());
    }

    public void wasOK() {
        this.cancelled = false;
    }

    public void wasCancelled() {
        this.cancelled = true;
        this.opened = false;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.opened = true;
        }
        super.setVisible(b);
    }

    public boolean isOpen() {
        return this.opened;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

