/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class SwarmDialog
extends JDialog {
    private static final long serialVersionUID = -1L;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JPanel buttonPanel;
    protected JPanel mainPanel;
    protected JFrame parent;
    private boolean okClicked;
    protected static SwarmConfig swarmConfig;
    protected static final JFrame applicationFrame;

    protected SwarmDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        swarmConfig = SwarmConfig.getInstance();
        this.setResizable(false);
        this.parent = parent;
        this.createUI();
    }

    protected void setSizeAndLocation() {
        Dimension d = this.mainPanel.getPreferredSize();
        this.setSize(d.width + 10, d.height + 30);
        Dimension parentSize = this.parent.getSize();
        Point parentLoc = this.parent.getLocation();
        this.setLocation(parentLoc.x + (parentSize.width / 2 - d.width / 2), parentLoc.y + (parentSize.height / 2 - d.height / 2));
    }

    protected void createUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SwarmDialog.this.allowOK()) {
                    SwarmDialog.this.dispose();
                    SwarmDialog.this.okClicked = true;
                    SwarmDialog.this.wasOK();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SwarmDialog.this.allowCancel()) {
                    SwarmDialog.this.dispose();
                    SwarmDialog.this.wasCancelled();
                }
            }
        });
        Util.mapKeyStrokeToButton(this.mainPanel, "ESCAPE", "cancel1", this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                SwarmDialog.this.okButton.requestFocus();
                JRootPane root = SwingUtilities.getRootPane(SwarmDialog.this.okButton);
                if (root != null) {
                    root.setDefaultButton(SwarmDialog.this.okButton);
                }
            }

            public void windowClosing(WindowEvent e) {
                if (!SwarmDialog.this.okClicked) {
                    SwarmDialog.this.wasCancelled();
                }
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGlue();
        builder.addButton(new JComponent[]{this.okButton, this.cancelButton});
        this.buttonPanel = builder.getPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.setContentPane(this.mainPanel);
    }

    protected boolean allowOK() {
        return true;
    }

    protected boolean allowCancel() {
        return true;
    }

    protected void wasOK() {
    }

    protected void wasCancelled() {
    }

    static {
        applicationFrame = Swarm.getApplicationFrame();
    }
}

