/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm;

import gov.usgs.util.ConfigFile;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class SwarmFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    protected JComponent northPane;
    protected Dimension oldNorthPaneSize;
    protected boolean fullScreen = false;
    protected static SwarmConfig swarmConfig;
    protected static final JFrame applicationFrame;

    public SwarmFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.setOpaque(false);
        this.setBackground(new Color(255, 255, 255, 0));
        swarmConfig = SwarmConfig.getInstance();
    }

    protected void processStandardLayout(ConfigFile cf) {
        int x = Integer.parseInt(cf.getString("x"));
        int y = Integer.parseInt(cf.getString("y"));
        this.setLocation(x, y);
        int w = Integer.parseInt(cf.getString("w"));
        int h = Integer.parseInt(cf.getString("h"));
        this.setSize(w, h);
        boolean m = Boolean.parseBoolean(cf.getString("maximized"));
        try {
            this.setMaximum(m);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void saveLayout(ConfigFile cf, String prefix) {
        Point pt = this.getLocation();
        cf.put(prefix + ".x", Integer.toString(pt.x));
        cf.put(prefix + ".y", Integer.toString(pt.y));
        Dimension d = this.getSize();
        cf.put(prefix + ".w", Integer.toString(d.width));
        cf.put(prefix + ".h", Integer.toString(d.height));
        cf.put(prefix + ".maximized", Boolean.toString(this.isMaximum()));
    }

    protected void setDefaultKioskMode(boolean b) {
        this.fullScreen = b;
        this.setResizable(!this.fullScreen);
        this.setIconifiable(!this.fullScreen);
        this.setMaximizable(!this.fullScreen);
        this.setClosable(!this.fullScreen);
        this.putClientProperty("JInternalFrame.isPalette", new Boolean(this.fullScreen));
        BasicInternalFrameUI ui = (BasicInternalFrameUI)this.getUI();
        if (this.fullScreen) {
            this.northPane = ui.getNorthPane();
            this.oldNorthPaneSize = this.northPane.getSize();
            this.northPane.setVisible(false);
            this.northPane.setPreferredSize(new Dimension(0, 0));
        } else if (this.northPane != null) {
            this.northPane.setVisible(true);
            this.northPane.setPreferredSize(this.oldNorthPaneSize);
        }
    }

    static {
        applicationFrame = Swarm.getApplicationFrame();
    }
}

