/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceUtils;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSelectReader
extends StringMSeedQueryReader {
    protected int timeoutMillis;
    protected String urlBase;
    protected String userAgent = "Swarm/2.5-SNAPSHOT";
    public static final String DEFAULT_WS_URL = "http://service.iris.edu/fdsnws/dataselect/1/query";

    public DataSelectReader() {
        this(DEFAULT_WS_URL);
    }

    public DataSelectReader(String urlBase) {
        this.urlBase = urlBase;
    }

    public DataSelectReader(String urlBase, int timeoutMillis) {
        this.urlBase = urlBase;
        this.timeoutMillis = timeoutMillis;
    }

    protected String createQuery(String network, String station, String location, String channel) {
        if (location == null || location.trim().length() == 0) {
            location = "--";
        }
        String query = "net=" + network;
        query = query + "&sta=" + station;
        query = query + "&loc=" + location;
        query = query + "&cha=" + channel;
        return query;
    }

    public String createQuery(String network, String station, String location, String channel, Date begin, Date end) {
        String query = this.createQuery(network, station, location, channel);
        SimpleDateFormat longFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        longFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        query = query + "&start=" + longFormat.format(begin);
        query = query + "&end=" + longFormat.format(end);
        return query;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean processRecord(DataRecord dr) {
        return true;
    }

    public List<DataRecord> read(String query) throws IOException, SeisFileException {
        return this.read(query, new ArrayList<DataRecord>());
    }

    public List<DataRecord> read(String query, List<DataRecord> records) throws IOException, SeisFileException {
        URL requestURL = new URL(this.urlBase + "?" + query);
        HttpURLConnection conn = (HttpURLConnection)requestURL.openConnection();
        if (this.timeoutMillis != 0) {
            conn.setReadTimeout(this.timeoutMillis);
        }
        conn.setRequestProperty("User-Agent", this.userAgent);
        conn.connect();
        if (conn.getResponseCode() != 200) {
            if (conn.getResponseCode() == 404) {
                WebServiceUtils.fine("reponse code 404, no data");
                return records;
            }
            throw new SeisFileException("Did not get an OK repsonse code (code=" + conn.getResponseCode() + ", url=" + requestURL + "\"");
        }
        BufferedInputStream bif = new BufferedInputStream(conn.getInputStream());
        DataInputStream in = new DataInputStream(bif);
        try {
            while (true) {
                SeedRecord sr;
                if ((sr = SeedRecord.read((DataInput)in)) instanceof DataRecord) {
                    if (!this.processRecord((DataRecord)sr) || records == null) continue;
                    records.add((DataRecord)sr);
                    continue;
                }
                WebServiceUtils.warning("Not a data record, skipping..." + sr.getControlHeader().getSequenceNum() + " " + sr.getControlHeader().getTypeCode());
            }
        }
        catch (EOFException e) {
            in.close();
            return records;
        }
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

