/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data;

import gov.usgs.plot.data.Wave;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.volcanoes.swarm.data.CachedDataSource;
import gov.usgs.volcanoes.swarm.data.GulperList;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class Gulper
implements Runnable {
    private final SeismicDataSource gulpSource;
    private final GulperList gulperList;
    private final String channel;
    private double lastTime;
    private double goalTime;
    private Thread thread;
    private final String key;
    private final Set<GulperListener> listeners;
    private final int gulpSize;
    private final int gulpDelay;
    private static Logger logger;

    public Gulper(GulperList gl, String k, SeismicDataSource source, String ch, double t1, double t2, int size, int delay) {
        logger = Log.getLogger("gov.usgs.swarm");
        this.gulpSize = size;
        this.gulpDelay = delay;
        this.gulperList = gl;
        this.gulpSource = source;
        this.key = k;
        this.listeners = new HashSet<GulperListener>();
        this.channel = ch;
        this.lastTime = t2;
        double now = CurrentTime.getInstance().nowJ2K();
        if (this.lastTime > now) {
            this.lastTime = now;
        }
    }

    public Gulper(GulperList gl, String k, GulperListener glnr, SeismicDataSource source, String ch, double t1, double t2, int size, int delay) {
        this(gl, k, source, ch, t1, t2, size, delay);
        this.addListener(glnr);
        this.update(t1, t2);
        this.start();
    }

    public synchronized void addListener(GulperListener gl) {
        this.listeners.add(gl);
    }

    public synchronized void removeListener(GulperListener gl) {
        this.listeners.remove(gl);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getKey() {
        return this.key;
    }

    protected void kill() {
        Thread t = this.thread;
        if (t != null) {
            this.thread = null;
            t.interrupt();
        }
    }

    public boolean isKilled() {
        return this.thread == null;
    }

    public void kill(GulperListener gl) {
        this.removeListener(gl);
        if (this.listeners.size() == 0) {
            this.kill();
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
        logger.finer("gulper started for " + this.channel);
    }

    public void update(double t1, double t2) {
        CachedDataSource cache = CachedDataSource.getInstance();
        if (t2 < this.lastTime) {
            this.lastTime = t2;
        }
        this.goalTime = t1;
        while (cache.inHelicorderCache(this.channel, this.lastTime - (double)this.gulpSize, this.lastTime) && this.lastTime > this.goalTime && !this.isKilled()) {
            this.lastTime -= (double)this.gulpSize;
            this.lastTime += 10.0;
        }
    }

    protected synchronized void fireStarted() {
        for (GulperListener listener : this.listeners) {
            listener.gulperStarted();
        }
    }

    protected synchronized void fireGulped(double t1, double t2, Wave w) {
        this.fireGulped(t1, t2, w != null && !this.isKilled());
    }

    protected synchronized void fireGulped(double t1, double t2, boolean success) {
        for (GulperListener listener : this.listeners) {
            listener.gulperGulped(t1, t2, success);
        }
    }

    protected synchronized void fireStopped() {
        boolean killed = this.isKilled();
        for (GulperListener listener : this.listeners) {
            listener.gulperStopped(killed);
        }
    }

    public void run() {
        this.fireStarted();
        this.runLoop();
        this.gulpSource.close();
        if (this.isKilled()) {
            logger.finest("gulper killed");
        } else {
            logger.finest("gulper finished");
        }
        this.gulperList.removeGulper(this);
        this.fireStopped();
    }

    protected void runLoop() {
        while (this.lastTime > this.goalTime && !this.isKilled()) {
            try {
                double t1 = this.lastTime - (double)this.gulpSize;
                double t2 = this.lastTime;
                Wave w = this.gulpSource.getWave(this.channel, t1, t2);
                this.fireGulped(t1, t2, w);
                this.update(this.goalTime, this.lastTime - (double)this.gulpSize + 10.0);
            }
            catch (Throwable e) {
                System.err.println("Exception during gulp:");
                e.printStackTrace();
            }
            this.delay();
        }
    }

    protected void delay() {
        if (!this.isKilled()) {
            try {
                Thread.sleep(this.gulpDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.channel;
    }
}

