/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.fdsnWs;

import gov.usgs.util.Log;
import gov.usgs.volcanoes.swarm.ChannelInfo;
import gov.usgs.volcanoes.swarm.ChannelUtil;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceUtils {
    public static final String SWARM_WS_PROP_KEY_PREFIX = "SWARM_WS_";
    public static final String EMPTY_LOC_CODE = "--";
    private static final Level defaultDebugLevel = Level.FINEST;
    private static final DateFormat dateFormat = WebServiceUtils.createDateFormat();
    private static Level debugLevel;

    public static String addChannel(List<String> channels, ChannelInfo ch, SeismicDataSource source) {
        return ChannelUtil.addChannel(channels, ch, source);
    }

    public static void assignChannels(List<String> channels, SeismicDataSource source) {
        ChannelUtil.assignChannels(channels, source);
    }

    public static DateFormat createDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static void debug(Level level, String msg) {
        if (WebServiceUtils.isDebug(level)) {
            WebServiceUtils.log(level, msg);
        }
    }

    public static void debug(String msg) {
        WebServiceUtils.debug(defaultDebugLevel, msg);
    }

    public static void fine(String msg) {
        WebServiceUtils.log(Level.FINE, msg);
    }

    public static void finer(String msg) {
        WebServiceUtils.log(Level.FINER, msg);
    }

    public static void finest(String msg) {
        WebServiceUtils.log(Level.FINEST, msg);
    }

    public static String getDateText() {
        return WebServiceUtils.getDateText(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateText(Date date) {
        DateFormat dateFormat = WebServiceUtils.dateFormat;
        synchronized (dateFormat) {
            return WebServiceUtils.dateFormat.format(date);
        }
    }

    public static String getProperty(String key) {
        return WebServiceUtils.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        String s = null;
        try {
            s = System.getProperty(key);
            if (s == null) {
                s = System.getenv(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s == null) {
            s = def;
        }
        return s;
    }

    public static void info(String msg) {
        WebServiceUtils.log(Level.INFO, msg);
    }

    public static boolean isDebug() {
        return WebServiceUtils.isDebug(defaultDebugLevel);
    }

    public static boolean isDebug(Level level) {
        return debugLevel != null && level.intValue() >= debugLevel.intValue();
    }

    public static void log(Level level, String msg) {
        msg = "WebService: " + msg;
        Log.getLogger("gov.usgs.swarm").log(level, msg);
    }

    public static Date parseDate(String s) {
        return WebServiceUtils.parseDate(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String s, Date def) {
        if (s != null && s.length() > 0) {
            DateFormat dateFormat = WebServiceUtils.dateFormat;
            synchronized (dateFormat) {
                try {
                    return WebServiceUtils.dateFormat.parse(s);
                }
                catch (Exception exception) {
                }
            }
        }
        return def;
    }

    public static void setDebug(Level level) {
        debugLevel = level;
    }

    public static void warning(String msg) {
        WebServiceUtils.log(Level.WARNING, msg);
    }

    static {
        try {
            String s = WebServiceUtils.getProperty("SWARM_WS_DEBUG");
            if (s != null) {
                debugLevel = Boolean.valueOf(s).booleanValue() ? defaultDebugLevel : Level.parse(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

