/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.fdsnWs;

import edu.sc.seis.seisFile.mseed.DataRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.volcanoes.swarm.ChannelInfo;
import gov.usgs.volcanoes.swarm.data.DataSelectReader;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.data.fdsnWs.AbstractDataRecordClient;
import gov.usgs.volcanoes.swarm.data.fdsnWs.AbstractWebServiceStationClient;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceStationTextClient;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceStationXmlClient;
import gov.usgs.volcanoes.swarm.data.fdsnWs.WebServiceUtils;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesClient
extends AbstractDataRecordClient {
    private static boolean useXmlClientFlag = Boolean.valueOf(WebServiceUtils.getProperty("SWARM_WS_USE_XML"));
    private final AbstractWebServiceStationClient stationClient;
    private final String wsDataSelectUrl;
    private String last_sta = "";
    private int num_stations = 0;
    private int station_cnt = 0;
    private final String progress_id = "channels";

    public static String getDefaultWsDataSelectUrl() {
        return "http://service.iris.edu/fdsnws/dataselect/1/query";
    }

    public static String getDefaultWsStationUrl() {
        return "http://service.iris.edu/fdsnws/station/1/query";
    }

    public WebServicesClient(SeismicDataSource source, String net, String sta, String loc, String chan) {
        this(source, net, sta, loc, chan, WebServicesClient.getDefaultWsDataSelectUrl(), WebServicesClient.getDefaultWsStationUrl());
    }

    public WebServicesClient(final SeismicDataSource source, String net, String sta, String loc, String chan, String wsDataSelectUrl, String wsStationUrl) {
        super(source);
        Date date = null;
        final List<String> channelList = WebServiceStationXmlClient.createChannelList();
        this.stationClient = useXmlClientFlag ? new WebServiceStationXmlClient(wsStationUrl, net, sta, loc, chan, date){

            public void processChannel(ChannelInfo ch) {
                WebServiceUtils.addChannel(channelList, ch, source);
                if (WebServicesClient.this.last_sta.compareTo(ch.getStation()) != 0) {
                    WebServicesClient.this.last_sta = ch.getStation();
                    if (WebServicesClient.this.num_stations > 0) {
                        WebServicesClient.this.getSource().fireChannelsProgress("channels", (double)WebServicesClient.this.station_cnt / (double)WebServicesClient.this.num_stations);
                    }
                    WebServicesClient.this.station_cnt++;
                }
            }
        } : new WebServiceStationTextClient(wsStationUrl, net, sta, loc, chan, date){

            public void processChannel(ChannelInfo ch) {
                WebServiceUtils.addChannel(channelList, ch, source);
                if (WebServicesClient.this.last_sta.compareTo(ch.getStation()) != 0) {
                    WebServicesClient.this.last_sta = ch.getStation();
                    if (WebServicesClient.this.num_stations > 0) {
                        WebServicesClient.this.getSource().fireChannelsProgress("channels", (double)WebServicesClient.this.station_cnt / (double)WebServicesClient.this.num_stations);
                    }
                    WebServicesClient.this.station_cnt++;
                }
            }
        };
        this.stationClient.setStationList(AbstractWebServiceStationClient.createStationList());
        this.stationClient.setChannelList(channelList);
        this.wsDataSelectUrl = wsDataSelectUrl;
    }

    @Override
    public List<String> getChannels() {
        List<String> channelList = this.stationClient.getChannelList();
        if (channelList.size() != 0) {
            WebServiceUtils.info("channel list is not empty");
        } else {
            String error = null;
            long start = System.currentTimeMillis();
            if (this.stationClient.isAllNetworks()) {
                this.stationClient.setCurrentStation(null);
                error = this.stationClient.fetchStations();
                if (error == null) {
                    this.getSource().fireChannelsProgress("channels", 0.0);
                    this.num_stations = this.stationClient.getStationList().size();
                    error = this.stationClient.fetchChannels();
                }
            } else {
                this.getSource().fireChannelsProgress("channels", 0.0);
                error = this.stationClient.fetchStations();
                this.num_stations = this.stationClient.getStationList().size();
                if (error == null) {
                    boolean cnt = false;
                    this.stationClient.setCurrentStation(null);
                    error = this.stationClient.fetchChannels();
                }
                this.getSource().fireChannelsProgress("channels", 1.0);
            }
            long end = System.currentTimeMillis();
            if (WebServiceUtils.isDebug()) {
                WebServiceUtils.debug("getChannels(" + (useXmlClientFlag ? "XML" : "Text") + "): " + (double)(end - start) / 1000.0 + " seconds");
            }
            if (error != null) {
                WebServiceUtils.warning("could not get channels: " + error);
            }
            this.assignChannels(channelList);
        }
        return channelList;
    }

    @Override
    public Wave getRawData(final ChannelInfo channelInfo, double t1, double t2) {
        Date begin = this.getDate(t1);
        Date end = this.getDate(t2);
        final List<Wave> waves = this.createWaves();
        DataSelectReader reader = new DataSelectReader(this.wsDataSelectUrl){

            public boolean processRecord(DataRecord dr) {
                try {
                    WebServicesClient.this.addWaves(waves, dr);
                }
                catch (Exception ex) {
                    WebServiceUtils.warning("could not get web service raw data (" + channelInfo + "): " + ex.getMessage());
                }
                return true;
            }
        };
        try {
            String query = reader.createQuery(channelInfo.getNetwork(), channelInfo.getStation(), channelInfo.getLocation(), channelInfo.getChannel(), begin, end);
            reader.read(query, null);
        }
        catch (Exception ex) {
            WebServiceUtils.warning("could not get web service raw data (" + channelInfo + "): " + ex.getMessage());
        }
        Wave wave = this.join(waves);
        if (wave != null && WebServiceUtils.isDebug()) {
            WebServiceUtils.debug("web service raw data (" + this.getDateText(wave.getStartTime()) + ", " + this.getDateText(wave.getEndTime()) + ")");
        }
        return wave;
    }
}

