/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

import gov.usgs.util.xml.SimpleXMLParser;
import gov.usgs.util.xml.XMLDocHandler;
import gov.usgs.volcanoes.swarm.AbstractChannelInfo;
import gov.usgs.volcanoes.swarm.ChannelUtil;
import gov.usgs.volcanoes.swarm.GroupsType;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedLinkChannelInfo
extends AbstractChannelInfo {
    public static final String DATA_TYPE = "D";
    private String channel;
    private final List<String> channels = new ArrayList<String>();
    private final String channelTag = "seedname";
    private final SeedLinkSource dataSource;
    private final GroupsType groupsType = GroupsType.NETWORK_AND_SITE;
    private double latitude = Double.NaN;
    private double longitude = Double.NaN;
    private String location;
    private final String locTag = "location";
    private String network;
    private final String networkTag = "network";
    private String siteName;
    private String station;
    private final String stationNameTag = "name";
    private final String stationTag = "station";
    private final String streamTag = "stream";
    private String type;
    private final String typeTag = "type";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) throws IOException {
        FileInputStream stream = new FileInputStream(f);
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File f, String s) throws IOException {
        FileWriter writer = new FileWriter(f);
        try {
            writer.write(s);
        }
        finally {
            writer.close();
        }
    }

    public SeedLinkChannelInfo(SeedLinkSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    public List<String> getGroups() {
        return SeedLinkChannelInfo.getGroups(this, this.groupsType);
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public String getSiteName() {
        return this.siteName;
    }

    public SeismicDataSource getSource() {
        return this.dataSource;
    }

    @Override
    public String getStation() {
        return this.station;
    }

    public String getType() {
        return this.type;
    }

    public void parse(Reader reader) throws Exception {
        SimpleXMLParser.parse(new SeedLinkStationXMLDocHandler(), reader);
    }

    public void parse(String infoStr) throws Exception {
        this.parse(new StringReader(infoStr));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SeedLinkStationXMLDocHandler
    implements XMLDocHandler {
        protected SeedLinkStationXMLDocHandler() {
        }

        private void clearChannel() {
            SeedLinkChannelInfo.this.channel = null;
            SeedLinkChannelInfo.this.location = null;
            SeedLinkChannelInfo.this.type = null;
        }

        private void clearStation() {
            SeedLinkChannelInfo.this.station = null;
            SeedLinkChannelInfo.this.network = null;
            this.clearChannel();
        }

        @Override
        public void endDocument() throws Exception {
        }

        @Override
        public void endElement(String tag) throws Exception {
        }

        @Override
        public void startDocument() throws Exception {
        }

        @Override
        public void startElement(String tag, Map<String, String> h) throws Exception {
            if ("station".equals(tag)) {
                this.clearStation();
                for (String key : h.keySet()) {
                    String val = h.get(key);
                    if ("name".equals(key)) {
                        SeedLinkChannelInfo.this.station = val;
                        continue;
                    }
                    if (!"network".equals(key)) continue;
                    SeedLinkChannelInfo.this.network = val;
                }
            } else if ("stream".equals(tag)) {
                this.clearChannel();
                for (String key : h.keySet()) {
                    String val = h.get(key);
                    if ("seedname".equals(key)) {
                        SeedLinkChannelInfo.this.channel = val;
                        continue;
                    }
                    if ("location".equals(key)) {
                        SeedLinkChannelInfo.this.location = val;
                        continue;
                    }
                    if (!"type".equals(key)) continue;
                    SeedLinkChannelInfo.this.type = val;
                }
                if (SeedLinkChannelInfo.this.station != null && SeedLinkChannelInfo.this.network != null && SeedLinkChannelInfo.this.channel != null && SeedLinkChannelInfo.this.location != null && SeedLinkChannelInfo.DATA_TYPE.equals(SeedLinkChannelInfo.this.type)) {
                    ChannelUtil.addChannel(SeedLinkChannelInfo.this.channels, SeedLinkChannelInfo.this, SeedLinkChannelInfo.this.getSource());
                }
            }
        }

        @Override
        public void text(String str) throws Exception {
        }
    }
}

