/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.SeedException;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.ChannelInfo;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.data.CachedDataSource;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkChannelInfo;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkLog;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkSource;
import gov.usgs.volcanoes.swarm.data.seedLink.StartEndTime;
import gov.usgs.volcanoes.swarm.data.seedLink.orfeus.BaseSLClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.knmi.orfeus.seedlink.SLPacket;
import nl.knmi.orfeus.seedlink.SeedLinkException;

public class SeedLinkClient
extends BaseSLClient {
    private static int _seedLinkClientCounter;
    private static final String CLASS_NAME = "gov.usgs.swarm.data.SeedLinkClient";
    private static final String DATA_TYPE = "D";
    private static final long INFO_REQUEST_INTERVAL = 3600000L;
    private static final SeedLinkLog sllog;
    private long lastInfoRequestTime;
    private final Logger logger;
    private final String logPrefixText = "gov.usgs.swarm.data.SeedLinkClient(" + SeedLinkClient.getNextSeedLinkClientCounter() + "," + Thread.currentThread().getName() + "): ";
    private String scnl;
    private final StartEndTime startEndTime;
    private Thread thread;
    private final Object threadSyncObj = null;
    private List<Wave> waveList;

    private static Btime getBtime(Blockette blockette, int fieldNum) throws SeedException {
        Object obj = blockette.getFieldVal(fieldNum);
        if (obj instanceof Btime) {
            return (Btime)obj;
        }
        return new Btime(obj.toString());
    }

    private static double getDouble(Blockette blockette, int fieldNum) throws SeedException {
        Object obj = blockette.getFieldVal(fieldNum);
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return Double.parseDouble(obj.toString());
    }

    private static int getNextSeedLinkClientCounter() {
        int counter;
        if ((counter = ++_seedLinkClientCounter) == 1) {
            sllog.setLevel(Level.INFO);
        }
        return counter;
    }

    private static String j2kToSeedLinkDateString(double j) {
        if (Double.isNaN(j)) {
            return null;
        }
        return Util.j2KToDateString(j, "yyyy,MM,dd,HH,mm,ss");
    }

    public static void main(String[] args) {
        SeedLinkClient slClient = null;
        try {
            slClient = new SeedLinkClient();
            int rval = slClient.parseCmdLineArgs(args);
            if (rval != 0) {
                System.exit(rval);
            }
            slClient.init();
            slClient.run();
            SeedLinkChannelInfo.writeString(new File("streams.xml"), slClient.slconn.getInfoString());
        }
        catch (SeedLinkException sle) {
            sllog.log(true, 0, sle.getMessage());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static String toString(Object obj) {
        return SeedLinkSource.toString(obj);
    }

    private SeedLinkClient() {
        super(sllog);
        this.logger = SeedLinkLog.logger;
        this.startEndTime = new StartEndTime();
        this.thread = new Thread(this);
    }

    public SeedLinkClient(String host, int port) {
        this();
        String sladdr = host + ":" + port;
        this.slconn.setSLAddress(sladdr);
    }

    protected void cacheWave(String scnl, Wave wave) {
        if (scnl == null || wave == null) {
            return;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.logPrefixText + "putting wave in cache (" + scnl + "): " + SeedLinkClient.toString(wave));
        }
        CachedDataSource.getInstance().putWave(scnl, wave);
        CachedDataSource.getInstance().cacheWaveAsHelicorder(scnl, wave);
    }

    public void close() {
        this.logger.fine(this.logPrefixText + "close the SeedLinkConnection");
        this.slconn.terminate();
        this.kill();
    }

    public String getInfoString() {
        try {
            this.infolevel = "STREAMS";
            this.init();
            this.runAndWait();
            return this.slconn.clearInfoString();
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, this.logPrefixText + "could not get channels", ex);
            return null;
        }
    }

    private String getMultiSelect(ChannelInfo channelInfo) {
        return channelInfo.getNetwork() + "_" + channelInfo.getStation() + ":" + channelInfo.getLocation() + channelInfo.getChannel() + "." + DATA_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartEndTime getStartEndTime(StartEndTime o) {
        StartEndTime startEndTime = this.startEndTime;
        synchronized (startEndTime) {
            if (o == null) {
                o = new StartEndTime(this.startEndTime);
            } else {
                o.set(this.startEndTime);
            }
            this.startEndTime.clear();
        }
        return o;
    }

    public Wave getWave(String scnl, double t1, double t2) {
        this.waveList = new ArrayList<Wave>();
        this.init(scnl, t1, t2);
        this.runAndWait();
        Wave wave = Wave.join(this.waveList);
        this.waveList = null;
        return wave;
    }

    public void init(String scnl, double t1, double t2) {
        this.scnl = scnl;
        ChannelInfo channelInfo = new ChannelInfo(scnl);
        this.infolevel = null;
        this.multiselect = this.getMultiSelect(channelInfo);
        this.begin_time = SeedLinkClient.j2kToSeedLinkDateString(t1);
        this.end_time = SeedLinkClient.j2kToSeedLinkDateString(t2);
        StringBuilder sb = new StringBuilder(this.slconn.getSLAddress());
        if (this.selectors != null) {
            sb.append(" -s " + this.selectors);
        }
        if (this.multiselect != null) {
            sb.append(" -S " + this.multiselect);
        }
        if (this.begin_time != null) {
            sb.append(" -t " + this.begin_time);
        }
        if (this.end_time != null) {
            sb.append(" -e " + this.end_time);
        }
        this.logger.info(this.logPrefixText + sb.toString());
        try {
            this.init();
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, this.logPrefixText + "could start SeedLink client", ex);
        }
    }

    protected boolean isKilled() {
        return this.thread == null;
    }

    protected void kill() {
        Thread t = this.thread;
        if (t != null) {
            this.thread = null;
            t.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packetHandler(int count, SLPacket slpack) throws Exception {
        block13: {
            if (this.isKilled()) {
                return true;
            }
            if (count % 10000 == 0) {
                Runtime.getRuntime().gc();
                this.logger.finer(this.logPrefixText + "Packet count reached limit of " + 10000 + ", garbage collection performed.");
            }
            if (slpack == null || slpack == SLPacket.SLNOPACKET || slpack == SLPacket.SLERROR) {
                return false;
            }
            int type = slpack.getType();
            if (type == -102) {
                return false;
            }
            if (type == -101) {
                this.logger.finer(this.logPrefixText + "received INFO packet:\n" + this.slconn.getInfoString());
                return this.infolevel != null;
            }
            long currTime = System.currentTimeMillis();
            if (currTime - this.lastInfoRequestTime > 3600000L && !this.slconn.getState().expect_info) {
                this.logger.finer(this.logPrefixText + "requesting INFO level ID");
                String infostr = "ID";
                this.slconn.requestInfo(infostr);
                this.lastInfoRequestTime = currTime;
            }
            Blockette blockette = slpack.getBlockette();
            this.logger.finest(this.logPrefixText + "packet seqnum=" + slpack.getSequenceNumber() + ", packet type=" + type + ", blockette type=" + blockette.getType() + ", blockette=" + blockette);
            Waveform waveform = blockette.getWaveform();
            if (waveform != null && blockette.getType() == 999 && Swarm.getApplicationFrame() != null) {
                try {
                    Btime bTime = SeedLinkClient.getBtime(blockette, 8);
                    double factor = SeedLinkClient.getDouble(blockette, 10);
                    double multiplier = SeedLinkClient.getDouble(blockette, 11);
                    double startTime = Util.dateToJ2K(this.btimeToDate(bTime));
                    double samplingRate = this.getSampleRate(factor, multiplier);
                    Wave wave = new Wave();
                    wave.setSamplingRate(samplingRate);
                    wave.setStartTime(startTime);
                    wave.buffer = waveform.getDecodedIntegers();
                    wave.register();
                    this.cacheWave(this.scnl, wave);
                    if (this.waveList != null) {
                        this.waveList.add(wave);
                        break block13;
                    }
                    double endTime = wave.getEndTime();
                    StartEndTime startEndTime = this.startEndTime;
                    synchronized (startEndTime) {
                        this.startEndTime.update(startTime, endTime);
                    }
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, this.logPrefixText + "packetHandler: could create wave", ex);
                    return true;
                }
            }
        }
        return false;
    }

    private float getSampleRate(double factor, double multiplier) {
        float sampleRate = 10000.0f;
        if (factor * multiplier != 0.0) {
            sampleRate = (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier)));
        }
        return sampleRate;
    }

    private Date btimeToDate(Btime btime) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, btime.getYear());
        cal.set(6, btime.getDayOfYear());
        cal.set(11, btime.getHour());
        cal.set(12, btime.getMinute());
        cal.set(13, btime.getSecond());
        cal.set(14, btime.getTenthMill() / 10);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        if (this.threadSyncObj != null) {
            Object object = this.threadSyncObj;
            synchronized (object) {
                this.threadSyncObj.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAndWait() {
        if (this.threadSyncObj != null) {
            this.start();
            Object object = this.threadSyncObj;
            synchronized (object) {
                try {
                    this.threadSyncObj.wait();
                }
                catch (InterruptedException ex) {
                    this.kill();
                }
            }
        }
        this.run();
    }

    public void start() {
        Thread t = this.thread;
        if (t != null) {
            t.start();
        }
    }

    static {
        sllog = new SeedLinkLog();
    }
}

