/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

import gov.usgs.volcanoes.swarm.data.Gulper;
import gov.usgs.volcanoes.swarm.data.GulperList;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkClient;
import gov.usgs.volcanoes.swarm.data.seedLink.SeedLinkSource;
import gov.usgs.volcanoes.swarm.data.seedLink.StartEndTime;

public class SeedLinkGulper
extends Gulper {
    private final SeedLinkClient client;
    private final StartEndTime startEndTime = new StartEndTime();

    public SeedLinkGulper(GulperList gl, String k, SeedLinkSource source, String ch, double t1, double t2, int size, int delay) {
        super(gl, k, source, ch, t1, t2, size, delay);
        this.client = source.createClient();
        this.client.init(ch, t1, Double.NaN);
        this.client.start();
    }

    public boolean isKilled() {
        return super.isKilled() || this.client.isKilled();
    }

    protected void kill() {
        this.client.kill();
        super.kill();
    }

    protected void runLoop() {
        while (!this.isKilled()) {
            this.client.getStartEndTime(this.startEndTime);
            if (!this.startEndTime.isEmpty()) {
                this.fireGulped(this.startEndTime.getStartTime(), this.startEndTime.getEndTime(), true);
                this.startEndTime.clear();
            }
            this.delay();
        }
    }

    public void start() {
        super.start();
    }

    public void update(double t1, double t2) {
    }
}

