/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.data.seedLink;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SeedUtils {
    public static Date btimeToDate(Btime btime) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, btime.getYear());
        cal.set(6, btime.getDayOfYear());
        cal.set(11, btime.getHour());
        cal.set(12, btime.getMin());
        cal.set(13, btime.getSec());
        cal.set(14, btime.getTenthMilli() / 10);
        return cal.getTime();
    }

    public static double btimeToJ2K(Btime btime) {
        Date date = SeedUtils.btimeToDate(btime);
        double j2k = Util.dateToJ2K(date);
        return j2k;
    }

    public static Wave createWave(DataRecord dr, Blockette1000 b1000) throws UnsupportedCompressionType, CodecException {
        DataHeader dh = dr.getHeader();
        byte type = b1000.getEncodingFormat();
        byte[] data = dr.getData();
        boolean swapNeeded = b1000.getWordOrder() == 0;
        Codec codec = new Codec();
        DecompressedData decomp = codec.decompress((int)type, data, dr.getHeader().getNumSamples(), swapNeeded);
        Wave wave = new Wave();
        wave.setSamplingRate(dh.getSampleRate());
        wave.setStartTime(SeedUtils.getStartTime(dh));
        wave.buffer = decomp.getAsInt();
        wave.register();
        return wave;
    }

    public static double getStartTime(DataHeader dh) {
        Btime btime = dh.getStartBtime();
        double j2k = SeedUtils.btimeToJ2K(btime);
        return j2k;
    }
}

