/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.heli;

import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.render.HelicorderRenderer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.GridBagHelper;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.FileChooser;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.Kioskable;
import gov.usgs.volcanoes.swarm.Swarm;
import gov.usgs.volcanoes.swarm.SwarmFrame;
import gov.usgs.volcanoes.swarm.SwarmUtil;
import gov.usgs.volcanoes.swarm.SwingWorker;
import gov.usgs.volcanoes.swarm.Throbber;
import gov.usgs.volcanoes.swarm.chooser.DataChooser;
import gov.usgs.volcanoes.swarm.data.GulperListener;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.data.SeismicDataSourceListener;
import gov.usgs.volcanoes.swarm.heli.HelicorderViewPanel;
import gov.usgs.volcanoes.swarm.heli.HelicorderViewerSettings;
import gov.usgs.volcanoes.swarm.heli.HelicorderViewerSettingsDialog;
import gov.usgs.volcanoes.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.volcanoes.swarm.map.MapFrame;
import gov.usgs.volcanoes.swarm.time.TimeListener;
import gov.usgs.volcanoes.swarm.time.UiTime;
import gov.usgs.volcanoes.swarm.time.WaveViewTime;
import gov.usgs.volcanoes.swarm.wave.WaveClipboardFrame;
import gov.usgs.volcanoes.swarm.wave.WaveViewSettings;
import gov.usgs.volcanoes.swarm.wave.WaveViewSettingsToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class HelicorderViewerFrame
extends SwarmFrame
implements Kioskable {
    public static final long serialVersionUID = -1L;
    public static final int[] chunkValues = new int[]{600, 900, 1200, 1800, 3600, 7200, 10800, 21600};
    public static final int[] spanValues = new int[]{120, 240, 360, 720, 1440, 2880, 4320, 5760, 7200, 8640, 10080, 11520, 12960, 14400, 15840, 17280, 18720, 20160};
    public static final int[] zoomValues = new int[]{1, 2, 5, 10, 20, 30, 60, 120, 300, 600};
    private RefreshThread refreshThread;
    private SeismicDataSource dataSource;
    private JPanel mainPanel;
    private JToolBar toolBar;
    private JToggleButton pinButton;
    private JButton settingsButton;
    private JButton backButton;
    private JButton forwardButton;
    private JButton compX;
    private JButton expX;
    private JButton compY;
    private JButton expY;
    private JButton clipboard;
    private JButton removeWave;
    private JButton capture;
    private JFileChooser chooser;
    private JButton scaleButton;
    private boolean scaleClipState;
    protected JToggleButton autoScaleSliderButton;
    protected int autoScaleSliderButtonState;
    protected JSlider autoScaleSlider;
    private HelicorderViewPanel helicorderViewPanel;
    private WaveViewSettings waveViewSettings;
    private HelicorderViewerSettings settings;
    private boolean gulperWorking;
    private boolean working;
    private JLabel statusLabel;
    private JPanel heliPanel;
    protected long lastRefreshTime;
    private Border border;
    private Border thinBorder;
    protected Throbber throbber;
    protected JProgressBar progressBar;
    private boolean noData = false;
    private TimeListener timeListener;
    public GulperListener gulperListener;
    private SeismicDataSourceListener dataListener;

    public HelicorderViewerFrame(ConfigFile cf) {
        super("<layout>", true, true, true, true);
        UiTime.touchTime();
        String channel = cf.getString("channel");
        SeismicDataSource sds = swarmConfig.getSource(cf.getString("source"));
        this.dataSource = sds.getCopy();
        this.setTitle(channel + ", [" + this.dataSource + "]");
        this.settings = new HelicorderViewerSettings(channel);
        this.settings.set(cf);
        this.waveViewSettings = new WaveViewSettings();
        this.waveViewSettings.set(cf.getSubConfig("wave"));
        this.createUI();
        boolean pinned = Boolean.parseBoolean(cf.getString("pinned"));
        this.setPinned(pinned);
        this.processStandardLayout(cf);
        this.setVisible(true);
        this.getHelicorder();
        this.refreshThread = new RefreshThread();
    }

    public HelicorderViewerFrame(SeismicDataSource sds, String ch, double bt) {
        super(ch + ", [" + sds + "]", true, true, true, true);
        UiTime.touchTime();
        this.settings = new HelicorderViewerSettings(ch);
        this.settings.setBottomTime(bt);
        this.waveViewSettings = new WaveViewSettings();
        this.dataSource = sds.getCopy();
        this.createUI();
        this.setVisible(true);
        this.getHelicorder();
        this.refreshThread = new RefreshThread();
    }

    public void saveLayout(ConfigFile cf, String prefix) {
        super.saveLayout(cf, prefix);
        cf.put("helicorder", prefix);
        cf.put(prefix + ".source", this.dataSource.getName());
        cf.put(prefix + ".pinned", Boolean.toString(this.pinButton.isSelected()));
        this.settings.save(cf, prefix);
        this.waveViewSettings.save(cf, prefix + ".wave");
    }

    public void createUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.createHeliPanel();
        this.createToolBar();
        this.createStatusLabel();
        this.createListeners();
        this.setFrameIcon(Icons.heli);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 750);
        this.setContentPane(this.mainPanel);
    }

    public void addLinkListeners() {
        this.helicorderViewPanel.addListener(WaveClipboardFrame.getInstance().getLinkListener());
        this.helicorderViewPanel.addListener(MapFrame.getInstance().getLinkListener());
    }

    private void createStatusLabel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 5, 0, 0));
        statusPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 3));
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(100, 15));
        this.progressBar.setSize(new Dimension(100, 15));
        this.progressBar.setMaximumSize(new Dimension(100, 15));
        statusPanel.add(this.progressBar);
        this.mainPanel.add((Component)statusPanel, "South");
    }

    private void createHeliPanel() {
        this.settings.view = this.helicorderViewPanel = new HelicorderViewPanel(this);
        this.heliPanel = new JPanel(new BorderLayout());
        this.thinBorder = LineBorder.createGrayLineBorder();
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 3), this.thinBorder);
        this.heliPanel.setBorder(this.border);
        this.heliPanel.add((Component)this.helicorderViewPanel, "Center");
        this.mainPanel.add((Component)this.heliPanel, "Center");
    }

    private void createToolBar() {
        this.toolBar = SwarmUtil.createToolBar();
        this.pinButton = SwarmUtil.createToolBarToggleButton(Icons.pin, "Helicorder always on top", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.setPinned(HelicorderViewerFrame.this.pinButton.isSelected());
            }
        });
        this.toolBar.add(this.pinButton);
        this.settingsButton = SwarmUtil.createToolBarButton(Icons.settings, "Helicorder view settings", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerSettingsDialog hvsd = HelicorderViewerSettingsDialog.getInstance(HelicorderViewerFrame.this.settings, HelicorderViewerFrame.this.waveViewSettings);
                hvsd.setVisible(true);
                HelicorderViewerFrame.this.noData = false;
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        this.toolBar.add(this.settingsButton);
        this.toolBar.addSeparator();
        this.backButton = SwarmUtil.createToolBarButton(Icons.left, "Scroll back time (A or Left arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HelicorderViewerFrame.this.helicorderViewPanel.hasInset()) {
                    HelicorderViewerFrame.this.helicorderViewPanel.moveInset(-1);
                } else {
                    HelicorderViewerFrame.this.scroll(-1);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "LEFT", "backward1", this.backButton);
        Util.mapKeyStrokeToButton(this, "A", "backward2", this.backButton);
        this.toolBar.add(this.backButton);
        this.forwardButton = SwarmUtil.createToolBarButton(Icons.right, "Scroll forward time (Z or Right arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HelicorderViewerFrame.this.helicorderViewPanel.hasInset()) {
                    HelicorderViewerFrame.this.helicorderViewPanel.moveInset(1);
                } else {
                    HelicorderViewerFrame.this.scroll(1);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "RIGHT", "forward1", this.forwardButton);
        Util.mapKeyStrokeToButton(this, "Z", "forward2", this.forwardButton);
        this.toolBar.add(this.forwardButton);
        this.compX = SwarmUtil.createToolBarButton(Icons.xminus, "Compress X-axis (Alt-left arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decXAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", this.compX);
        this.toolBar.add(this.compX);
        this.expX = SwarmUtil.createToolBarButton(Icons.xplus, "Expand X-axis (Alt-right arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incXAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", this.expX);
        this.toolBar.add(this.expX);
        this.compY = SwarmUtil.createToolBarButton(Icons.yminus, "Compress Y-axis (Alt-down arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decYAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt DOWN", "compy", this.compY);
        this.toolBar.add(this.compY);
        this.expY = SwarmUtil.createToolBarButton(Icons.yplus, "Expand Y-axis (Alt-up arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incYAxis();
                HelicorderViewerFrame.this.getHelicorder();
            }
        });
        Util.mapKeyStrokeToButton(this, "alt UP", "expy", this.expY);
        this.toolBar.add(this.expY);
        this.toolBar.addSeparator();
        JButton addZoom = SwarmUtil.createToolBarButton(Icons.zoomplus, "Decrease zoom time window (+)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.decZoom();
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        Util.mapKeyStrokeToButton(this, "EQUALS", "addzoom1", addZoom);
        Util.mapKeyStrokeToButton(this, "shift EQUALS", "addzoom2", addZoom);
        this.toolBar.add(addZoom);
        JButton subZoom = SwarmUtil.createToolBarButton(Icons.zoomminus, "Increase zoom time window (-)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.incZoom();
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        Util.mapKeyStrokeToButton(this, "MINUS", "subzoom", subZoom);
        this.toolBar.add(subZoom);
        new WaveViewSettingsToolbar(this.waveViewSettings, this.toolBar, this);
        this.clipboard = SwarmUtil.createToolBarButton(Icons.clipboard, "Copy inset to clipboard (C or Ctrl-C)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.insetToClipboard();
            }
        });
        this.clipboard.setEnabled(false);
        Util.mapKeyStrokeToButton(this, "control C", "clipboard1", this.clipboard);
        Util.mapKeyStrokeToButton(this, "C", "clipboard2", this.clipboard);
        this.toolBar.add(this.clipboard);
        this.removeWave = SwarmUtil.createToolBarButton(Icons.delete, "Remove inset wave (Delete or Escape)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.removeWaveInset();
            }
        });
        this.removeWave.setEnabled(false);
        Util.mapKeyStrokeToButton(this, "ESCAPE", "removewave", this.removeWave);
        Util.mapKeyStrokeToButton(this, "DELETE", "removewave", this.removeWave);
        this.toolBar.add(this.removeWave);
        this.toolBar.addSeparator();
        this.capture = SwarmUtil.createToolBarButton(Icons.camera, "Save helicorder image (P)", new CaptureActionListener());
        Util.mapKeyStrokeToButton(this, "P", "capture", this.capture);
        this.toolBar.add(this.capture);
        this.toolBar.addSeparator();
        this.scaleButton = SwarmUtil.createToolBarButton(Icons.wavezoom, "Toggle between adjusting helicoder scale and clip", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelicorderViewerFrame.this.scaleClipState = !HelicorderViewerFrame.this.scaleClipState;
                if (HelicorderViewerFrame.this.scaleClipState) {
                    HelicorderViewerFrame.this.autoScaleSlider.setValue(40 - new Double(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barMult * 4.0).intValue());
                    HelicorderViewerFrame.this.scaleButton.setIcon(Icons.waveclip);
                    HelicorderViewerFrame.this.autoScaleSlider.setToolTipText("Adjust helicorder clip");
                } else {
                    HelicorderViewerFrame.this.autoScaleSlider.setValue(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars / 3);
                    HelicorderViewerFrame.this.scaleButton.setIcon(Icons.wavezoom);
                    HelicorderViewerFrame.this.autoScaleSlider.setToolTipText("Adjust helicorder scale");
                }
                HelicorderViewerFrame.this.settings.notifyView();
            }
        });
        this.scaleButton.setSelected(true);
        this.toolBar.add(this.scaleButton);
        this.autoScaleSlider = new JSlider(1, 39, (int)((10.0 - this.settings.barMult) * 4.0));
        this.autoScaleSlider.setToolTipText("Adjust helicorder scale");
        this.autoScaleSlider.setFocusable(false);
        this.autoScaleSlider.setPreferredSize(new Dimension(80, 20));
        this.autoScaleSlider.setMaximumSize(new Dimension(80, 20));
        this.autoScaleSlider.setMinimumSize(new Dimension(80, 20));
        this.autoScaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.autoScale = true;
                if (!HelicorderViewerFrame.this.autoScaleSlider.getValueIsAdjusting()) {
                    if (HelicorderViewerFrame.this.scaleClipState) {
                        ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars = HelicorderViewerFrame.this.autoScaleSlider.getValue() * 3;
                    } else {
                        ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barMult = 10.0 - new Integer(HelicorderViewerFrame.this.autoScaleSlider.getValue()).doubleValue() / 4.0;
                    }
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }
        });
        this.toolBar.add(this.autoScaleSlider);
        this.toolBar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolBar.add(this.throbber);
        this.mainPanel.add((Component)this.toolBar, "North");
    }

    private void createListeners() {
        this.timeListener = new TimeListener(){

            public void timeChanged(double j2k) {
                HelicorderViewerFrame.this.helicorderViewPanel.setCursorMark(j2k);
            }
        };
        WaveViewTime.addTimeListener(this.timeListener);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                if (((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel != null) {
                    DataChooser.getInstance().setNearest(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                HelicorderViewerFrame.this.dispose();
                HelicorderViewerFrame.this.throbber.close();
                HelicorderViewerFrame.this.refreshThread.kill();
                SwarmInternalFrames.remove(HelicorderViewerFrame.this);
                WaveViewTime.removeTimeListener(HelicorderViewerFrame.this.timeListener);
                HelicorderViewerFrame.this.dataSource.notifyDataNotNeeded(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel, HelicorderViewerFrame.this.helicorderViewPanel.getStartTime(), HelicorderViewerFrame.this.helicorderViewPanel.getEndTime(), HelicorderViewerFrame.this.gulperListener);
                HelicorderViewerFrame.this.dataSource.close();
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
                HelicorderViewerFrame.this.helicorderViewPanel.setResized(true);
                HelicorderViewerFrame.this.repaintHelicorder();
                HelicorderViewerFrame.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (HelicorderViewerFrame.this.getWidth() < 530) {
                    HelicorderViewerFrame.this.helicorderViewPanel.setMinimal(true);
                } else {
                    HelicorderViewerFrame.this.helicorderViewPanel.setMinimal(false);
                }
                HelicorderViewerFrame.this.helicorderViewPanel.setResized(true);
                HelicorderViewerFrame.this.repaintHelicorder();
                HelicorderViewerFrame.this.repaint();
            }
        });
        this.gulperListener = new GulperListener(){

            public void gulperStarted() {
                HelicorderViewerFrame.this.gulperWorking = true;
                HelicorderViewerFrame.this.throbber.increment();
            }

            public void gulperStopped(boolean killed) {
                if (killed) {
                    HelicorderViewerFrame.this.noData = true;
                } else {
                    HelicorderViewerFrame.this.gulperWorking = false;
                    HelicorderViewerFrame.this.throbber.decrement();
                    HelicorderData hd = HelicorderViewerFrame.this.helicorderViewPanel.getData();
                    if (hd == null || hd.rows() == 0) {
                        HelicorderViewerFrame.this.noData = true;
                    }
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }

            public void gulperGulped(double t1, double t2, boolean success) {
                if (success) {
                    HelicorderViewerFrame.this.getHelicorder();
                }
            }
        };
        this.dataListener = new SeismicDataSourceListener(){

            public void channelsProgress(String id, double progress) {
            }

            public void channelsUpdated() {
            }

            public void helicorderProgress(String channel, final double progress) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!HelicorderViewerFrame.this.progressBar.isVisible()) {
                            HelicorderViewerFrame.this.progressBar.setVisible(true);
                        }
                        if (progress == -1.0) {
                            HelicorderViewerFrame.this.progressBar.setIndeterminate(true);
                            HelicorderViewerFrame.this.progressBar.setString("Waiting for server");
                        } else if (progress >= 0.0 && progress < 1.0) {
                            HelicorderViewerFrame.this.progressBar.setIndeterminate(false);
                            HelicorderViewerFrame.this.progressBar.setValue((int)(progress * 100.0));
                            HelicorderViewerFrame.this.progressBar.setString("Downloading");
                        }
                        if (progress == 1.0) {
                            HelicorderViewerFrame.this.progressBar.setVisible(false);
                        }
                    }
                });
            }
        };
        this.dataSource.addListener(this.dataListener);
    }

    public HelicorderViewPanel getHelicorderViewPanel() {
        return this.helicorderViewPanel;
    }

    public void setPinned(boolean b) {
        this.pinButton.setSelected(b);
        int layer = b ? JLayeredPane.MODAL_LAYER : JLayeredPane.DEFAULT_LAYER;
        Swarm.setFrameLayer(this, layer);
    }

    public void incXAxis() {
        int index = SwarmUtil.linearSearch(chunkValues, this.settings.timeChunk);
        if (index == -1 || index == chunkValues.length - 1) {
            return;
        }
        this.settings.timeChunk = chunkValues[index + 1];
    }

    public void decXAxis() {
        int index = SwarmUtil.linearSearch(chunkValues, this.settings.timeChunk);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.timeChunk = chunkValues[index - 1];
    }

    public void incYAxis() {
        int index = SwarmUtil.linearSearch(spanValues, this.settings.span);
        if (index == -1 || index == spanValues.length - 1) {
            return;
        }
        this.settings.span = spanValues[index + 1];
    }

    public void decYAxis() {
        int index = SwarmUtil.linearSearch(spanValues, this.settings.span);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.span = spanValues[index - 1];
    }

    public void incZoom() {
        int index = SwarmUtil.linearSearch(zoomValues, this.settings.waveZoomOffset);
        if (index == -1 || index == zoomValues.length - 1) {
            return;
        }
        this.settings.waveZoomOffset = zoomValues[index + 1];
    }

    public void decZoom() {
        int index = SwarmUtil.linearSearch(zoomValues, this.settings.waveZoomOffset);
        if (index == -1 || index == 0) {
            return;
        }
        this.settings.waveZoomOffset = zoomValues[index - 1];
    }

    public void setInsetButtonsEnabled(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelicorderViewerFrame.this.clipboard.setEnabled(b);
                HelicorderViewerFrame.this.removeWave.setEnabled(b);
            }
        });
    }

    public void setNavigationButtonsEnabled(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelicorderViewerFrame.this.compX.setEnabled(b);
                HelicorderViewerFrame.this.expX.setEnabled(b);
                HelicorderViewerFrame.this.forwardButton.setEnabled(b);
                HelicorderViewerFrame.this.backButton.setEnabled(b);
                HelicorderViewerFrame.this.compY.setEnabled(b);
                HelicorderViewerFrame.this.expY.setEnabled(b);
                HelicorderViewerFrame.this.capture.setEnabled(b);
            }
        });
    }

    public void setKioskMode(boolean b) {
        super.setDefaultKioskMode(b);
        this.helicorderViewPanel.setFullScreen(this.fullScreen);
        if (this.fullScreen) {
            this.mainPanel.remove(this.toolBar);
            this.heliPanel.setBorder(null);
        } else {
            this.mainPanel.add((Component)this.toolBar, "North");
            this.heliPanel.setBorder(this.border);
        }
        if (this.helicorderViewPanel != null) {
            this.helicorderViewPanel.requestFocus();
        }
    }

    public void setStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelicorderViewerFrame.this.statusLabel.setText(status);
            }
        });
    }

    public Throbber getThrobber() {
        return this.throbber;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public WaveViewSettings getWaveViewSettings() {
        return this.waveViewSettings;
    }

    public HelicorderViewerSettings getHelicorderViewerSettings() {
        return this.settings;
    }

    public void repaintHelicorder() {
        this.helicorderViewPanel.invalidateImage();
    }

    public void scroll(int units) {
        double bt = this.settings.getBottomTime();
        if (Double.isNaN(bt)) {
            bt = CurrentTime.getInstance().nowJ2K();
        }
        this.settings.setBottomTime(bt + (double)(units * this.settings.scrollSize * this.settings.timeChunk));
        this.getHelicorder();
    }

    public boolean isWorking() {
        return this.working || this.gulperWorking;
    }

    public void getHelicorder() {
        if (this.noData) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private double end;
            private double before;
            private HelicorderData hd;
            private boolean success = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                try {
                    HelicorderViewerFrame.this.setNavigationButtonsEnabled(false);
                    HelicorderViewerFrame.this.throbber.increment();
                    HelicorderViewerFrame.this.working = true;
                    this.end = HelicorderViewerFrame.this.settings.getBottomTime();
                    if (Double.isNaN(this.end)) {
                        this.end = CurrentTime.getInstance().nowJ2K();
                    }
                    this.before = this.end - (double)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.span * 60);
                    int tc = 30;
                    if (HelicorderViewerFrame.this.helicorderViewPanel != null) {
                        tc = ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.timeChunk;
                    }
                    if (!HelicorderViewerFrame.this.isClosed) {
                        this.hd = HelicorderViewerFrame.this.dataSource.getHelicorder(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel.replace(' ', '$'), this.before - (double)tc, this.end + (double)tc, HelicorderViewerFrame.this.gulperListener);
                        this.success = true;
                    } else {
                        this.success = false;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.println("getHelicorder() Error: " + e.getMessage());
                }
                finally {
                    HelicorderViewerFrame.this.working = false;
                }
                return null;
            }

            public void finished() {
                HelicorderViewerFrame.this.lastRefreshTime = System.currentTimeMillis();
                HelicorderViewerFrame.this.throbber.decrement();
                HelicorderViewerFrame.this.setNavigationButtonsEnabled(true);
                if (this.success) {
                    if (this.hd != null && this.hd.getEndTime() < this.before && !HelicorderViewerFrame.this.dataSource.isActiveSource()) {
                        double dt = this.end - this.before;
                        this.before = this.hd.getEndTime() - dt / 2.0;
                        this.end = this.hd.getEndTime() + dt / 2.0;
                        HelicorderViewerFrame.this.settings.setBottomTime(this.end);
                    }
                    HelicorderViewerFrame.this.helicorderViewPanel.setHelicorder(this.hd, this.before, this.end);
                    HelicorderViewerFrame.this.repaintHelicorder();
                }
            }
        };
        worker.start();
    }

    public Wave getWave(double t1, double t2) {
        return this.dataSource.getWave(this.settings.channel.replace(' ', '$'), t1, t2);
    }

    public SeismicDataSource getDataSource() {
        return this.dataSource;
    }

    private class CaptureActionListener
    implements ActionListener {
        private CaptureActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HelicorderViewerFrame.this.chooser = FileChooser.getFileChooser();
            HelicorderViewerFrame.this.chooser.setDialogTitle("Save Helicorder Screen Capture");
            HelicorderViewerFrame.this.chooser.setSelectedFile(new File("heli.png"));
            File lastPath = new File(swarmConfig.lastPath);
            HelicorderViewerFrame.this.chooser.setCurrentDirectory(lastPath);
            JPanel imagePanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            imagePanel.setBorder(new TitledBorder(new EtchedBorder(), "Image Properties"));
            JLabel heightLabel = new JLabel("Height:");
            JTextField heightTextField = new JTextField(4);
            heightLabel.setLabelFor(heightTextField);
            heightTextField.setText("700");
            JLabel widthLabel = new JLabel("Width:");
            JTextField widthTextField = new JTextField(4);
            widthLabel.setLabelFor(widthTextField);
            widthTextField.setText("900");
            JCheckBox includeChannel = new JCheckBox("Include channel");
            includeChannel.setSelected(true);
            JLabel fileFormatLabel = new JLabel("File format:");
            JComboBox<String> fileFormatCB = new JComboBox<String>();
            fileFormatCB.addItem("PNG");
            fileFormatCB.addItem("PS");
            fileFormatCB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    if (source.getSelectedItem().equals("PS")) {
                        String fn = HelicorderViewerFrame.this.chooser.getSelectedFile().getName().replaceAll("\\..*$", ".ps");
                        HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
                    } else {
                        String fn = HelicorderViewerFrame.this.chooser.getSelectedFile().getName().replaceAll("\\..*$", ".png");
                        HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
                    }
                }
            });
            imagePanel.add((Component)heightLabel, GridBagHelper.set(c, "x=0;y=0;w=1;h=1;wx=1;wy=0;ix=12;iy=2;a=nw;f=n;i=0,4,0,4"));
            imagePanel.add((Component)heightTextField, GridBagHelper.set(c, "x=1;y=0;w=1;h=1;wx=1;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)widthLabel, GridBagHelper.set(c, "x=0;y=1;w=1;h=1;wx=1;wy=0;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)widthTextField, GridBagHelper.set(c, "x=1;y=1;w=1;h=1;wx=1;ix=12;iy=2;f=n;i=0,4,0,4"));
            imagePanel.add((Component)fileFormatLabel, GridBagHelper.set(c, "x=0;y=2;w=1;h=1;wx=1;wy=0;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            imagePanel.add(fileFormatCB, GridBagHelper.set(c, "x=1;y=2;w=1;h=1;wx=1;wy=1;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            imagePanel.add((Component)includeChannel, GridBagHelper.set(c, "x=0;y=3;w=2;h=1;wx=1;wy=1;ix=12;iy=2;a=nw;f=w;i=0,4,0,4"));
            HelicorderViewerFrame.this.chooser.setAccessory(imagePanel);
            String fn = ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel.replace(' ', '_') + ".png";
            HelicorderViewerFrame.this.chooser.setSelectedFile(new File(HelicorderViewerFrame.this.chooser.getCurrentDirectory().getAbsoluteFile(), fn));
            int result = HelicorderViewerFrame.this.chooser.showSaveDialog(Swarm.getApplicationFrame());
            if (result == 0) {
                int choice;
                File f = HelicorderViewerFrame.this.chooser.getSelectedFile();
                if (f.exists() && (choice = JOptionPane.showConfirmDialog(Swarm.getApplicationFrame(), "File exists, overwrite?", "Confirm", 0)) != 0) {
                    return;
                }
                int width = -1;
                int height = -1;
                try {
                    width = Integer.parseInt(widthTextField.getText());
                    height = Integer.parseInt(heightTextField.getText());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (width <= 0 || height <= 0) {
                    JOptionPane.showMessageDialog(HelicorderViewerFrame.this, "Illegal width or height.", "Error", 0);
                    return;
                }
                Plot plot = new Plot(width, height);
                Double end = HelicorderViewerFrame.this.settings.getBottomTime();
                if (Double.isNaN(end)) {
                    end = CurrentTime.getInstance().nowJ2K();
                }
                Double before = end - (double)(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.span * 60);
                int tc = 30;
                HelicorderData heliData = HelicorderViewerFrame.this.dataSource.getHelicorder(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel, before - (double)tc, end + (double)tc, null);
                HelicorderRenderer heliRenderer = new HelicorderRenderer(heliData, ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.timeChunk);
                if (swarmConfig.heliColors != null) {
                    heliRenderer.setDefaultColors(swarmConfig.heliColors);
                }
                heliRenderer.setChannel(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                heliRenderer.setLocation(70, 10, width - 70 - 70, height - 10 - 35);
                heliRenderer.setHelicorderExtents(before, end, -1 * Math.abs(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barRange), Math.abs(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.barRange));
                heliRenderer.setTimeZone(swarmConfig.getTimeZone(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel));
                heliRenderer.setForceCenter(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.forceCenter);
                heliRenderer.setClipBars(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipBars);
                heliRenderer.setShowClip(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.showClip);
                heliRenderer.setClipValue(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.clipValue);
                heliRenderer.setChannel(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
                heliRenderer.setLargeChannelDisplay(includeChannel.isSelected());
                heliRenderer.createDefaultAxis();
                plot.addRenderer(heliRenderer);
                if (fileFormatCB.getSelectedItem().equals("PS")) {
                    plot.writePS(f.getAbsolutePath());
                } else {
                    try {
                        plot.writePNG(f.getAbsolutePath());
                    }
                    catch (PlotException e1) {
                        e1.printStackTrace();
                    }
                }
                swarmConfig.lastPath = f.getParent();
            }
            HelicorderViewerFrame.this.chooser.setAccessory(null);
        }
    }

    private class RefreshThread
    extends Thread {
        private boolean kill;

        public RefreshThread() {
            super("HeliRefresh-" + ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.channel);
            this.kill = false;
            this.setPriority(1);
            this.start();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        public void run() {
            while (!this.kill) {
                long now;
                boolean reset;
                int refreshInterval = ((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval == 0 || HelicorderViewerFrame.this.dataSource.getMinimumRefreshInterval() == 0 ? 0 : Math.max(((HelicorderViewerFrame)HelicorderViewerFrame.this).settings.refreshInterval, HelicorderViewerFrame.this.dataSource.getMinimumRefreshInterval());
                long lastUI = System.currentTimeMillis() - UiTime.getTime();
                boolean bl = reset = swarmConfig.isKiosk() && lastUI > 600000L;
                if (reset || !Double.isNaN(HelicorderViewerFrame.this.settings.getBottomTime()) && HelicorderViewerFrame.this.settings.getLastBottomTimeSet() > 600000L) {
                    HelicorderViewerFrame.this.helicorderViewPanel.removeWaveInset();
                    HelicorderViewerFrame.this.helicorderViewPanel.clearMarks();
                    HelicorderViewerFrame.this.settings.setBottomTime(Double.NaN);
                    if (swarmConfig.isKiosk() && !Swarm.isFullScreenMode()) {
                        Swarm.getApplication().toggleFullScreenMode();
                    }
                }
                try {
                    now = System.currentTimeMillis();
                    long sleepTime = Math.min(now - HelicorderViewerFrame.this.lastRefreshTime, (long)(refreshInterval * 1000));
                    if (refreshInterval > 0) {
                        Thread.sleep(sleepTime);
                    } else {
                        Thread.sleep(30000L);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                if (this.kill || refreshInterval <= 0 || now - HelicorderViewerFrame.this.lastRefreshTime <= (long)(refreshInterval * 1000)) continue;
                try {
                    double bt = HelicorderViewerFrame.this.settings.getBottomTime();
                    if (!HelicorderViewerFrame.this.dataSource.isActiveSource() || !Double.isNaN(bt) || HelicorderViewerFrame.this.working) continue;
                    HelicorderViewerFrame.this.getHelicorder();
                }
                catch (Exception e) {
                    System.err.println("Exception during refresh:");
                    e.printStackTrace();
                }
            }
        }
    }
}

