/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.rsam;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.HistogramRenderer;
import gov.usgs.plot.render.MatrixRenderer;
import gov.usgs.plot.render.ShapeRenderer;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.SwingWorker;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettings;
import gov.usgs.volcanoes.swarm.rsam.SettingsListener;
import gov.usgs.volcanoes.swarm.time.UiTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RsamViewPanel
extends JComponent
implements SettingsListener {
    public static final long serialVersionUID = -1L;
    private static final Color BACKGROUND_COLOR = new Color(247, 247, 247);
    private static final int X_OFFSET = 60;
    private static final int Y_OFFSET = 20;
    private static final int RIGHT_WIDTH = 60;
    private static final int BOTTOM_HEIGHT = 20;
    private RSAMData data;
    private double startTime;
    private double endTime;
    private RsamViewSettings settings;
    private String channel;
    private Color bottomBorderColor;
    private static Image closeImg;
    private boolean allowClose;
    private boolean working;
    private BufferedImage image;
    private Color borderColor;

    public RsamViewPanel() {
        this(new RsamViewSettings());
        this.settings.addListener(this);
    }

    public RsamViewPanel(RsamViewSettings s) {
        this.settings = s;
        this.setupMouseHandler();
        this.settings.addListener(this);
    }

    private void setupMouseHandler() {
        Cursor crosshair = new Cursor(1);
        this.setCursor(crosshair);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                UiTime.touchTime();
                if (SwingUtilities.isRightMouseButton(e)) {
                    RsamViewPanel.this.settings.cycleType();
                }
            }
        });
    }

    public void setWorking(boolean b) {
        this.working = b;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String c) {
        this.channel = c;
    }

    public void settingsChanged() {
        this.processSettings();
    }

    public void setData(RSAMData data, double st, double et) {
        this.data = data;
        this.startTime = st;
        this.endTime = et;
        this.processSettings();
    }

    private synchronized void setImage(BufferedImage bi) {
        this.image = bi;
    }

    private synchronized BufferedImage getImage() {
        return this.image;
    }

    private void createImage() {
        final Runnable r = new Runnable(){

            public void run() {
                if (RsamViewPanel.this.getWidth() > 0 && RsamViewPanel.this.getHeight() > 0) {
                    BufferedImage bi = new BufferedImage(RsamViewPanel.this.getWidth(), RsamViewPanel.this.getHeight(), 6);
                    Graphics2D ig = (Graphics2D)bi.getGraphics();
                    RsamViewPanel.this.constructPlot(ig);
                    RsamViewPanel.this.setImage(bi);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    r.run();
                    return null;
                }

                public void finished() {
                    RsamViewPanel.this.repaint();
                }
            };
            worker.start();
        } else {
            r.run();
        }
    }

    private void processSettings() {
        if (this.data == null || this.data.getData() == null || this.data.getData().rows() == 0) {
            return;
        }
        this.createImage();
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        if (this.data == null || this.settings.getType() == RsamViewSettings.ViewType.VALUES && this.data.getPeriod() != this.settings.valuesPeriodS || this.settings.getType() == RsamViewSettings.ViewType.COUNTS && this.data.getPeriod() != this.settings.countsPeriodS) {
            g2.setColor(BACKGROUND_COLOR);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
            if (this.working) {
                g2.drawString("Retrieving data...", dim.width / 2 - 50, dim.height / 2);
            } else {
                String error = "No RSAM data.";
                if (this.channel != null) {
                    error = "No RSAM data for " + this.channel + ".";
                }
                int w = g2.getFontMetrics().stringWidth(error);
                g2.drawString(error, dim.width / 2 - w / 2, dim.height / 2);
            }
        } else {
            BufferedImage bi = this.getImage();
            if (bi != null) {
                g2.drawImage((Image)bi, 0, 0, null);
            }
        }
        if (this.allowClose) {
            if (closeImg == null) {
                closeImg = Icons.close_view.getImage();
            }
            g2.drawImage(closeImg, dim.width - 17, 3, null);
        }
        if (this.bottomBorderColor != null) {
            g2.setColor(this.bottomBorderColor);
            g2.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
        if (this.borderColor != null) {
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, dim.width - 1, dim.height - 2);
        }
    }

    private synchronized void constructPlot(Graphics2D g2) {
        Dimension dim = this.getSize();
        Plot plot = new Plot();
        plot.setBackgroundColor(BACKGROUND_COLOR);
        plot.setSize(dim);
        switch (this.settings.getType()) {
            case VALUES: {
                this.plotValues(plot, this.data);
                break;
            }
            case COUNTS: {
                this.plotCounts(plot, this.data);
            }
        }
        try {
            plot.render(g2);
        }
        catch (PlotException e) {
            e.printStackTrace();
        }
    }

    private void plotValues(Plot plot, RSAMData data) {
        double min;
        double max;
        if (data == null || data.getData() == null || data.getData().rows() == 0) {
            return;
        }
        GenericDataMatrix gdm = new GenericDataMatrix(data.getData().copy());
        gdm.despike(1, this.settings.valuesPeriodS);
        if (this.settings.detrend) {
            gdm.detrend(1);
        }
        if (this.settings.runningMedian) {
            gdm.set2median(1, this.settings.runningMedianPeriodS);
        }
        if (this.settings.runningMean) {
            gdm.set2mean(1, this.settings.runningMeanPeriodS);
        }
        MatrixRenderer mr = new MatrixRenderer(gdm.getData(), false);
        if (this.settings.getAutoScale()) {
            max = gdm.max(1) + gdm.max(1) * 0.1;
            min = gdm.min(1) - gdm.max(1) * 0.1;
        } else {
            max = this.settings.scaleMax;
            min = this.settings.scaleMin;
        }
        mr.setExtents(this.startTime, this.endTime, min, max);
        mr.setLocation(60, 20, this.getWidth() - 60 - 60, this.getHeight() - 20 - 20);
        mr.createDefaultAxis();
        mr.setXAxisToTime(8, true, true);
        mr.getAxis().setLeftLabelAsText("RSAM Values", -55.0f, Color.BLACK);
        mr.createDefaultLineRenderers(Color.blue);
        plot.addRenderer(mr);
    }

    private void plotCounts(Plot plot, RSAMData data) {
        if (data == null || data.getData() == null || data.getData().rows() == 0 || data.getPeriod() != this.settings.countsPeriodS) {
            return;
        }
        data.countEvents(this.settings.eventThreshold, this.settings.eventRatio, this.settings.eventMaxLengthS);
        HistogramRenderer hr = new HistogramRenderer(data.getCountsHistogram(this.settings.binSize));
        hr.setLocation(60, 20, this.getWidth() - 60 - 60, this.getHeight() - 20 - 20);
        hr.setDefaultExtents();
        hr.setMinX(this.startTime);
        hr.setMaxX(this.endTime);
        hr.createDefaultAxis(8, 8, true, true, false, true, true, true);
        hr.setXAxisToTime(8, true, true);
        hr.getAxis().setLeftLabelAsText("Events per " + (Object)((Object)this.settings.binSize), -55.0f, Color.BLACK);
        DoubleMatrix2D countsData = data.getCumulativeCounts();
        if (countsData != null && countsData.rows() > 0) {
            double cmin = countsData.get(0, 1);
            double cmax = countsData.get(countsData.rows() - 1, 1);
            MatrixRenderer mr = new MatrixRenderer(countsData, false);
            mr.setAllVisible(true);
            mr.setLocation(60, 20, this.getWidth() - 60 - 60, this.getHeight() - 20 - 20);
            mr.setExtents(this.startTime, this.endTime, cmin, cmax + 1.0);
            mr.createDefaultLineRenderers(Color.RED);
            ShapeRenderer[] r = mr.getLineRenderers();
            r[0].color = Color.RED;
            r[0].stroke = new BasicStroke(2.0f);
            AxisRenderer ar = new AxisRenderer(mr);
            ar.createRightTickLabels(SmartTick.autoTick(cmin, cmax, 8, false), null);
            mr.setAxis(ar);
            hr.addRenderer(mr);
            hr.getAxis().setRightLabelAsText("Cumulative Counts");
        }
        plot.addRenderer(hr);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }
}

