/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.rsam;

import gov.usgs.math.BinSize;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.rsam.SettingsListener;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class RsamViewSettings {
    private static final String DEFAULTS_FILENAME = "RsamDefaults.config";
    public int valuesPeriodS;
    public int countsPeriodS;
    public boolean detrend;
    public boolean runningMedian;
    public double runningMedianPeriodS;
    public boolean runningMean;
    public double runningMeanPeriodS;
    public int eventThreshold;
    public double eventRatio;
    public double eventMaxLengthS;
    public BinSize binSize;
    private boolean autoScale;
    public int scaleMax;
    public int scaleMin;
    private int spanLengthS;
    private ViewType viewType;
    private static RsamViewSettings DEFAULT_RSAM_VIEW_SETTINGS;
    private Set<SettingsListener> listeners;

    public RsamViewSettings() {
        if (DEFAULT_RSAM_VIEW_SETTINGS != null) {
            this.copy(DEFAULT_RSAM_VIEW_SETTINGS);
        }
        this.listeners = new HashSet<SettingsListener>();
    }

    public void copy(RsamViewSettings s) {
        this.viewType = s.viewType;
        this.valuesPeriodS = s.valuesPeriodS;
        this.countsPeriodS = s.countsPeriodS;
        this.detrend = s.detrend;
        this.runningMedian = s.runningMedian;
        this.runningMedianPeriodS = s.runningMedianPeriodS;
        this.runningMean = s.runningMean;
        this.runningMeanPeriodS = s.runningMeanPeriodS;
        this.eventRatio = s.eventRatio;
        this.eventThreshold = s.eventThreshold;
        this.eventMaxLengthS = s.eventMaxLengthS;
        this.binSize = s.binSize;
        this.autoScale = s.autoScale;
        this.scaleMax = s.scaleMax;
        this.scaleMin = s.scaleMin;
    }

    public void set(ConfigFile cf) {
        this.viewType = ViewType.valueOf(cf.getString("viewType"));
        this.valuesPeriodS = Util.stringToInt(cf.getString("valuesPeriod"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.valuesPeriodS);
        this.countsPeriodS = Util.stringToInt(cf.getString("countsPeriod"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.countsPeriodS);
        this.detrend = Util.stringToBoolean(cf.getString("detrend"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.detrend);
        this.runningMedian = Util.stringToBoolean(cf.getString("runningMedian"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMedian);
        this.runningMedianPeriodS = Util.stringToDouble(cf.getString("runningMedianPeriod"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMedianPeriodS);
        this.runningMean = Util.stringToBoolean(cf.getString("runningMean"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMean);
        this.runningMeanPeriodS = Util.stringToDouble(cf.getString("runningMeanPeriod"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMeanPeriodS);
        this.eventRatio = Util.stringToDouble(cf.getString("eventRatio"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventRatio);
        this.eventThreshold = Util.stringToInt(cf.getString("eventThreshold"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventThreshold);
        this.eventMaxLengthS = Util.stringToDouble(cf.getString("eventMaxLength"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventMaxLengthS);
        this.binSize = BinSize.fromString(cf.getString("binSize"));
        this.autoScale = Util.stringToBoolean(cf.getString("autoScale"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.autoScale);
        this.scaleMax = Util.stringToInt(cf.getString("scaleMax"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.scaleMax);
        this.scaleMin = Util.stringToInt(cf.getString("scaleMin"), RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.scaleMin);
    }

    public void save(ConfigFile cf, String prefix) {
        cf.put(prefix + ".valuesPeriod", Integer.toString(this.valuesPeriodS));
        cf.put(prefix + ".countsPeriod", Integer.toString(this.countsPeriodS));
        cf.put(prefix + ".viewType", this.viewType.toString());
        cf.put(prefix + ".detrend", Boolean.toString(this.detrend));
        cf.put(prefix + ".runningMedian", Boolean.toString(this.runningMedian));
        cf.put(prefix + ".runningMedianPeriod", Double.toString(this.runningMedianPeriodS));
        cf.put(prefix + ".runningMean", Boolean.toString(this.runningMean));
        cf.put(prefix + ".runningMeanPeriod", Double.toString(this.runningMeanPeriodS));
        cf.put(prefix + ".eventRatio", Double.toString(this.eventRatio));
        cf.put(prefix + ".eventThreshold", Double.toString(this.eventThreshold));
        cf.put(prefix + ".eventMaxLength", Double.toString(this.eventMaxLengthS));
        cf.put(prefix + ".binSize", this.binSize.toString());
        cf.put(prefix + ".autoScale", Boolean.toString(this.autoScale));
        cf.put(prefix + ".scaleMax", Double.toString(this.scaleMax));
        cf.put(prefix + ".scaleMin", Double.toString(this.scaleMin));
    }

    public void setSpanLength(int spanLengthS) {
        this.spanLengthS = spanLengthS;
        this.notifyListeners();
    }

    public int getSpanLength() {
        return this.spanLengthS;
    }

    public void setType(ViewType t) {
        this.viewType = t;
        this.notifyListeners();
    }

    public ViewType getType() {
        return this.viewType;
    }

    public void setAutoScale(boolean isAutoScale) {
        this.autoScale = isAutoScale;
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void cycleType() {
        switch (this.viewType) {
            case VALUES: {
                this.viewType = ViewType.COUNTS;
                break;
            }
            case COUNTS: {
                this.viewType = ViewType.VALUES;
            }
        }
        this.notifyListeners();
    }

    public void addListener(SettingsListener l) {
        this.listeners.add(l);
    }

    private void notifyListeners() {
        for (SettingsListener l : this.listeners) {
            l.settingsChanged();
        }
    }

    static {
        ConfigFile cf;
        DEFAULT_RSAM_VIEW_SETTINGS = new RsamViewSettings();
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.viewType = ViewType.VALUES;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.valuesPeriodS = 600;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.countsPeriodS = 10;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.detrend = false;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMedian = false;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMedianPeriodS = 300.0;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMean = false;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.runningMeanPeriodS = 300.0;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventThreshold = 50;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventRatio = 1.3;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.eventMaxLengthS = 300.0;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.binSize = BinSize.HOUR;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.spanLengthS = 604800;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.autoScale = true;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.scaleMax = 100;
        RsamViewSettings.DEFAULT_RSAM_VIEW_SETTINGS.scaleMin = 0;
        LinkedList<String> candidateNames = new LinkedList<String>();
        candidateNames.add(DEFAULTS_FILENAME);
        candidateNames.add(System.getProperty("user.home") + File.separatorChar + DEFAULTS_FILENAME);
        String defaultsFile = ConfigFile.findConfig(candidateNames);
        if (defaultsFile == null) {
            defaultsFile = DEFAULTS_FILENAME;
        }
        if ((cf = new ConfigFile(defaultsFile)).wasSuccessfullyRead()) {
            ConfigFile sub = cf.getSubConfig("default");
            DEFAULT_RSAM_VIEW_SETTINGS.set(sub);
        } else {
            DEFAULT_RSAM_VIEW_SETTINGS.save(cf, "default");
            cf.writeToFile(DEFAULTS_FILENAME);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        VALUES,
        COUNTS;

    }
}

